#include "PartitionInfo.h"
#include "RoundRobinPartitioner.h"
#include "warped.h"

RoundRobinPartitioner::RoundRobinPartitioner(){}

const PartitionInfo *
RoundRobinPartitioner::partition( const vector<SimulationObject *> *objects,
				  const unsigned int numLPsAvailable ) const {
  unsigned int numLPs = numLPsAvailable;
  if( numLPs > objects->size() && objects->size() > 0 ){
    numLPs = objects->size();
  }

  PartitionInfo *myPartitionInfo = new PartitionInfo( numLPs );

  unsigned int numLeft = objects->size();
  unsigned int numObjectsPerProcessor = objects->size() / numLPs;
  for( unsigned int i = 0; i < numLPs; i++ ){
    unsigned int numObjectsThisProcessor = numObjectsPerProcessor;
    if( i == numLPs - 1 ){
      // This is the last one - we need to assign the rest of the objects
      numObjectsThisProcessor = numLeft;
    }
    vector <SimulationObject *> *newVector = new vector <SimulationObject *>;
    for( unsigned int j = 0; j < numObjectsThisProcessor; j++ ){
      newVector->push_back( (*objects)[numLeft-1] );
      numLeft--;
    }
    myPartitionInfo->addPartition( i, newVector );
  }
  ASSERT( numLeft == 0 );

  return myPartitionInfo;
}
