dnl
dnl Check for pccts header (antlr and dlg) and header files needed
dnl by files generated by these tools
dnl
dnl Usage: CL_PROG_HEADERS
dnl
AC_DEFUN([CL_PCCTS_HEADERS],
[
AC_CACHE_CHECK([for PCCTS includes], [cl_cv_path_pcctsheaders],
  [AC_ARG_WITH(pccts-headers,
    AC_HELP_STRING([--with-pccts-headers],
      [specify location of PCCTS headers (default is /usr/include/pccts)]),
    [
      case "${withval}" in
        yes)  cl_cv_path_pcctsheaders=/usr/include/pccts ;;
        no)   cl_cv_path_pcctsheaders=no ;;
        *)    cl_cv_path_pcctsheaders=$withval ;;
      esac
    ],
    [cl_cv_path_pcctsheaders=/usr/include/pccts]
  )]
)

if test $cl_cv_path_pcctsheaders = no; then
AC_MSG_ERROR(PCCTS includes required.  Please specify the location with
the --with-pccts-headers option.)
fi
CPPFLAGS="$CPPFLAGS -I$cl_cv_path_pcctsheaders"
AC_CHECK_HEADER(AParser.h, ,
  AC_MSG_ERROR(Could not find PCCTS headers.
    Please specify the correct location with the --with-pccts-headers option.))
PCCTSROOT=$cl_cv_path_pcctsheaders

]) dnl end CL_	PROG_PCCTS


dnl
dnl Check for libclutils
dnl
dnl Usage: CL_LIB_CLUTILS
dnl
AC_DEFUN([CL_LIB_CLUTILS],
[
AC_CACHE_CHECK([for location of libclutils], [cl_cv_lib_clutils],
  [AC_ARG_WITH(clutils,
    AC_HELP_STRING([--with-clutils],
      [location of libclutils (default is /usr)]),
      [
        case "${withval}" in
          yes)  cl_cv_lib_clutils=/usr ;;
          no)   cl_cv_lib_clutils=no ;;
          *)    cl_cv_lib_clutils=$withval ;;
        esac
      ],
      [cl_cv_lib_clutils=/usr]
  )]
)
if test $cl_cv_lib_clutils = no ; then
AC_MSG_ERROR(The clutils package is required.)
fi
if test $cl_cv_lib_clutils != /usr ; then
LDFLAGS="$LDFLAGS -L$cl_cv_lib_clutils/lib"
CPPFLAGS="$CPPFLAGS -I$cl_cv_lib_clutils/include"
fi
AC_CHECK_HEADER(clutils/Debug.h, ,
  AC_MSG_ERROR(Couldn't find clutils/Debug.h which is required and 
    part of the clutils distribution.  You probably need to install it
    and/or specify the location of it with the --with-clutils option.))
AC_SEARCH_LIBS(dlopen, [dl])
AC_CHECK_LIB(clutils, isClutils, ,
  AC_MSG_ERROR(Could not find a workable libclutils.so or libclutils.a.
    You probably need to install clutils and/or specify the location of
    it with the --with-clutils option.), -lltdl)
]) dnl end CL_LIB_CLUTILS

dnl Check for cppunit

dnl Usage: CL_LIB_CPPUNIT

AC_DEFUN([CL_LIB_CPPUNIT],
[
AC_CACHE_CHECK([for location of libcppunit], [cl_cv_lib_cppunit],
  [AC_ARG_WITH(cppunit,
    AC_HELP_STRING([--with-cppunit],
      [location of libcppunit (default is /usr)]),
      [
        case "${withval}" in
          yes)  cl_cv_lib_cppunit=/usr; ;;
          no)   cl_cv_lib_cppunit=no ;;
          "")   cl_cv_lib_cppunit=no ;;
          *)    cl_cv_lib_cppunit=$withval ;;
        esac
      ],
      [cl_cv_lib_cppunit=/usr]
  )]
)

if test $cl_cv_lib_cppunit = no ; then
   Disable the build of the unit tests
  AC_MSG_ERROR("cpp_unit_disabled via --with-cppunit")
  AC_SUBST(CPP_UNIT_TEST_DIR, "")
  return;
fi

if test $cl_cv_lib_cppunit != /usr ; then
LDFLAGS="$LDFLAGS -L$cl_cv_lib_cppunit/lib"
CPPFLAGS="$CPPFLAGS -I$cl_cv_lib_cppunit/include"
fi

dnl We might want to add addition checks for CPPUNIT headers later
AC_CHECK_HEADER(cppunit/Test.h, ,
  AC_MSG_WARN(Couldn't find cppunit/TestCase.h which is optional but
    required to run the unit tests in the 'test' directory. This file is
    part of the cppunit distribution.  You probably need to install it
    and/or specify the location of it with the --with-cppunit option.))

dnl Check for the CPPUNIT library
AC_CHECK_LIB(cppunit, main, 
  [AC_SUBST(CPP_UNIT_TEST_DIR,[test]) \
        LIBS="$LIBS -lcppunit"], 
  [AC_SUBST(CPP_UNIT_TEST_DIR, "") \
  AC_MSG_WARN(Couldn't find cppunit library which is optional but
    required to run the unit tests in the 'test' directory. This file is
    part of the cppunit distribution.  You probably need to install it
    and/or specify the location of it with the --with-cppunit option.)
        ])
]) dnl end CL_LIB_WARPED
