#ifndef SENSOR_IMPLEMENTATION_BASE_H
#define SENSOR_IMPLEMENTATION_BASE_H

// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "Sensor.h"

/** The SensorImplementationBase base class.

    The SensorImplementationBase base class represents the base class
    from which all sensor implementations are derived from. It also
    contains all data/methods that are common to all sensor
    implementations.

*/
template <class NormalType>
class SensorImplementationBase : public Sensor {
public:

   /**@name Public Class Methods of SensorImplementationBase */
   //@{

   /// Default constructor
   SensorImplementationBase(string name,
                            sensorStatus currentStatus=SENSOR_INACTIVE,
                            sensorType currentType=SCALAR_SENSOR)
      : sensorName(name), status(currentStatus), sensor_type(currentType){};

   /// Default Destructor
   virtual ~SensorImplementationBase(){};

   /// make the sensor active
   virtual void makeSensorActive(){
      status = SENSOR_ACTIVE;
   };

   /// make the sensor inactive
   virtual void makeSensorInActive(){
      status = SENSOR_INACTIVE;
   };

   /// is the sensor currently active
   virtual bool isSensorActive(){
      return (status == SENSOR_ACTIVE ? true : false);
   };
   
   //@} // End of Public Class Methods of SensorImplementationBase

protected:

   /**@name Protected Class Attributes of SensorImplementationBase */
   //@{

   /// the name of the sensor
   string sensorName;

   /// is the sensor active or inactive
   sensorStatus status;

   /// what type of sensor is it
   sensorType sensor_type;
   
   //@} // End of Protected Class Attributes of SensorImplementationBase

};

#endif
