#ifndef MATTERN_GVT_MANAGER_H
#define MATTERN_GVT_MANAGER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "GVTManagerImplementationBase.h"
#include "GVTManagerObjectRecord.h"

class MatternObjectRecord;
class SchedulingManager;
class CommunicationManager;

/** The MatternGVTManager class.

    This class implements a GVT Estimation algorithms originally
    defined by Mattern. It is essentially a distributed termination
    algorithm that has been modified for use as an GVT estimation
    scheme.

*/
class MatternGVTManager : public GVTManagerImplementationBase {

public:

  /**@name Public Class Methods of MatternGVTManager. */
  //@{

  /// Default Constructor
  MatternGVTManager( TimeWarpSimulationManager *simMgr, unsigned int period );

  /// Destructor
  ~MatternGVTManager();

  /// calculate any gvt manager specific info
  void calculateGVTInfo();

  /// get any gvt manager specific info 
  const string getGVTInfo(unsigned int srcSimMgr, unsigned int destSimMgr, const VTime &sendTime);
  
  /// update this simulation manager's record of events it sent out 
  void updateEventRecord( const string &infoStream, unsigned int srcSimMgr );

  /** Calculate the actual value of GVT.
       
      This function should only be called in the function that is
      responsible for the calculation of the "real" gVT.  It is
      assumed that simulation manager 0 is responsible for gVT
      calculation.
       
  */
  void calculateGVT();

  /// update everybody in the simulation with the new GVT value
  void sendGVTUpdate();

  /// register GVTManager specific message types with the comm. manager
  void registerWithCommunicationManager();

  /// the method the communication manager will call to deliver messages
  void receiveKernelMessage(KernelMessage *msg);
  
  //@} // End of Public Class Methods of MatternGVTManager.
   
private:

  /**@name Private Class Attributes of MatternGVTManager. */
  //@{

  /// boolean flag that indicates if a gVTToken is in circulation or not
  bool gVTTokenPending;

  /// handle to the scheduler
  SchedulingManager *myScheduler;

  /// handle to the communication manager
  CommunicationManager *myCommunicationManager;

  /// the data structure that keeps track of sent and received messages
  MatternObjectRecord objectRecord;

  //@} // End of Private Class Attributes of MatternGVTManager.

  /**@name Private Class Methods of MatternGVTManager. */
  //@{

  /// dispatch the GVTTokenMessage to the next simulation manager
  void sendGVTToken(const VTime &lastScheduledEventTime,
		    const VTime &minTimeStamp);

  //@} // End of Private Class Methods of MatternGVTManager.

};

#endif
