// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: Event.cpp
// 
//---------------------------------------------------------------------------

#include "Event.h"
#include "EventId.h"
#include "SerializedInstance.h"

Event::~Event(){}

ostream&
operator<<(ostream& os, const Event& event) {
   os << "sender: " << event.getSender() 
      << " receiver: " << event.getReceiver()
      << " sendTime: " << event.getSendTime()
      << " receiveTime: " << event.getReceiveTime()
      << " eventId: " << event.getEventId();
   return(os);
}

bool 
Event::compareEvents( const Event *a, const Event *b ){
  bool retval = true;

  if( a->getSender() != b->getSender() ||
      a->getSendTime() != b->getSendTime() ||
      a->getReceiver() != a->getReceiver() ||
      a->getReceiveTime() != b->getReceiveTime() ){
    retval = false;
  }

  return retval;
}

void 
Event::serialize( SerializedInstance *addTo ) const {
  addTo->addSerializable( &getSendTime() );
  addTo->addSerializable( &getReceiveTime() );
  addTo->addString( getSender() );
  addTo->addString( getReceiver() );
  addTo->addUnsigned( getEventId().val );
}

