#ifndef DESERIALIZER_MANAGER_H
#define DESERIALIZER_MANAGER_H

// Copyright (c) Clifton Labs, Inc.
// All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors:
//          Dale E. Martin              dmartin@cliftonlabs.com

#include <clutils/StringHashMap.h>

class Deserializer;
class Serializable;
class SerializedInstance;

typedef Serializable *(*deserializeFunc)(SerializedInstance * );

class DeserializerManager {
public:
  /**
     Each serializable type should register with the DeserializerManager
     singleton before attempting to deserialize.  Typically a static code
     
  */
  void registerDeserializer( const string &dataType, deserializeFunc );

  deserializeFunc findDeserializer( const string &dataType );

  static DeserializerManager *instance();

protected:
  ~DeserializerManager(){}


private:
  StringHashMap<deserializeFunc> deserializerMap;

  DeserializerManager(){}
};

#endif
