#ifndef DEFAULT_PHYSICAL_COMMUNICATION_LAYER_H
#define DEFAULT_PHYSICAL_COMMUNICATION_LAYER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "eclmpl/PhysicalCommunicationLayer.h"

/** The DefaultPhysicalCommunicationLayer class.

    This is a default physical communication layer, derived from the
    PhysicalCommunicationLayer abstract interface class. This
    communication layer assumes that a uniprocessor is used and that
    no physical communication layer is actually used. Thus, none of
    the methods in the class have any work to do.
 */
class DefaultPhysicalCommunicationLayer : public PhysicalCommunicationLayer {
public:
  /**@name Public Class Methods of DefaultPhysicalCommunicationLayer. */
  //@{

  /// Default Constructor.
  DefaultPhysicalCommunicationLayer();

  /// Destructor.
  ~DefaultPhysicalCommunicationLayer();

  /** Initialize the physical communication layer.

      @param configuration The SimulationConfiguration to use for this run.
  */
  void physicalInit( SimulationConfiguration &configuration );

  /** Get the Id of the simulation manager.

      @return Id of the simulation manager.
  */
  int physicalGetId() const;

  /** Send buffer.

      @param buffer Char buffer to send.
      @param size Size of the buffer to send.
      @param dest destination simulation manager
  */
  void physicalSend( const SerializedInstance *toSend, unsigned int dest);


  /** Check the probe to see if there are message to retrieve.

      @return The retrieved message (NULL if no message).
  */
  SerializedInstance *physicalProbeRecv();

//   /** Retrieve message into a buffer.

//       @param buffer Buffer to which we save the message.
//       @param size Size of the buffer.
//       @param sizeStatus Was the size of retr. msg > size?
//       @return True/False, Was any message retrieved?
//   */
//   bool physicalProbeRecvBuffer(char *buffer, int size, bool& sizeStatus);

  /// Clean up.
  void physicalFinalize();

  //@} // End of Public Class Methods of DefaultPhysicalCommunicationLayer.
};

#endif
