// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
//
// $Id: ConfigurationManagerFactory.cpp,v 1.7 2003/10/13 14:10:00 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "ConfigurationManagerFactory.h"
#include "SequentialConfigurationManager.h"
#include "TimeWarpConfigurationManager.h"
#include "Application.h"
#include "SimulationConfiguration.h"
#include <clutils/ConfigurationScope.h>
#include <clutils/ConfigurationChoice.h>
#include <clutils/Debug.h>

using clutils::debug;

const ConfigurationManagerFactory *
ConfigurationManagerFactory::instance(){
  static const ConfigurationManagerFactory *retval = new ConfigurationManagerFactory();

  return retval;
}

Configurable *
ConfigurationManagerFactory::allocate( SimulationConfiguration &configuration,
				       Configurable *parent ) const {
  Configurable *retval = 0;

  if( configuration.simulationTypeIs( "Sequential" )){
    retval = new SequentialConfigurationManager( (Application *)parent );
    debug << "Configured a SequentialSimulationManager" << endl;
  }
  else if( configuration.simulationTypeIs( "TimeWarp" ) ){
    retval = new TimeWarpConfigurationManager( configuration.getArguments(),
					       (Application *)parent );
    debug << "Configured a TimeWarpSimulationManager" << endl;
  }
  else {
    cerr << "Unknown Simulation type \"" << configuration.getSimulationType()
	 << "\"" << endl;
    exit( -1 );
  }

  return retval;
}
