/* VIPS display class.
 *
 * Hide details of im_col_display API.
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifndef IM_VDISPLAY_H
#define IM_VDISPLAY_H

// Wrapper over im_col_display with ref counting
class VDisplay {
	struct refblock {
		void *disp;		// im_col_display struct
		void *luts;		// luts built from this display
		int priv;		// disp is ours, or system
		int nrefs;		// Refs to us

		// Invalidate lut
		void cleanlut();

		// Break attached stuff
		void cleanref();

		// Get ready to write
		void wready();

		// Check that luts are up-to-date
		void cluts();

		refblock() { nrefs = 1; disp = 0; luts = 0; priv = 0; }
		~refblock() { cleanref(); }
	};

	refblock *ref;

public:
	enum VDisplayType {
		BARCO,			// Does many corrections for us
		DUMB			// Needs many corrections
	};

	// Get named display
	VDisplay( const char *name );

	// Get default display
	VDisplay();

	// Copy constructor 
	VDisplay( const VDisplay &a ) { ref = a.ref; ref->nrefs++; }

	// Assignment
	VDisplay &operator=( const VDisplay &a );

	// Destructor
	~VDisplay();

	// The matrix type we use
	typedef float matrix[3][3];

	// Change fields in display
	char *name();
	VDisplayType &type();
	matrix &mat();
	float &YCW();
	float &xCW();
	float &yCW();
	float &YCR();
	float &YCG();
	float &YCB();
	int &Vrwr();
	int &Vrwg();
	int &Vrwb();
	float &Y0R();
	float &Y0G();
	float &Y0B();
	float &gammaR();
	float &gammaG();
	float &gammaB();
	float &B();
	float &P();

	// Extract display pointer
	void *disp() const { return( ref->disp ); }

	// Extract luts pointer, rebuilding luts if necessary
	void *luts() const { ref->cluts(); return( ref->luts ); }
};

#endif /*IM_VDISPLAY_H*/
