# Change Log

This is the Changelog for the vim-airline project.

## [Unreleased]

## [0.9] - 2018-01-15
- Changes
  - Look of default Airline Symbols has been improved [#1397](https://github.com/vim-airline/vim-airline/issues/1397)
  - Airline does now set `laststatus=2` if needed
  - Syntastic extension now displays warnings and errors separately
  - Updates on Resize and SessionLoad events
  - Add `maxlinenr` symbol to `airline_section_z`
  - Add quickfix title to inactive windows
- Improvements
  - Many performance improvements (using caching and async feature when possible)
  - Cache changes to highlighting groups if `g:airline_highlighting_cache = 1` is set
  - Allow to skip empty sections by setting `g:airline_skip_empty_sections` variable
  - Make use of improved Vim Script API, if available (e.g. getwininfo())
  - Support for Vims terminal feature (very experimental since it hasn't been stabilized yet)
  - More configuration for the tabline extension (with clickable buffers for Neovim)
  - Works better on smaller window sizes
  - Make airline aware of git worktrees
  - Improvements to the fugitive extension [#1603](https://github.com/vim-airline/vim-airline/issues/1603)
  - Allows for configurable fileformat output if `g:airline#parts#ffenc#skip_expected_string` is set
  - Improvements to the documentation
- New features
  - Full async support for Vim 8 and Neovim
  - Extensions:
    - [vim-bufmru](https://github.com/mildred/vim-bufmru)
    - [xkb-switch](https://github.com/ierton/xkb-switch)
    - [input-source-switcher](https://github.com/vovkasm/input-source-switcher)
    - [vimagit](https://github.com/jreybert/vimagit)
    - [denite](https://github.com/Shougo/denite.nvim)
    - [dein](https://github.com/Shougo/dein.vim)
    - [vimtex](https://github.com/lervag/vimtex)
    - [minpac](https://github.com/k-takata/minpac/)
    - [vim-cursormode](https://github.com/vheon/vim-cursormode)
    - [Neomake](https://github.com/neomake/neomake)
    - [Ale](https://github.com/w0rp/ale)
    - [vim-obsession](https://github.com/tpope/vim-obsession)
    - spell (can also display Spell language)
    - keymap
  - Formatters:
    - Formatters for JavaScript [#1617](https://github.com/vim-airline/vim-airline/issues/1617)
    - Tabline: Allow for custom formatter for `tab_nr_type` [#1418](https://github.com/vim-airline/vim-airline/issues/1418)
    - Customizable wordcount formatter [#1584](https://github.com/vim-airline/vim-airline/issues/1584)
  - Add User autocommand for Theme changing [#1226](https://github.com/vim-airline/vim-airline/issues/1226)
  - Shows mercurial mq status if hg mq extension is enabled

## [0.8] - 2016-03-09
- Changes
  - Airline converted to an organization and moved to new [repository](https://github.com/vim-airline/vim-airline)
  - Themes have been split into an separate repository [vim-airline-themes](https://github.com/vim-airline/vim-airline-themes)
- Improvements
  - Extensions
    - branch: support Git and Mercurial simultaneously, untracked files
    - whitespace: new mixed-indent rule
  - Windows support
  - Many bug fixes
  - Support for Neovim
- New features
  - Many new themes
  - Extensions/integration
    - [taboo](https://github.com/gcmt/taboo.vim)
    - [vim-ctrlspace](https://github.com/szw/vim-ctrlspace)
    - [quickfixsigns](https://github.com/tomtom/quickfixsigns_vim)
    - [YouCompleteMe](https://github.com/Valloric/YouCompleteMe)
    - [po.vim](http://www.vim.org/scripts/script.php?script_id=695)
    - [unicode.vim](https://github.com/chrisbra/unicode.vim)
    - wordcount
    - crypt indicator
    - byte order mark indicator
  - Tabline's tab mode can display splits simultaneously

## [0.7] - 2014-12-10
- New features
    - accents support; allowing multiple colors/styles in the same section
    - extensions: eclim
    - themes: understated, monochrome, murmur, sol, lucius
- Improvements
    -  solarized theme; support for 8 color terminals
    -  tabline resizes dynamically based on number of open buffers
    -  miscellaneous bug fixes

## [0.6] - 2013-10-08

- New features
    - accents support; allowing multiple colors/styles in the same section
    - extensions: eclim
    - themes: understated, monochrome, murmur, sol, lucius
- Improvements
    - solarized theme; support for 8 color terminals
    - tabline resizes dynamically based on number of open buffers
    - miscellaneous bug fixes

## [0.5] - 2013-09-13

- New features
    - smart tabline extension which displays all buffers when only one tab is visible
    - automatic section truncation when the window resizes
    - support for a declarative style of configuration, allowing parts to contain metadata such as minimum window width or conditional visibility
    - themes: zenburn, serene
- Other
    - a sizable chunk of vim-airline is now running through a unit testing suite, automated via Travis CI

## [0.4] - 2013-08-26

 - New features
    - integration with csv.vim and vim-virtualenv
    - hunks extension for vim-gitgutter and vim-signify
    - automatic theme switching with matching colorschemes
    - commands: AirlineToggle
    - themes: base16 (all variants)
 - Improvements
    - integration with undotree, tagbar, and unite
 - Other
    - refactored core and exposed statusline builder and pipeline
    - all extension related g:airline_variables have been deprecated in favor of g:airline#extensions# variables
    - extensions found in the runtimepath outside of the default distribution will be automatically loaded

## [0.3] - 2013-08-12

-  New features
    -  first-class integration with tagbar
    -  white space detection for trailing spaces and mixed indentation
    -  introduced warning section for syntastic and white space detection
    -  improved ctrlp integration: colors are automatically selected based on the current airline theme
    -  new themes: molokai, bubblegum, jellybeans, tomorrow
-  Bug fixes
    -  improved handling of eventignore used by other plugins
-  Other
    - code cleaned up for clearer separation between core functionality and extensions
    - introduced color extraction from highlight groups, allowing themes to be generated off of the active colorscheme (e.g. jellybeans and tomorrow)
    - License changed to MIT

## [0.2] - 2013-07-28

-  New features
      - iminsert detection
      - integration with vimshell, vimfiler, commandt, lawrencium
      - enhanced bufferline theming
      - support for ctrlp theming
      - support for custom window excludes
- New themes
      - luna and wombat
- Bug fixes
      - refresh branch name after switching with a shell command

## [0.1] - 2013-07-17

- Initial release
  - integration with other plugins: netrw, unite, nerdtree, undotree, gundo, tagbar, minibufexplr, ctrlp
  - support for themes: 8 included

[Unreleased]: https://github.com/vim-airline/vim-airline/compare/v0.9...HEAD
[0.9]: https://github.com/vim-airline/vim-airline/compare/v0.8...v0.9
[0.8]: https://github.com/vim-airline/vim-airline/compare/v0.7...v0.8
[0.7]: https://github.com/vim-airline/vim-airline/compare/v0.6...v0.7
[0.6]: https://github.com/vim-airline/vim-airline/compare/v0.5...v0.6
[0.5]: https://github.com/vim-airline/vim-airline/compare/v0.4...v0.5
[0.4]: https://github.com/vim-airline/vim-airline/compare/v0.3...v0.4
[0.3]: https://github.com/vim-airline/vim-airline/compare/v0.2...v0.3
[0.2]: https://github.com/vim-airline/vim-airline/compare/v0.1...v0.2
[0.1]: https://github.com/vim-airline/vim-airline/releases/tag/v0.1
