/*
 * mp2.h:	Use the S/P-DIF interface for redirecting MP2 stream
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 *
 * Copyright (C) 2003 Sven Goethel, <sven@jausoft.com>
 * Copyright (C) 2003,2004 Werner Fink, <werner@suse.de>
 */

#ifndef __MP2_H
#define __MP2_H

#include "types.h"
#include "iec60958.h"
#include "mp2_decoder.h"

class cMP2 : public iec60958 {
private:
    static const uint_16 magic;
    struct {
	uint_16 bfound;
	uint_16 syncword;
	uint_16 fsize;
    } c;
    static const uint_32 samplerate_table[3];
    MP2Decoder *Decoder;
    inline void reset_count(void)
    {
	c.syncword = 0x001f;
	c.bfound = 0;
	c.fsize = 0;
    };
public:
    cMP2(unsigned int rate);	// Sample rate
    virtual ~cMP2();
    virtual const bool Initialize(void);
    virtual const void Release(void);
    virtual const bool Count(const uint_8 *buf, const uint_8 *const tail);
    virtual const frame_t & Frame(const uint_8 *&out, const uint_8 *const end);
    virtual const void ClassReset(void)
    {
	if (Decoder) Decoder->init();
	reset_count();
    }
};

extern cMP2 mp2;

#endif // __MP2_H
