/* vtgsourceoutlinerview.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgsourceoutlinerview.vala, do not modify */

/*
 *  vtgprojectmanagerview.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <afrodite.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-panel.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <libpeas-gtk/peas-gtk.h>
#include <girepository.h>
#include <gmodule.h>
#include <libpeas/peas.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <config.h>
#include <gedit/gedit-document.h>
#include <gedit/gedit-tab.h>
#include <valagee.h>


#define VTG_TYPE_COLUMNS (vtg_columns_get_type ())

#define VTG_TYPE_DATA (vtg_data_get_type ())
#define VTG_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_DATA, VtgData))
#define VTG_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_DATA, VtgDataClass))
#define VTG_IS_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_DATA))
#define VTG_IS_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_DATA))
#define VTG_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_DATA, VtgDataClass))

typedef struct _VtgData VtgData;
typedef struct _VtgDataClass VtgDataClass;
typedef struct _VtgDataPrivate VtgDataPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))

#define VTG_TYPE_SOURCE_OUTLINER_VIEW (vtg_source_outliner_view_get_type ())
#define VTG_SOURCE_OUTLINER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerView))
#define VTG_SOURCE_OUTLINER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerViewClass))
#define VTG_IS_SOURCE_OUTLINER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_OUTLINER_VIEW))
#define VTG_IS_SOURCE_OUTLINER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_OUTLINER_VIEW))
#define VTG_SOURCE_OUTLINER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerViewClass))

typedef struct _VtgSourceOutlinerView VtgSourceOutlinerView;
typedef struct _VtgSourceOutlinerViewClass VtgSourceOutlinerViewClass;
typedef struct _VtgSourceOutlinerViewPrivate VtgSourceOutlinerViewPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gdk_event_free0(var) ((var == NULL) ? NULL : (var = (gdk_event_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

typedef enum  {
	VTG_COLUMNS_NAME = 0,
	VTG_COLUMNS_ICON,
	VTG_COLUMNS_DATA,
	VTG_COLUMNS_COLUMNS_COUNT
} VtgColumns;

struct _VtgData {
	GObject parent_instance;
	VtgDataPrivate * priv;
	AfroditeSymbol* symbol;
	AfroditeSourceReference* source_reference;
};

struct _VtgDataClass {
	GObjectClass parent_class;
};

struct _VtgSourceOutlinerView {
	GObject parent_instance;
	VtgSourceOutlinerViewPrivate * priv;
};

struct _VtgSourceOutlinerViewClass {
	GObjectClass parent_class;
};

struct _VtgSourceOutlinerViewPrivate {
	gchar** qualifiers;
	gint qualifiers_length1;
	gint _qualifiers_size_;
	VtgPluginInstance* _plugin_instance;
	GtkTreeView* _src_view;
	GtkTreeModelSort* _sorted;
	GtkToggleButton* _check_show_private_symbols;
	GtkToggleButton* _check_show_public_symbols;
	GtkToggleButton* _check_show_protected_symbols;
	GtkToggleButton* _check_show_internal_symbols;
	GtkTreeStore* _model;
	GtkMenu* _popup_symbols;
	gboolean _on_show_symbol_scope_toggled_flag;
	guint _popup_symbols_ui_id;
	gchar* _popup_symbols_ui_def;
	GtkActionGroup* _actions;
	GtkVBox* _side_panel;
	gint _current_line;
	gint _current_column;
	guint _idle_id;
	GeditView* _active_view;
	GtkHBox* _top_ui;
	GtkComboBox* _combo_groups;
	GtkComboBox* _combo_items;
	gchar* _current_source_path;
	gboolean _updating_combos;
};


static gpointer vtg_data_parent_class = NULL;
static GType vtg_data_type_id = 0;
static gpointer vtg_source_outliner_view_parent_class = NULL;
extern VtgPlugin* vtg_plugin_main_instance;
static GType vtg_source_outliner_view_type_id = 0;

GType vtg_columns_get_type (void) G_GNUC_CONST;
GType vtg_data_get_type (void) G_GNUC_CONST;
GType vtg_data_register_type (GTypeModule * module);
enum  {
	VTG_DATA_DUMMY_PROPERTY
};
VtgData* vtg_data_new (AfroditeSymbol* symbol, AfroditeSourceReference* source_reference);
VtgData* vtg_data_construct (GType object_type, AfroditeSymbol* symbol, AfroditeSourceReference* source_reference);
static void vtg_data_finalize (GObject* obj);
GType vtg_source_outliner_view_get_type (void) G_GNUC_CONST;
GType vtg_source_outliner_view_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_SOURCE_OUTLINER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerViewPrivate))
enum  {
	VTG_SOURCE_OUTLINER_VIEW_DUMMY_PROPERTY,
	VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW,
	VTG_SOURCE_OUTLINER_VIEW_SHOW_PRIVATE_SYMBOLS,
	VTG_SOURCE_OUTLINER_VIEW_CURRENT_LINE,
	VTG_SOURCE_OUTLINER_VIEW_CURRENT_COLUMN
};
void vtg_utils_trace (const gchar* format, ...);
void vtg_source_outliner_view_deactivate (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_on_source_outliner_goto (VtgSourceOutlinerView* self, GtkAction* action);
static void _vtg_source_outliner_view_on_source_outliner_goto_gtk_action_callback (GtkAction* action, gpointer self);
void vtg_source_outliner_view_set_current_position (VtgSourceOutlinerView* self, gint line, gint column);
static void vtg_source_outliner_view_idle_highlight_current_position (VtgSourceOutlinerView* self);
VtgSourceOutlinerView* vtg_source_outliner_view_new (VtgPluginInstance* plugin_instance);
VtgSourceOutlinerView* vtg_source_outliner_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_source_outliner_view_on_source_outliner_view_row_activated (VtgSourceOutlinerView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column);
static void _vtg_source_outliner_view_on_source_outliner_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean vtg_source_outliner_view_on_source_outliner_view_button_press (VtgSourceOutlinerView* self, GtkWidget* sender, GdkEventButton* event);
static gboolean _vtg_source_outliner_view_on_source_outliner_view_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
gchar* vtg_utils_get_image_path (const gchar* id);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
gboolean vtg_configuration_get_outliner_show_public_symbols (VtgConfiguration* self);
static void vtg_source_outliner_view_on_show_symbol_scope_toggled (VtgSourceOutlinerView* self, GtkWidget* sender);
static void _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gboolean vtg_configuration_get_outliner_show_internal_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_protected_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_private_symbols (VtgConfiguration* self);
GdkPixbuf* vtg_utils_get_icon_for_type_name (AfroditeMemberType type);
static GtkTreeStore* vtg_source_outliner_view_build_tree_model (VtgSourceOutlinerView* self);
static GtkTreeModelSort* vtg_source_outliner_view_build_sort_model (VtgSourceOutlinerView* self, GtkTreeStore* child_model);
static GtkListStore* vtg_source_outliner_view_build_combo_model (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_on_combo_groups_changed (VtgSourceOutlinerView* self, GtkWidget* sender);
static void _vtg_source_outliner_view_on_combo_groups_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void vtg_source_outliner_view_on_combo_items_changed (VtgSourceOutlinerView* self, GtkWidget* sender);
static void _vtg_source_outliner_view_on_combo_items_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void vtg_source_outliner_view_cleanup_view_ui (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_populate_combo_items_model (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_initialize_view_ui (VtgSourceOutlinerView* self);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
static gint vtg_source_outliner_view_sort_model (VtgSourceOutlinerView* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
void vtg_source_outliner_view_clear_view (VtgSourceOutlinerView* self);
void vtg_source_outliner_view_update_view (VtgSourceOutlinerView* self, AfroditeSourceFile* source);
static void vtg_source_outliner_view_populate_treeview_model (VtgSourceOutlinerView* self, GtkTreeStore* model, AfroditeSourceFile* source, ValaList* symbols, GtkTreeIter* parent_iter);
static void vtg_source_outliner_view_populate_combo_groups_model (VtgSourceOutlinerView* self, GtkListStore* combo_model, AfroditeSourceFile* source);
static void vtg_source_outliner_view_goto_line (VtgSourceOutlinerView* self, AfroditeSymbol* symbol);
void vtg_configuration_set_outliner_show_private_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_public_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_protected_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_internal_symbols (VtgConfiguration* self, gboolean value);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static AfroditeSymbolAccessibility vtg_source_outliner_view_get_symbol_accessibility (VtgSourceOutlinerView* self, AfroditeSymbol* symbol);
gint vtg_utils_symbol_type_compare (AfroditeSymbol* vala, AfroditeSymbol* valb);
static gboolean vtg_source_outliner_view_highlight_current_position (VtgSourceOutlinerView* self);
static gboolean _vtg_source_outliner_view_highlight_current_position_gsource_func (gpointer self);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
GeditView* vtg_source_outliner_view_get_active_view (VtgSourceOutlinerView* self);
void vtg_source_outliner_view_set_active_view (VtgSourceOutlinerView* self, GeditView* value);
gboolean vtg_source_outliner_view_get_show_private_symbols (VtgSourceOutlinerView* self);
gint vtg_source_outliner_view_get_current_line (VtgSourceOutlinerView* self);
gint vtg_source_outliner_view_get_current_column (VtgSourceOutlinerView* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void vtg_source_outliner_view_finalize (GObject* obj);
static void _vala_vtg_source_outliner_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vtg_source_outliner_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GtkActionEntry VTG_SOURCE_OUTLINER_VIEW__action_entries[1] = {{"source-outliner-goto", GTK_STOCK_OPEN, "Goto definition...", NULL, "Goto symbol definition", (GCallback) _vtg_source_outliner_view_on_source_outliner_goto_gtk_action_callback}};

GType vtg_columns_get_type (void) {
	static volatile gsize vtg_columns_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_COLUMNS_NAME, "VTG_COLUMNS_NAME", "name"}, {VTG_COLUMNS_ICON, "VTG_COLUMNS_ICON", "icon"}, {VTG_COLUMNS_DATA, "VTG_COLUMNS_DATA", "data"}, {VTG_COLUMNS_COLUMNS_COUNT, "VTG_COLUMNS_COLUMNS_COUNT", "columns-count"}, {0, NULL, NULL}};
		GType vtg_columns_type_id;
		vtg_columns_type_id = g_enum_register_static ("VtgColumns", values);
		g_once_init_leave (&vtg_columns_type_id__volatile, vtg_columns_type_id);
	}
	return vtg_columns_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _afrodite_source_reference_ref0 (gpointer self) {
	return self ? afrodite_source_reference_ref (self) : NULL;
}


VtgData* vtg_data_construct (GType object_type, AfroditeSymbol* symbol, AfroditeSourceReference* source_reference) {
	VtgData * self = NULL;
	AfroditeSymbol* _tmp0_;
	AfroditeSourceReference* _tmp1_;
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (VtgData*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (symbol);
	_g_object_unref0 (self->symbol);
	self->symbol = _tmp0_;
	_tmp1_ = _afrodite_source_reference_ref0 (source_reference);
	_afrodite_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}


VtgData* vtg_data_new (AfroditeSymbol* symbol, AfroditeSourceReference* source_reference) {
	return vtg_data_construct (VTG_TYPE_DATA, symbol, source_reference);
}


static void vtg_data_class_init (VtgDataClass * klass) {
	vtg_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vtg_data_finalize;
}


static void vtg_data_instance_init (VtgData * self) {
}


static void vtg_data_finalize (GObject* obj) {
	VtgData * self;
	self = VTG_DATA (obj);
	_g_object_unref0 (self->symbol);
	_afrodite_source_reference_unref0 (self->source_reference);
	G_OBJECT_CLASS (vtg_data_parent_class)->finalize (obj);
}


GType vtg_data_get_type (void) {
	return vtg_data_type_id;
}


GType vtg_data_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgData), 0, (GInstanceInitFunc) vtg_data_instance_init, NULL };
	vtg_data_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgData", &g_define_type_info, 0);
	return vtg_data_type_id;
}


static void _vtg_source_outliner_view_on_source_outliner_goto_gtk_action_callback (GtkAction* action, gpointer self) {
	vtg_source_outliner_view_on_source_outliner_goto (self, action);
}


void vtg_source_outliner_view_set_current_position (VtgSourceOutlinerView* self, gint line, gint column) {
	g_return_if_fail (self != NULL);
	self->priv->_current_line = line;
	self->priv->_current_column = column;
	vtg_source_outliner_view_idle_highlight_current_position (self);
}


static void _vtg_source_outliner_view_on_source_outliner_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	vtg_source_outliner_view_on_source_outliner_view_row_activated (self, _sender, path, column);
}


static gboolean _vtg_source_outliner_view_on_source_outliner_view_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = vtg_source_outliner_view_on_source_outliner_view_button_press (self, _sender, event);
	return result;
}


static void _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	vtg_source_outliner_view_on_show_symbol_scope_toggled (self, _sender);
}


static void _vtg_source_outliner_view_on_combo_groups_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	vtg_source_outliner_view_on_combo_groups_changed (self, _sender);
}


static void _vtg_source_outliner_view_on_combo_items_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	vtg_source_outliner_view_on_combo_items_changed (self, _sender);
}


VtgSourceOutlinerView* vtg_source_outliner_view_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgSourceOutlinerView * self = NULL;
	GeditWindow* _tmp0_ = NULL;
	GeditPanel* _tmp1_ = NULL;
	GeditPanel* _tmp2_;
	GeditPanel* panel;
	GtkVBox* _tmp3_ = NULL;
	GtkTreeView* _tmp4_ = NULL;
	GtkTreeViewColumn* _tmp5_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* _tmp6_ = NULL;
	GtkCellRenderer* renderer;
	GtkCellRendererText* _tmp7_ = NULL;
	GtkScrolledWindow* _tmp8_ = NULL;
	GtkScrolledWindow* scroll;
	GtkHBox* _tmp9_ = NULL;
	GtkHBox* hbox;
	const gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* label;
	GtkToggleButton* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GtkImage* _tmp15_ = NULL;
	GtkImage* _tmp16_;
	GtkImage* image;
	const gchar* _tmp17_ = NULL;
	VtgConfiguration* _tmp18_ = NULL;
	gboolean _tmp19_;
	GtkToggleButton* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GtkImage* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	VtgConfiguration* _tmp25_ = NULL;
	gboolean _tmp26_;
	GtkToggleButton* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GtkImage* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	VtgConfiguration* _tmp32_ = NULL;
	gboolean _tmp33_;
	GtkToggleButton* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_;
	GtkImage* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	VtgConfiguration* _tmp39_ = NULL;
	gboolean _tmp40_;
	GdkPixbuf* _tmp41_ = NULL;
	GdkPixbuf* _tmp42_;
	GtkImage* _tmp43_ = NULL;
	GtkImage* _tmp44_;
	GtkImage* icon;
	const gchar* _tmp45_ = NULL;
	GtkActionGroup* _tmp46_ = NULL;
	GeditWindow* _tmp47_ = NULL;
	GtkUIManager* _tmp48_ = NULL;
	GtkUIManager* _tmp49_;
	GtkUIManager* manager;
	guint _tmp50_;
	guint _tmp51_;
	GtkWidget* _tmp52_ = NULL;
	GtkMenu* _tmp53_;
	GtkTreeStore* _tmp54_ = NULL;
	GtkTreeModelSort* _tmp55_ = NULL;
	GtkHBox* _tmp56_ = NULL;
	GtkComboBox* _tmp57_ = NULL;
	GtkListStore* _tmp58_ = NULL;
	GtkListStore* model;
	GtkCellRendererPixbuf* _tmp59_ = NULL;
	GtkCellRendererText* _tmp60_ = NULL;
	GtkComboBox* _tmp61_ = NULL;
	GtkListStore* _tmp62_ = NULL;
	GtkCellRendererPixbuf* _tmp63_ = NULL;
	GtkCellRendererText* _tmp64_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgSourceOutlinerView*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	_tmp0_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp1_ = gedit_window_get_side_panel (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	panel = _tmp2_;
	_tmp3_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	_g_object_unref0 (self->priv->_side_panel);
	self->priv->_side_panel = g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkTreeView*) gtk_tree_view_new ();
	_g_object_unref0 (self->priv->_src_view);
	self->priv->_src_view = g_object_ref_sink (_tmp4_);
	_tmp5_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp5_);
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp6_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "pixbuf", (gint) VTG_COLUMNS_ICON);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp7_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "markup", (gint) VTG_COLUMNS_NAME);
	gtk_tree_view_append_column (self->priv->_src_view, column);
	gtk_tree_view_set_headers_visible (self->priv->_src_view, FALSE);
	g_signal_connect_object (self->priv->_src_view, "row-activated", (GCallback) _vtg_source_outliner_view_on_source_outliner_view_row_activated_gtk_tree_view_row_activated, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_src_view, "button-press-event", (GCallback) _vtg_source_outliner_view_on_source_outliner_view_button_press_gtk_widget_button_press_event, self, 0);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scroll = g_object_ref_sink (_tmp8_);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->_src_view);
	gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) scroll, TRUE, TRUE, (guint) 4);
	_tmp9_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	hbox = g_object_ref_sink (_tmp9_);
	gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) hbox, FALSE, FALSE, (guint) 4);
	_tmp10_ = _ ("Filter by scope:");
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	label = g_object_ref_sink (_tmp11_);
	g_object_set ((GtkMisc*) label, "xalign", (gfloat) 0, NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 4);
	_tmp12_ = (GtkToggleButton*) gtk_toggle_button_new ();
	_g_object_unref0 (self->priv->_check_show_public_symbols);
	self->priv->_check_show_public_symbols = g_object_ref_sink (_tmp12_);
	_tmp13_ = vtg_utils_get_image_path ("public-symbols-22.png");
	_tmp14_ = _tmp13_;
	_tmp15_ = (GtkImage*) gtk_image_new_from_file (_tmp14_);
	_tmp16_ = g_object_ref_sink (_tmp15_);
	_g_free0 (_tmp14_);
	image = _tmp16_;
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_public_symbols, (GtkWidget*) image);
	_tmp17_ = _ ("Show public symbols");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_public_symbols, _tmp17_);
	_tmp18_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp19_ = vtg_configuration_get_outliner_show_public_symbols (_tmp18_);
	gtk_toggle_button_set_active (self->priv->_check_show_public_symbols, _tmp19_);
	g_signal_connect_object (self->priv->_check_show_public_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_public_symbols, FALSE, TRUE, (guint) 4);
	_tmp20_ = (GtkToggleButton*) gtk_toggle_button_new ();
	_g_object_unref0 (self->priv->_check_show_internal_symbols);
	self->priv->_check_show_internal_symbols = g_object_ref_sink (_tmp20_);
	_tmp21_ = vtg_utils_get_image_path ("internal-symbols-22.png");
	_tmp22_ = _tmp21_;
	_tmp23_ = (GtkImage*) gtk_image_new_from_file (_tmp22_);
	_g_object_unref0 (image);
	image = g_object_ref_sink (_tmp23_);
	_g_free0 (_tmp22_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_internal_symbols, (GtkWidget*) image);
	_tmp24_ = _ ("Show internal symbols");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_internal_symbols, _tmp24_);
	_tmp25_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp26_ = vtg_configuration_get_outliner_show_internal_symbols (_tmp25_);
	gtk_toggle_button_set_active (self->priv->_check_show_internal_symbols, _tmp26_);
	g_signal_connect_object (self->priv->_check_show_internal_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_internal_symbols, FALSE, TRUE, (guint) 4);
	_tmp27_ = (GtkToggleButton*) gtk_toggle_button_new ();
	_g_object_unref0 (self->priv->_check_show_protected_symbols);
	self->priv->_check_show_protected_symbols = g_object_ref_sink (_tmp27_);
	_tmp28_ = vtg_utils_get_image_path ("protected-symbols-22.png");
	_tmp29_ = _tmp28_;
	_tmp30_ = (GtkImage*) gtk_image_new_from_file (_tmp29_);
	_g_object_unref0 (image);
	image = g_object_ref_sink (_tmp30_);
	_g_free0 (_tmp29_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_protected_symbols, (GtkWidget*) image);
	_tmp31_ = _ ("Show protected symbols");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_protected_symbols, _tmp31_);
	_tmp32_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp33_ = vtg_configuration_get_outliner_show_protected_symbols (_tmp32_);
	gtk_toggle_button_set_active (self->priv->_check_show_protected_symbols, _tmp33_);
	g_signal_connect_object (self->priv->_check_show_protected_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_protected_symbols, FALSE, TRUE, (guint) 4);
	_tmp34_ = (GtkToggleButton*) gtk_toggle_button_new ();
	_g_object_unref0 (self->priv->_check_show_private_symbols);
	self->priv->_check_show_private_symbols = g_object_ref_sink (_tmp34_);
	_tmp35_ = vtg_utils_get_image_path ("private-symbols-22.png");
	_tmp36_ = _tmp35_;
	_tmp37_ = (GtkImage*) gtk_image_new_from_file (_tmp36_);
	_g_object_unref0 (image);
	image = g_object_ref_sink (_tmp37_);
	_g_free0 (_tmp36_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_private_symbols, (GtkWidget*) image);
	_tmp38_ = _ ("Show private symbols");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_private_symbols, _tmp38_);
	_tmp39_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp40_ = vtg_configuration_get_outliner_show_private_symbols (_tmp39_);
	gtk_toggle_button_set_active (self->priv->_check_show_private_symbols, _tmp40_);
	g_signal_connect_object (self->priv->_check_show_private_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_private_symbols, FALSE, TRUE, (guint) 4);
	gtk_widget_show_all ((GtkWidget*) self->priv->_side_panel);
	_tmp41_ = vtg_utils_get_icon_for_type_name (AFRODITE_MEMBER_TYPE_CLASS);
	_tmp42_ = _tmp41_;
	_tmp43_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp42_);
	_tmp44_ = g_object_ref_sink (_tmp43_);
	_g_object_unref0 (_tmp42_);
	icon = _tmp44_;
	_tmp45_ = _ ("Source");
	gedit_panel_add_item (panel, (GtkWidget*) self->priv->_side_panel, "Source", _tmp45_, (GtkWidget*) icon);
	gedit_panel_activate_item (panel, (GtkWidget*) self->priv->_side_panel);
	_tmp46_ = gtk_action_group_new ("SourceOutlinerActionGroup");
	_g_object_unref0 (self->priv->_actions);
	self->priv->_actions = _tmp46_;
	gtk_action_group_set_translation_domain (self->priv->_actions, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (self->priv->_actions, VTG_SOURCE_OUTLINER_VIEW__action_entries, G_N_ELEMENTS (VTG_SOURCE_OUTLINER_VIEW__action_entries), self);
	_tmp47_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp48_ = gedit_window_get_ui_manager (_tmp47_);
	_tmp49_ = _g_object_ref0 (_tmp48_);
	manager = _tmp49_;
	gtk_ui_manager_insert_action_group (manager, self->priv->_actions, -1);
	_tmp50_ = gtk_ui_manager_add_ui_from_string (manager, self->priv->_popup_symbols_ui_def, (gssize) (-1), &_inner_error_);
	_tmp51_ = _tmp50_;
	if (_inner_error_ != NULL) {
		goto __catch50_g_error;
	}
	self->priv->_popup_symbols_ui_id = _tmp51_;
	_tmp52_ = gtk_ui_manager_get_widget (manager, "/SourceOutlinerPopupGoto");
	_tmp53_ = _g_object_ref0 (GTK_MENU (_tmp52_));
	_g_object_unref0 (self->priv->_popup_symbols);
	self->priv->_popup_symbols = _tmp53_;
	g_assert (self->priv->_popup_symbols != NULL);
	goto __finally50;
	__catch50_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgsourceoutlinerview.vala:211: Error %s", err->message);
		_g_error_free0 (err);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (manager);
		_g_object_unref0 (icon);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_object_unref0 (hbox);
		_g_object_unref0 (scroll);
		_g_object_unref0 (renderer);
		_g_object_unref0 (column);
		_g_object_unref0 (panel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp54_ = vtg_source_outliner_view_build_tree_model (self);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp54_;
	_tmp55_ = vtg_source_outliner_view_build_sort_model (self, self->priv->_model);
	_g_object_unref0 (self->priv->_sorted);
	self->priv->_sorted = _tmp55_;
	gtk_tree_view_set_model (self->priv->_src_view, (GtkTreeModel*) self->priv->_sorted);
	_tmp56_ = (GtkHBox*) gtk_hbox_new (TRUE, 0);
	_g_object_unref0 (self->priv->_top_ui);
	self->priv->_top_ui = g_object_ref_sink (_tmp56_);
	_tmp57_ = (GtkComboBox*) gtk_combo_box_new ();
	_g_object_unref0 (self->priv->_combo_groups);
	self->priv->_combo_groups = g_object_ref_sink (_tmp57_);
	_tmp58_ = vtg_source_outliner_view_build_combo_model (self);
	model = _tmp58_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) model, (gint) VTG_COLUMNS_NAME, GTK_SORT_ASCENDING);
	gtk_combo_box_set_model (self->priv->_combo_groups, (GtkTreeModel*) model);
	_tmp59_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp59_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_groups, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_groups, renderer, "pixbuf", (gint) VTG_COLUMNS_ICON);
	_tmp60_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp60_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_groups, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_groups, renderer, "markup", (gint) VTG_COLUMNS_NAME);
	g_signal_connect_object (self->priv->_combo_groups, "changed", (GCallback) _vtg_source_outliner_view_on_combo_groups_changed_gtk_combo_box_changed, self, 0);
	_tmp61_ = (GtkComboBox*) gtk_combo_box_new ();
	_g_object_unref0 (self->priv->_combo_items);
	self->priv->_combo_items = g_object_ref_sink (_tmp61_);
	_tmp62_ = vtg_source_outliner_view_build_combo_model (self);
	_g_object_unref0 (model);
	model = _tmp62_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) model, (gint) VTG_COLUMNS_NAME, GTK_SORT_ASCENDING);
	gtk_combo_box_set_model (self->priv->_combo_items, (GtkTreeModel*) model);
	_tmp63_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp63_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_items, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_items, renderer, "pixbuf", (gint) VTG_COLUMNS_ICON);
	_tmp64_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp64_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_items, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_items, renderer, "markup", (gint) VTG_COLUMNS_NAME);
	g_signal_connect_object (self->priv->_combo_items, "changed", (GCallback) _vtg_source_outliner_view_on_combo_items_changed_gtk_combo_box_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_top_ui, (GtkWidget*) self->priv->_combo_groups, FALSE, TRUE, (guint) 2);
	gtk_box_pack_end ((GtkBox*) self->priv->_top_ui, (GtkWidget*) self->priv->_combo_items, FALSE, TRUE, (guint) 2);
	_g_object_unref0 (model);
	_g_object_unref0 (manager);
	_g_object_unref0 (icon);
	_g_object_unref0 (image);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (scroll);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (panel);
	return self;
}


VtgSourceOutlinerView* vtg_source_outliner_view_new (VtgPluginInstance* plugin_instance) {
	return vtg_source_outliner_view_construct (VTG_TYPE_SOURCE_OUTLINER_VIEW, plugin_instance);
}


void vtg_source_outliner_view_deactivate (VtgSourceOutlinerView* self) {
	GeditWindow* _tmp0_ = NULL;
	GtkUIManager* _tmp1_ = NULL;
	GtkUIManager* _tmp2_;
	GtkUIManager* manager;
	GeditWindow* _tmp3_ = NULL;
	GeditPanel* _tmp4_ = NULL;
	GeditPanel* _tmp5_;
	GeditPanel* panel;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp1_ = gedit_window_get_ui_manager (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	manager = _tmp2_;
	gtk_ui_manager_remove_ui (manager, self->priv->_popup_symbols_ui_id);
	gtk_ui_manager_remove_action_group (manager, self->priv->_actions);
	_tmp3_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp4_ = gedit_window_get_side_panel (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	panel = _tmp5_;
	gedit_panel_remove_item (panel, (GtkWidget*) self->priv->_side_panel);
	vtg_source_outliner_view_cleanup_view_ui (self);
	if (self->priv->_idle_id != 0) {
		g_source_remove (self->priv->_idle_id);
		self->priv->_idle_id = (guint) 0;
	}
	_g_object_unref0 (self->priv->_combo_groups);
	self->priv->_combo_groups = NULL;
	_g_object_unref0 (self->priv->_combo_items);
	self->priv->_combo_items = NULL;
	_g_object_unref0 (self->priv->_top_ui);
	self->priv->_top_ui = NULL;
	_g_object_unref0 (panel);
	_g_object_unref0 (manager);
}


static void vtg_source_outliner_view_on_combo_groups_changed (VtgSourceOutlinerView* self, GtkWidget* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	vtg_source_outliner_view_populate_combo_items_model (self);
}


static void vtg_source_outliner_view_on_combo_items_changed (VtgSourceOutlinerView* self, GtkWidget* sender) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (self->priv->_updating_combos) {
		return;
	}
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->_combo_items, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		VtgData* data = NULL;
		GtkTreeModel* _tmp2_ = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = gtk_combo_box_get_model (self->priv->_combo_items);
		gtk_tree_model_get (_tmp2_, &iter, VTG_COLUMNS_DATA, &data, -1);
		_tmp3_ = afrodite_source_reference_get_first_line (data->source_reference);
		_tmp4_ = afrodite_source_reference_get_first_column (data->source_reference);
		_tmp5_ = afrodite_source_reference_get_last_column (data->source_reference);
		g_signal_emit_by_name (self, "goto-source", _tmp3_, _tmp4_, _tmp5_);
		_g_object_unref0 (data);
	}
}


static void vtg_source_outliner_view_initialize_view_ui (VtgSourceOutlinerView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GeditDocument* _tmp1_;
	GeditDocument* doc;
	gboolean _tmp2_;
	GeditTab* _tmp3_ = NULL;
	GeditTab* _tmp4_;
	GeditTab* tab;
	g_return_if_fail (self != NULL);
	if (self->priv->_active_view == NULL) {
		return;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->_active_view);
	_tmp1_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp0_));
	doc = _tmp1_;
	_tmp2_ = vtg_utils_is_vala_doc (doc);
	if (!_tmp2_) {
		_g_object_unref0 (doc);
		return;
	}
	_tmp3_ = gedit_tab_get_from_document (doc);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tab = _tmp4_;
	gtk_widget_show_all ((GtkWidget*) self->priv->_top_ui);
	gtk_box_pack_start ((GtkBox*) tab, (GtkWidget*) self->priv->_top_ui, FALSE, FALSE, (guint) 2);
	_g_object_unref0 (tab);
	_g_object_unref0 (doc);
}


static void vtg_source_outliner_view_cleanup_view_ui (VtgSourceOutlinerView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GeditDocument* _tmp1_;
	GeditDocument* doc;
	gboolean _tmp2_;
	GeditTab* _tmp3_ = NULL;
	GeditTab* _tmp4_;
	GeditTab* tab;
	g_return_if_fail (self != NULL);
	if (self->priv->_active_view == NULL) {
		return;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->_active_view);
	_tmp1_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp0_));
	doc = _tmp1_;
	_tmp2_ = vtg_utils_is_vala_doc (doc);
	if (!_tmp2_) {
		_g_object_unref0 (doc);
		return;
	}
	_tmp3_ = gedit_tab_get_from_document (doc);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tab = _tmp4_;
	if (tab != NULL) {
		GtkTreeModel* _tmp5_ = NULL;
		GtkListStore* _tmp6_;
		GtkListStore* combo_model;
		GtkTreeModel* _tmp7_ = NULL;
		GtkListStore* _tmp8_;
		_tmp5_ = gtk_combo_box_get_model (self->priv->_combo_groups);
		_tmp6_ = _g_object_ref0 (GTK_LIST_STORE (_tmp5_));
		combo_model = _tmp6_;
		gtk_list_store_clear (combo_model);
		_tmp7_ = gtk_combo_box_get_model (self->priv->_combo_items);
		_tmp8_ = _g_object_ref0 (GTK_LIST_STORE (_tmp7_));
		_g_object_unref0 (combo_model);
		combo_model = _tmp8_;
		gtk_list_store_clear (combo_model);
		gtk_container_remove ((GtkContainer*) tab, (GtkWidget*) self->priv->_top_ui);
		_g_object_unref0 (combo_model);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (doc);
}


static GtkTreeStore* vtg_source_outliner_view_build_tree_model (VtgSourceOutlinerView* self) {
	GtkTreeStore* result = NULL;
	GtkTreeStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tree_store_new ((gint) VTG_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_OBJECT);
	result = _tmp0_;
	return result;
}


static gint _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = vtg_source_outliner_view_sort_model (self, model, a, b);
	return result;
}


static GtkListStore* vtg_source_outliner_view_build_combo_model (VtgSourceOutlinerView* self) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* model;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) VTG_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_OBJECT);
	model = _tmp0_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) model, 0, GTK_SORT_ASCENDING);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) model, 0, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) model, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	result = model;
	return result;
}


static GtkTreeModelSort* vtg_source_outliner_view_build_sort_model (VtgSourceOutlinerView* self, GtkTreeStore* child_model) {
	GtkTreeModelSort* result = NULL;
	GtkTreeModelSort* _tmp0_ = NULL;
	GtkTreeModelSort* sorted;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (child_model != NULL, NULL);
	_tmp0_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) child_model);
	sorted = _tmp0_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) sorted, 0, GTK_SORT_ASCENDING);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) sorted, 0, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) sorted, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	result = sorted;
	return result;
}


void vtg_source_outliner_view_clear_view (VtgSourceOutlinerView* self) {
	g_return_if_fail (self != NULL);
	gtk_tree_store_clear (self->priv->_model);
}


void vtg_source_outliner_view_update_view (VtgSourceOutlinerView* self, AfroditeSourceFile* source) {
	GtkTreeStore* _tmp0_ = NULL;
	GtkTreeStore* model;
	GtkTreeModelSort* _tmp1_ = NULL;
	GtkTreeModelSort* sorted;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_;
	GtkListStore* combo_model;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GtkTreeStore* _tmp7_;
	GtkTreeModelSort* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_source_outliner_view_build_tree_model (self);
	model = _tmp0_;
	_tmp1_ = vtg_source_outliner_view_build_sort_model (self, model);
	sorted = _tmp1_;
	_tmp2_ = gtk_combo_box_get_model (self->priv->_combo_groups);
	_tmp3_ = _g_object_ref0 (GTK_LIST_STORE (_tmp2_));
	combo_model = _tmp3_;
	_tmp4_ = afrodite_source_file_get_filename (source);
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_current_source_path);
	self->priv->_current_source_path = _tmp5_;
	self->priv->_updating_combos = TRUE;
	gtk_combo_box_set_model (self->priv->_combo_groups, NULL);
	gtk_list_store_clear (combo_model);
	if (source != NULL) {
		ValaList* _tmp6_ = NULL;
		_tmp6_ = afrodite_source_file_get_symbols (source);
		vtg_source_outliner_view_populate_treeview_model (self, model, source, _tmp6_, NULL);
		vtg_source_outliner_view_populate_combo_groups_model (self, combo_model, source);
	}
	_tmp7_ = _g_object_ref0 (model);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp7_;
	_tmp8_ = _g_object_ref0 (sorted);
	_g_object_unref0 (self->priv->_sorted);
	self->priv->_sorted = _tmp8_;
	gtk_tree_view_set_model (self->priv->_src_view, (GtkTreeModel*) self->priv->_sorted);
	gtk_tree_view_expand_all (self->priv->_src_view);
	self->priv->_updating_combos = FALSE;
	gtk_combo_box_set_model (self->priv->_combo_groups, (GtkTreeModel*) combo_model);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->_combo_groups);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->_combo_items);
	vtg_source_outliner_view_idle_highlight_current_position (self);
	_g_object_unref0 (combo_model);
	_g_object_unref0 (sorted);
	_g_object_unref0 (model);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vtg_source_outliner_view_populate_combo_items_model (VtgSourceOutlinerView* self) {
	gint count;
	GtkTreeIter iter = {0};
	VtgData* data = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	GtkListStore* model;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	count = 0;
	_tmp0_ = gtk_combo_box_get_model (self->priv->_combo_items);
	_tmp1_ = _g_object_ref0 (GTK_LIST_STORE (_tmp0_));
	model = _tmp1_;
	gtk_list_store_clear (model);
	gtk_combo_box_set_model (self->priv->_combo_items, NULL);
	_tmp3_ = gtk_combo_box_get_active_iter (self->priv->_combo_groups, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeModel* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = gtk_combo_box_get_model (self->priv->_combo_groups);
		gtk_tree_model_get (_tmp4_, &iter, VTG_COLUMNS_DATA, &data, -1);
		if (data->source_reference != NULL) {
			_tmp6_ = data->symbol != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = afrodite_symbol_get_has_children (data->symbol);
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			{
				ValaList* _tmp8_ = NULL;
				ValaList* _tmp9_;
				ValaList* _child_list;
				gint _tmp10_;
				gint _child_size;
				gint _child_index;
				_tmp8_ = afrodite_symbol_get_children (data->symbol);
				_tmp9_ = _vala_iterable_ref0 (_tmp8_);
				_child_list = _tmp9_;
				_tmp10_ = vala_collection_get_size ((ValaCollection*) _child_list);
				_child_size = _tmp10_;
				_child_index = -1;
				while (TRUE) {
					gpointer _tmp11_ = NULL;
					AfroditeSymbol* child;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_;
					_child_index = _child_index + 1;
					if (!(_child_index < _child_size)) {
						break;
					}
					_tmp11_ = vala_list_get (_child_list, _child_index);
					child = (AfroditeSymbol*) _tmp11_;
					_tmp12_ = afrodite_symbol_get_name (child);
					_tmp13_ = g_str_has_prefix (_tmp12_, "!");
					if (!_tmp13_) {
						AfroditeSourceFile* _tmp14_ = NULL;
						AfroditeSourceReference* _tmp15_ = NULL;
						AfroditeSourceReference* sr;
						_tmp14_ = afrodite_source_reference_get_file (data->source_reference);
						_tmp15_ = afrodite_symbol_lookup_source_reference_sourcefile (child, _tmp14_);
						sr = _tmp15_;
						if (sr != NULL) {
							GtkTreeIter _tmp16_ = {0};
							const gchar* _tmp17_ = NULL;
							AfroditeMemberType _tmp18_;
							GdkPixbuf* _tmp19_ = NULL;
							GdkPixbuf* _tmp20_;
							VtgData* _tmp21_ = NULL;
							VtgData* _tmp22_;
							gtk_list_store_append (model, &_tmp16_);
							iter = _tmp16_;
							_tmp17_ = afrodite_symbol_get_display_name (child);
							_tmp18_ = afrodite_symbol_get_member_type (child);
							_tmp19_ = vtg_utils_get_icon_for_type_name (_tmp18_);
							_tmp20_ = _tmp19_;
							_tmp21_ = vtg_data_new (child, sr);
							_tmp22_ = _tmp21_;
							gtk_list_store_set (model, &iter, VTG_COLUMNS_NAME, _tmp17_, VTG_COLUMNS_ICON, _tmp20_, VTG_COLUMNS_DATA, _tmp22_, -1);
							_g_object_unref0 (_tmp22_);
							_g_object_unref0 (_tmp20_);
						}
						count++;
						_afrodite_source_reference_unref0 (sr);
					}
					_g_object_unref0 (child);
				}
				_vala_iterable_unref0 (_child_list);
			}
		}
	}
	gtk_combo_box_set_model (self->priv->_combo_items, (GtkTreeModel*) model);
	_g_object_unref0 (model);
	_g_object_unref0 (data);
}


static void vtg_source_outliner_view_goto_line (VtgSourceOutlinerView* self, AfroditeSymbol* symbol) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = afrodite_symbol_get_has_source_references (symbol);
	if (_tmp0_) {
		ValaList* _tmp1_ = NULL;
		gpointer _tmp2_ = NULL;
		AfroditeSourceReference* sr;
		gint _tmp3_;
		gint line;
		gint _tmp4_;
		gint start_col;
		gint _tmp5_;
		gint end_col;
		_tmp1_ = afrodite_symbol_get_source_references (symbol);
		_tmp2_ = vala_list_get (_tmp1_, 0);
		sr = (AfroditeSourceReference*) _tmp2_;
		_tmp3_ = afrodite_source_reference_get_first_line (sr);
		line = _tmp3_;
		_tmp4_ = afrodite_source_reference_get_first_column (sr);
		start_col = _tmp4_;
		_tmp5_ = afrodite_source_reference_get_last_column (sr);
		end_col = _tmp5_;
		g_signal_emit_by_name (self, "goto-source", line, start_col, end_col);
		_afrodite_source_reference_unref0 (sr);
	}
}


static void vtg_source_outliner_view_on_show_symbol_scope_toggled (VtgSourceOutlinerView* self, GtkWidget* sender) {
	GdkEvent* _tmp0_ = NULL;
	GdkEvent* event;
	VtgConfiguration* _tmp2_ = NULL;
	gboolean _tmp3_;
	VtgConfiguration* _tmp4_ = NULL;
	gboolean _tmp5_;
	VtgConfiguration* _tmp6_ = NULL;
	gboolean _tmp7_;
	VtgConfiguration* _tmp8_ = NULL;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (self->priv->_on_show_symbol_scope_toggled_flag) {
		return;
	}
	_tmp0_ = gtk_get_current_event ();
	event = _tmp0_;
	if ((event->button.state & GDK_SHIFT_MASK) != 0) {
		gboolean _tmp1_;
		gboolean active;
		_tmp1_ = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sender));
		active = _tmp1_;
		self->priv->_on_show_symbol_scope_toggled_flag = TRUE;
		if (GTK_WIDGET (self->priv->_check_show_internal_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_internal_symbols, !active);
		}
		if (GTK_WIDGET (self->priv->_check_show_private_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_private_symbols, !active);
		}
		if (GTK_WIDGET (self->priv->_check_show_protected_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_protected_symbols, !active);
		}
		if (GTK_WIDGET (self->priv->_check_show_public_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_public_symbols, !active);
		}
		self->priv->_on_show_symbol_scope_toggled_flag = FALSE;
	}
	_tmp2_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp3_ = gtk_toggle_button_get_active (self->priv->_check_show_private_symbols);
	vtg_configuration_set_outliner_show_private_symbols (_tmp2_, _tmp3_);
	_tmp4_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp5_ = gtk_toggle_button_get_active (self->priv->_check_show_public_symbols);
	vtg_configuration_set_outliner_show_public_symbols (_tmp4_, _tmp5_);
	_tmp6_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp7_ = gtk_toggle_button_get_active (self->priv->_check_show_protected_symbols);
	vtg_configuration_set_outliner_show_protected_symbols (_tmp6_, _tmp7_);
	_tmp8_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp9_ = gtk_toggle_button_get_active (self->priv->_check_show_internal_symbols);
	vtg_configuration_set_outliner_show_internal_symbols (_tmp8_, _tmp9_);
	g_signal_emit_by_name (self, "filter-changed");
	_gdk_event_free0 (event);
}


static void vtg_source_outliner_view_on_source_outliner_view_row_activated (VtgSourceOutlinerView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeView* _tmp0_;
	GtkTreeView* tw;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModelSort* _tmp2_;
	GtkTreeModelSort* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = _g_object_ref0 (GTK_TREE_VIEW (sender));
	tw = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (tw);
	_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL_SORT (_tmp1_));
	model = _tmp2_;
	_tmp4_ = gtk_tree_model_get_iter ((GtkTreeModel*) model, &_tmp3_, path);
	iter = _tmp3_;
	if (_tmp4_) {
		VtgData* data = NULL;
		gtk_tree_model_get ((GtkTreeModel*) model, &iter, VTG_COLUMNS_DATA, &data, -1);
		vtg_source_outliner_view_goto_line (self, data->symbol);
		_g_object_unref0 (data);
	}
	_g_object_unref0 (model);
	_g_object_unref0 (tw);
}


static void vtg_source_outliner_view_on_source_outliner_goto (VtgSourceOutlinerView* self, GtkAction* action) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->_src_view);
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		VtgData* data = NULL;
		gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &data, -1);
		vtg_source_outliner_view_goto_line (self, data->symbol);
		_g_object_unref0 (data);
	}
	_g_object_unref0 (model);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gboolean vtg_source_outliner_view_on_source_outliner_view_button_press (VtgSourceOutlinerView* self, GtkWidget* sender, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if ((*event).button == 3) {
		GtkTreeModel* model = NULL;
		GtkTreeSelection* _tmp0_ = NULL;
		GtkTreeModel* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		GList* rows;
		guint _tmp3_;
		_tmp0_ = gtk_tree_view_get_selection (self->priv->_src_view);
		_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp0_, &_tmp1_);
		model = _tmp1_;
		rows = _tmp2_;
		_tmp3_ = g_list_length (rows);
		if (_tmp3_ == 1) {
			GtkTreeIter iter = {0};
			VtgData* obj = NULL;
			gconstpointer _tmp4_ = NULL;
			GtkTreePath* path;
			GtkTreeIter _tmp5_ = {0};
			_tmp4_ = g_list_nth_data (rows, (guint) 0);
			path = (GtkTreePath*) _tmp4_;
			gtk_tree_model_get_iter (model, &_tmp5_, path);
			iter = _tmp5_;
			gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &obj, -1);
			if (AFRODITE_IS_SYMBOL (obj->symbol)) {
				gtk_menu_popup (self->priv->_popup_symbols, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
			}
			_g_object_unref0 (obj);
		}
		__g_list_free__gtk_tree_path_free0_0 (rows);
	}
	result = FALSE;
	return result;
}


static AfroditeSymbolAccessibility vtg_source_outliner_view_get_symbol_accessibility (VtgSourceOutlinerView* self, AfroditeSymbol* symbol) {
	AfroditeSymbolAccessibility result = 0;
	AfroditeSymbolAccessibility sym_access = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (symbol != NULL, 0);
	_tmp2_ = afrodite_symbol_get_has_children (symbol);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = afrodite_symbol_get_name (symbol);
		_tmp4_ = g_str_has_prefix (_tmp3_, "!");
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		AfroditeMemberType _tmp7_;
		_tmp7_ = afrodite_symbol_get_member_type (symbol);
		if (_tmp7_ == AFRODITE_MEMBER_TYPE_CLASS) {
			_tmp6_ = TRUE;
		} else {
			AfroditeMemberType _tmp8_;
			_tmp8_ = afrodite_symbol_get_member_type (symbol);
			_tmp6_ = _tmp8_ == AFRODITE_MEMBER_TYPE_STRUCT;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			AfroditeMemberType _tmp9_;
			_tmp9_ = afrodite_symbol_get_member_type (symbol);
			_tmp5_ = _tmp9_ == AFRODITE_MEMBER_TYPE_NAMESPACE;
		}
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AfroditeSymbolAccessibility _tmp10_;
		_tmp10_ = afrodite_symbol_get_access (symbol);
		sym_access = _tmp10_;
		{
			ValaList* _tmp11_ = NULL;
			ValaList* _tmp12_;
			ValaList* _child_list;
			gint _tmp13_;
			gint _child_size;
			gint _child_index;
			_tmp11_ = afrodite_symbol_get_children (symbol);
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_child_list = _tmp12_;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _child_list);
			_child_size = _tmp13_;
			_child_index = -1;
			while (TRUE) {
				gpointer _tmp14_ = NULL;
				AfroditeSymbol* child;
				AfroditeSymbolAccessibility _tmp15_;
				_child_index = _child_index + 1;
				if (!(_child_index < _child_size)) {
					break;
				}
				_tmp14_ = vala_list_get (_child_list, _child_index);
				child = (AfroditeSymbol*) _tmp14_;
				_tmp15_ = vtg_source_outliner_view_get_symbol_accessibility (self, child);
				sym_access = sym_access | _tmp15_;
				if (sym_access == AFRODITE_SYMBOL_ACCESSIBILITY_ANY) {
					_g_object_unref0 (child);
					break;
				}
				_g_object_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
	} else {
		AfroditeSymbolAccessibility _tmp16_;
		_tmp16_ = afrodite_symbol_get_access (symbol);
		sym_access = _tmp16_;
	}
	result = sym_access;
	return result;
}


static void vtg_source_outliner_view_populate_combo_groups_model (VtgSourceOutlinerView* self, GtkListStore* combo_model, AfroditeSourceFile* source) {
	gboolean root_namespace_added;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo_model != NULL);
	g_return_if_fail (source != NULL);
	root_namespace_added = FALSE;
	_tmp0_ = afrodite_source_file_get_has_symbols (source);
	if (_tmp0_) {
		{
			ValaList* _tmp1_ = NULL;
			ValaList* _tmp2_;
			ValaList* _symbol_list;
			gint _tmp3_;
			gint _symbol_size;
			gint _symbol_index;
			_tmp1_ = afrodite_source_file_get_symbols (source);
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_symbol_list = _tmp2_;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _symbol_list);
			_symbol_size = _tmp3_;
			_symbol_index = -1;
			while (TRUE) {
				gpointer _tmp4_ = NULL;
				AfroditeSymbol* symbol;
				GtkTreeIter iter_group = {0};
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				AfroditeMemberType _tmp9_;
				_symbol_index = _symbol_index + 1;
				if (!(_symbol_index < _symbol_size)) {
					break;
				}
				_tmp4_ = vala_list_get (_symbol_list, _symbol_index);
				symbol = (AfroditeSymbol*) _tmp4_;
				_tmp9_ = afrodite_symbol_get_member_type (symbol);
				if (_tmp9_ == AFRODITE_MEMBER_TYPE_NAMESPACE) {
					_tmp8_ = TRUE;
				} else {
					AfroditeMemberType _tmp10_;
					_tmp10_ = afrodite_symbol_get_member_type (symbol);
					_tmp8_ = _tmp10_ == AFRODITE_MEMBER_TYPE_CLASS;
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					AfroditeMemberType _tmp11_;
					_tmp11_ = afrodite_symbol_get_member_type (symbol);
					_tmp7_ = _tmp11_ == AFRODITE_MEMBER_TYPE_INTERFACE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					AfroditeMemberType _tmp12_;
					_tmp12_ = afrodite_symbol_get_member_type (symbol);
					_tmp6_ = _tmp12_ == AFRODITE_MEMBER_TYPE_STRUCT;
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					AfroditeMemberType _tmp13_;
					_tmp13_ = afrodite_symbol_get_member_type (symbol);
					_tmp5_ = _tmp13_ == AFRODITE_MEMBER_TYPE_ENUM;
				}
				if (_tmp5_) {
					AfroditeSourceReference* _tmp14_ = NULL;
					AfroditeSourceReference* sr;
					_tmp14_ = afrodite_symbol_lookup_source_reference_sourcefile (symbol, source);
					sr = _tmp14_;
					if (sr != NULL) {
						GtkTreeIter _tmp15_ = {0};
						gchar* _tmp16_ = NULL;
						gchar* _tmp17_;
						AfroditeMemberType _tmp18_;
						GdkPixbuf* _tmp19_ = NULL;
						GdkPixbuf* _tmp20_;
						VtgData* _tmp21_ = NULL;
						VtgData* _tmp22_;
						gtk_list_store_append (combo_model, &_tmp15_);
						iter_group = _tmp15_;
						_tmp16_ = afrodite_symbol_get_fully_qualified_name (symbol);
						_tmp17_ = _tmp16_;
						_tmp18_ = afrodite_symbol_get_member_type (symbol);
						_tmp19_ = vtg_utils_get_icon_for_type_name (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = vtg_data_new (symbol, sr);
						_tmp22_ = _tmp21_;
						gtk_list_store_set (combo_model, &iter_group, VTG_COLUMNS_NAME, _tmp17_, VTG_COLUMNS_ICON, _tmp20_, VTG_COLUMNS_DATA, _tmp22_, -1);
						_g_object_unref0 (_tmp22_);
						_g_object_unref0 (_tmp20_);
						_g_free0 (_tmp17_);
					}
					_afrodite_source_reference_unref0 (sr);
				} else {
					gboolean _tmp23_ = FALSE;
					gboolean _tmp24_ = FALSE;
					if (root_namespace_added == FALSE) {
						AfroditeSymbol* _tmp25_ = NULL;
						_tmp25_ = afrodite_symbol_get_parent (symbol);
						_tmp24_ = _tmp25_ != NULL;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						AfroditeSymbol* _tmp26_ = NULL;
						gboolean _tmp27_;
						_tmp26_ = afrodite_symbol_get_parent (symbol);
						_tmp27_ = afrodite_symbol_get_is_root (_tmp26_);
						_tmp23_ = _tmp27_;
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						GtkTreeIter _tmp28_ = {0};
						const gchar* _tmp29_ = NULL;
						GdkPixbuf* _tmp30_ = NULL;
						GdkPixbuf* _tmp31_;
						AfroditeSymbol* _tmp32_ = NULL;
						VtgData* _tmp33_ = NULL;
						VtgData* _tmp34_;
						gtk_list_store_append (combo_model, &_tmp28_);
						iter_group = _tmp28_;
						_tmp29_ = _ ("(none)");
						_tmp30_ = vtg_utils_get_icon_for_type_name (AFRODITE_MEMBER_TYPE_NAMESPACE);
						_tmp31_ = _tmp30_;
						_tmp32_ = afrodite_symbol_get_parent (symbol);
						_tmp33_ = vtg_data_new (_tmp32_, NULL);
						_tmp34_ = _tmp33_;
						gtk_list_store_set (combo_model, &iter_group, VTG_COLUMNS_NAME, _tmp29_, VTG_COLUMNS_ICON, _tmp31_, VTG_COLUMNS_DATA, _tmp34_, -1);
						_g_object_unref0 (_tmp34_);
						_g_object_unref0 (_tmp31_);
						root_namespace_added = TRUE;
					}
				}
			}
			_vala_iterable_unref0 (_symbol_list);
		}
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static void vtg_source_outliner_view_populate_treeview_model (VtgSourceOutlinerView* self, GtkTreeStore* model, AfroditeSourceFile* source, ValaList* symbols, GtkTreeIter* parent_iter) {
	gboolean _tmp0_ = FALSE;
	AfroditeSymbolAccessibility accessibility;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (source != NULL);
	if (symbols == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) symbols);
		_tmp0_ = _tmp1_ == 0;
	}
	if (_tmp0_) {
		return;
	}
	accessibility = 0;
	_tmp2_ = gtk_toggle_button_get_active (self->priv->_check_show_private_symbols);
	if (_tmp2_) {
		accessibility = AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE;
	}
	_tmp3_ = gtk_toggle_button_get_active (self->priv->_check_show_public_symbols);
	if (_tmp3_) {
		accessibility = accessibility | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC;
	}
	_tmp4_ = gtk_toggle_button_get_active (self->priv->_check_show_protected_symbols);
	if (_tmp4_) {
		accessibility = accessibility | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	_tmp5_ = gtk_toggle_button_get_active (self->priv->_check_show_internal_symbols);
	if (_tmp5_) {
		accessibility = accessibility | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL;
	}
	{
		ValaList* _tmp6_;
		ValaList* _symbol_list;
		gint _tmp7_;
		gint _symbol_size;
		gint _symbol_index;
		_tmp6_ = _vala_iterable_ref0 (symbols);
		_symbol_list = _tmp6_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _symbol_list);
		_symbol_size = _tmp7_;
		_symbol_index = -1;
		while (TRUE) {
			gpointer _tmp8_ = NULL;
			AfroditeSymbol* symbol;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			AfroditeMemberType _tmp13_;
			gboolean _tmp19_ = FALSE;
			GtkTreeIter iter = {0};
			AfroditeSymbolAccessibility _tmp22_;
			AfroditeSymbolAccessibility sym_access;
			_symbol_index = _symbol_index + 1;
			if (!(_symbol_index < _symbol_size)) {
				break;
			}
			_tmp8_ = vala_list_get (_symbol_list, _symbol_index);
			symbol = (AfroditeSymbol*) _tmp8_;
			_tmp13_ = afrodite_symbol_get_member_type (symbol);
			if (_tmp13_ == AFRODITE_MEMBER_TYPE_NONE) {
				_tmp12_ = TRUE;
			} else {
				AfroditeMemberType _tmp14_;
				_tmp14_ = afrodite_symbol_get_member_type (symbol);
				_tmp12_ = _tmp14_ == AFRODITE_MEMBER_TYPE_LOCAL_VARIABLE;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				AfroditeMemberType _tmp15_;
				_tmp15_ = afrodite_symbol_get_member_type (symbol);
				_tmp11_ = _tmp15_ == AFRODITE_MEMBER_TYPE_SCOPED_CODE_NODE;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				AfroditeMemberType _tmp16_;
				_tmp16_ = afrodite_symbol_get_member_type (symbol);
				_tmp10_ = _tmp16_ == AFRODITE_MEMBER_TYPE_VOID;
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				const gchar* _tmp17_ = NULL;
				gboolean _tmp18_;
				_tmp17_ = afrodite_symbol_get_name (symbol);
				_tmp18_ = g_str_has_prefix (_tmp17_, "!");
				_tmp9_ = _tmp18_;
			}
			if (_tmp9_) {
				continue;
			}
			if (parent_iter == NULL) {
				AfroditeSymbol* _tmp20_ = NULL;
				gboolean _tmp21_;
				_tmp20_ = afrodite_symbol_get_parent (symbol);
				_tmp21_ = afrodite_symbol_get_is_root (_tmp20_);
				_tmp19_ = !_tmp21_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				continue;
			}
			_tmp22_ = vtg_source_outliner_view_get_symbol_accessibility (self, symbol);
			sym_access = _tmp22_;
			if ((sym_access & accessibility) != 0) {
				AfroditeSourceReference* _tmp23_ = NULL;
				AfroditeSourceReference* sr;
				_tmp23_ = afrodite_symbol_lookup_source_reference_sourcefile (symbol, source);
				sr = _tmp23_;
				if (sr != NULL) {
					gchar* _tmp24_ = NULL;
					gchar* des;
					GtkTreeIter _tmp29_ = {0};
					AfroditeMemberType _tmp30_;
					GdkPixbuf* _tmp31_ = NULL;
					GdkPixbuf* _tmp32_;
					VtgData* _tmp33_ = NULL;
					VtgData* _tmp34_;
					gboolean _tmp35_ = FALSE;
					gboolean _tmp36_ = FALSE;
					gboolean _tmp37_ = FALSE;
					gboolean _tmp38_ = FALSE;
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_ = FALSE;
					AfroditeMemberType _tmp41_;
					_tmp24_ = afrodite_symbol_get_markup_description (symbol);
					des = _tmp24_;
					{
						gchar** qualifier_collection;
						int qualifier_collection_length1;
						int qualifier_it;
						qualifier_collection = self->priv->qualifiers;
						qualifier_collection_length1 = self->priv->qualifiers_length1;
						for (qualifier_it = 0; qualifier_it < self->priv->qualifiers_length1; qualifier_it = qualifier_it + 1) {
							gchar* _tmp25_;
							gchar* qualifier;
							_tmp25_ = g_strdup (qualifier_collection[qualifier_it]);
							qualifier = _tmp25_;
							{
								gboolean _tmp26_;
								_tmp26_ = g_str_has_prefix (des, qualifier);
								if (_tmp26_) {
									gint _tmp27_;
									gchar* _tmp28_ = NULL;
									_tmp27_ = strlen (qualifier);
									_tmp28_ = string_substring (des, (glong) _tmp27_, (glong) (-1));
									_g_free0 (des);
									des = _tmp28_;
									_g_free0 (qualifier);
									break;
								}
								_g_free0 (qualifier);
							}
						}
					}
					gtk_tree_store_append (model, &_tmp29_, parent_iter);
					iter = _tmp29_;
					_tmp30_ = afrodite_symbol_get_member_type (symbol);
					_tmp31_ = vtg_utils_get_icon_for_type_name (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = vtg_data_new (symbol, sr);
					_tmp34_ = _tmp33_;
					gtk_tree_store_set (model, &iter, VTG_COLUMNS_NAME, des, VTG_COLUMNS_ICON, _tmp32_, VTG_COLUMNS_DATA, _tmp34_, -1);
					_g_object_unref0 (_tmp34_);
					_g_object_unref0 (_tmp32_);
					_tmp41_ = afrodite_symbol_get_member_type (symbol);
					if (_tmp41_ == AFRODITE_MEMBER_TYPE_CLASS) {
						_tmp40_ = TRUE;
					} else {
						AfroditeMemberType _tmp42_;
						_tmp42_ = afrodite_symbol_get_member_type (symbol);
						_tmp40_ = _tmp42_ == AFRODITE_MEMBER_TYPE_STRUCT;
					}
					if (_tmp40_) {
						_tmp39_ = TRUE;
					} else {
						AfroditeMemberType _tmp43_;
						_tmp43_ = afrodite_symbol_get_member_type (symbol);
						_tmp39_ = _tmp43_ == AFRODITE_MEMBER_TYPE_INTERFACE;
					}
					if (_tmp39_) {
						_tmp38_ = TRUE;
					} else {
						AfroditeMemberType _tmp44_;
						_tmp44_ = afrodite_symbol_get_member_type (symbol);
						_tmp38_ = _tmp44_ == AFRODITE_MEMBER_TYPE_NAMESPACE;
					}
					if (_tmp38_) {
						_tmp37_ = TRUE;
					} else {
						AfroditeMemberType _tmp45_;
						_tmp45_ = afrodite_symbol_get_member_type (symbol);
						_tmp37_ = _tmp45_ == AFRODITE_MEMBER_TYPE_ENUM;
					}
					if (_tmp37_) {
						_tmp36_ = TRUE;
					} else {
						AfroditeMemberType _tmp46_;
						_tmp46_ = afrodite_symbol_get_member_type (symbol);
						_tmp36_ = _tmp46_ == AFRODITE_MEMBER_TYPE_ERROR_DOMAIN;
					}
					if (_tmp36_) {
						gboolean _tmp47_;
						_tmp47_ = afrodite_symbol_get_has_children (symbol);
						_tmp35_ = _tmp47_;
					} else {
						_tmp35_ = FALSE;
					}
					if (_tmp35_) {
						ValaList* _tmp48_ = NULL;
						_tmp48_ = afrodite_symbol_get_children (symbol);
						vtg_source_outliner_view_populate_treeview_model (self, model, source, _tmp48_, &iter);
					}
					_g_free0 (des);
				}
				_afrodite_source_reference_unref0 (sr);
			}
		}
		_vala_iterable_unref0 (_symbol_list);
	}
}


static gint vtg_source_outliner_view_sort_model (VtgSourceOutlinerView* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	VtgData* vala;
	VtgData* valb;
	AfroditeSymbol* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSymbol* sa;
	AfroditeSymbol* _tmp2_ = NULL;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* sb;
	gint _tmp4_;
	gint _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	vala = NULL;
	valb = NULL;
	gtk_tree_model_get (model, a, VTG_COLUMNS_DATA, &vala, -1);
	gtk_tree_model_get (model, b, VTG_COLUMNS_DATA, &valb, -1);
	if (vala == NULL) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = vala->symbol;
	}
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sa = _tmp1_;
	if (valb == NULL) {
		_tmp2_ = NULL;
	} else {
		_tmp2_ = valb->symbol;
	}
	_tmp3_ = _g_object_ref0 (_tmp2_);
	sb = _tmp3_;
	_tmp4_ = vtg_utils_symbol_type_compare (sa, sb);
	_result_ = _tmp4_;
	result = _result_;
	_g_object_unref0 (sb);
	_g_object_unref0 (sa);
	_g_object_unref0 (valb);
	_g_object_unref0 (vala);
	return result;
}


static gboolean _vtg_source_outliner_view_highlight_current_position_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_source_outliner_view_highlight_current_position (self);
	return result;
}


static void vtg_source_outliner_view_idle_highlight_current_position (VtgSourceOutlinerView* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_idle_id != 0) {
		g_source_remove (self->priv->_idle_id);
	}
	_tmp0_ = g_timeout_add_full (G_PRIORITY_LOW, (guint) 500, _vtg_source_outliner_view_highlight_current_position_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_idle_id = _tmp0_;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gboolean vtg_source_outliner_view_highlight_current_position (VtgSourceOutlinerView* self) {
	gboolean result = FALSE;
	AfroditeSymbol* symbol;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	symbol = NULL;
	_tmp0_ = gtk_combo_box_get_model (self->priv->_combo_groups);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	self->priv->_updating_combos = TRUE;
	_tmp3_ = gtk_tree_model_get_iter_first (model, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeIter* found;
		found = NULL;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				VtgData* data = NULL;
				gboolean _tmp7_ = FALSE;
				if (!_tmp4_) {
					gboolean _tmp5_ = FALSE;
					if (symbol == NULL) {
						gboolean _tmp6_;
						_tmp6_ = gtk_tree_model_iter_next (model, &iter);
						_tmp5_ = _tmp6_;
					} else {
						_tmp5_ = FALSE;
					}
					if (!_tmp5_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &data, -1);
				if (data->source_reference != NULL) {
					gboolean _tmp8_;
					_tmp8_ = afrodite_symbol_get_has_children (data->symbol);
					_tmp7_ = _tmp8_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					{
						ValaList* _tmp9_ = NULL;
						ValaList* _tmp10_;
						ValaList* _child_list;
						gint _tmp11_;
						gint _child_size;
						gint _child_index;
						_tmp9_ = afrodite_symbol_get_children (data->symbol);
						_tmp10_ = _vala_iterable_ref0 (_tmp9_);
						_child_list = _tmp10_;
						_tmp11_ = vala_collection_get_size ((ValaCollection*) _child_list);
						_child_size = _tmp11_;
						_child_index = -1;
						while (TRUE) {
							gpointer _tmp12_ = NULL;
							AfroditeSymbol* child;
							AfroditeSourceFile* _tmp13_ = NULL;
							AfroditeSourceReference* _tmp14_ = NULL;
							AfroditeSourceReference* sr;
							gboolean _tmp15_ = FALSE;
							_child_index = _child_index + 1;
							if (!(_child_index < _child_size)) {
								break;
							}
							_tmp12_ = vala_list_get (_child_list, _child_index);
							child = (AfroditeSymbol*) _tmp12_;
							_tmp13_ = afrodite_source_reference_get_file (data->source_reference);
							_tmp14_ = afrodite_symbol_lookup_source_reference_sourcefile (child, _tmp13_);
							sr = _tmp14_;
							if (sr != NULL) {
								gboolean _tmp16_;
								_tmp16_ = afrodite_source_reference_contains_position (sr, self->priv->_current_line + 1, self->priv->_current_column);
								_tmp15_ = _tmp16_;
							} else {
								_tmp15_ = FALSE;
							}
							if (_tmp15_) {
								AfroditeSymbol* _tmp17_;
								GtkTreeIter* _tmp18_;
								_tmp17_ = _g_object_ref0 (child);
								_g_object_unref0 (symbol);
								symbol = _tmp17_;
								_tmp18_ = __gtk_tree_iter_dup0 (&iter);
								_g_free0 (found);
								found = _tmp18_;
								_afrodite_source_reference_unref0 (sr);
								_g_object_unref0 (child);
								break;
							}
							_afrodite_source_reference_unref0 (sr);
							_g_object_unref0 (child);
						}
						_vala_iterable_unref0 (_child_list);
					}
				}
				_g_object_unref0 (data);
			}
		}
		if (found == NULL) {
			gtk_combo_box_set_active (self->priv->_combo_groups, -1);
		} else {
			gtk_combo_box_set_active_iter (self->priv->_combo_groups, found);
		}
		_g_free0 (found);
	}
	if (symbol != NULL) {
		GtkTreeModel* _tmp19_ = NULL;
		GtkTreeModel* _tmp20_;
		GtkTreeIter _tmp21_ = {0};
		gboolean _tmp22_;
		_tmp19_ = gtk_combo_box_get_model (self->priv->_combo_items);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (model);
		model = _tmp20_;
		_tmp22_ = gtk_tree_model_get_iter_first (model, &_tmp21_);
		iter = _tmp21_;
		if (_tmp22_) {
			{
				gboolean _tmp23_;
				_tmp23_ = TRUE;
				while (TRUE) {
					VtgData* data = NULL;
					if (!_tmp23_) {
						gboolean _tmp24_;
						_tmp24_ = gtk_tree_model_iter_next (model, &iter);
						if (!_tmp24_) {
							break;
						}
					}
					_tmp23_ = FALSE;
					gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &data, -1);
					if (data->symbol == symbol) {
						gtk_combo_box_set_active_iter (self->priv->_combo_items, &iter);
						_g_object_unref0 (data);
						break;
					}
					_g_object_unref0 (data);
				}
			}
		}
	}
	self->priv->_updating_combos = FALSE;
	self->priv->_idle_id = (guint) 0;
	result = FALSE;
	_g_object_unref0 (model);
	_g_object_unref0 (symbol);
	return result;
}


GeditView* vtg_source_outliner_view_get_active_view (VtgSourceOutlinerView* self) {
	GeditView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_view;
	return result;
}


void vtg_source_outliner_view_set_active_view (VtgSourceOutlinerView* self, GeditView* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_active_view != value) {
		GeditView* _tmp0_;
		vtg_source_outliner_view_cleanup_view_ui (self);
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_active_view);
		self->priv->_active_view = _tmp0_;
		vtg_source_outliner_view_initialize_view_ui (self);
	}
	g_object_notify ((GObject *) self, "active-view");
}


gboolean vtg_source_outliner_view_get_show_private_symbols (VtgSourceOutlinerView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_toggle_button_get_active (self->priv->_check_show_private_symbols);
	result = _tmp0_;
	return result;
}


gint vtg_source_outliner_view_get_current_line (VtgSourceOutlinerView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_line;
	return result;
}


gint vtg_source_outliner_view_get_current_column (VtgSourceOutlinerView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_column;
	return result;
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static void vtg_source_outliner_view_class_init (VtgSourceOutlinerViewClass * klass) {
	vtg_source_outliner_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgSourceOutlinerViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_source_outliner_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vtg_source_outliner_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_source_outliner_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW, g_param_spec_object ("active-view", "active-view", "active-view", gedit_view_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_SHOW_PRIVATE_SYMBOLS, g_param_spec_boolean ("show-private-symbols", "show-private-symbols", "show-private-symbols", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_CURRENT_LINE, g_param_spec_int ("current-line", "current-line", "current-line", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_CURRENT_COLUMN, g_param_spec_int ("current-column", "current-column", "current-column", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("goto_source", VTG_TYPE_SOURCE_OUTLINER_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("filter_changed", VTG_TYPE_SOURCE_OUTLINER_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vtg_source_outliner_view_instance_init (VtgSourceOutlinerView * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar* _tmp5_;
	self->priv = VTG_SOURCE_OUTLINER_VIEW_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("public ");
	_tmp1_ = g_strdup ("private ");
	_tmp2_ = g_strdup ("internal ");
	_tmp3_ = g_strdup ("protected ");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	self->priv->qualifiers = _tmp4_;
	self->priv->qualifiers_length1 = 4;
	self->priv->_qualifiers_size_ = self->priv->qualifiers_length1;
	self->priv->_plugin_instance = NULL;
	self->priv->_model = NULL;
	self->priv->_on_show_symbol_scope_toggled_flag = FALSE;
	_tmp5_ = g_strdup ("\n" \
"                                        <ui>\n" \
"                                        <popup name='SourceOutlinerPop" \
"upGoto'>\n" \
"                                            <menuitem action='source-o" \
"utliner-goto'/>\n" \
"                                        </popup>\n" \
"                                        </ui>");
	self->priv->_popup_symbols_ui_def = _tmp5_;
	self->priv->_current_line = -1;
	self->priv->_current_column = -1;
	self->priv->_idle_id = (guint) 0;
	self->priv->_active_view = NULL;
	self->priv->_updating_combos = FALSE;
}


static void vtg_source_outliner_view_finalize (GObject* obj) {
	VtgSourceOutlinerView * self;
	self = VTG_SOURCE_OUTLINER_VIEW (obj);
	vtg_utils_trace ("vtgsourceoutlinerview.vala:254: SourceOutlinerView destroying");
	gtk_tree_view_set_model (self->priv->_src_view, NULL);
	vtg_source_outliner_view_deactivate (self);
	vtg_utils_trace ("vtgsourceoutlinerview.vala:258: SourceOutlinerView destroyed");
	self->priv->qualifiers = (_vala_array_free (self->priv->qualifiers, self->priv->qualifiers_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_src_view);
	_g_object_unref0 (self->priv->_sorted);
	_g_object_unref0 (self->priv->_check_show_private_symbols);
	_g_object_unref0 (self->priv->_check_show_public_symbols);
	_g_object_unref0 (self->priv->_check_show_protected_symbols);
	_g_object_unref0 (self->priv->_check_show_internal_symbols);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_popup_symbols);
	_g_free0 (self->priv->_popup_symbols_ui_def);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_side_panel);
	_g_object_unref0 (self->priv->_active_view);
	_g_object_unref0 (self->priv->_top_ui);
	_g_object_unref0 (self->priv->_combo_groups);
	_g_object_unref0 (self->priv->_combo_items);
	_g_free0 (self->priv->_current_source_path);
	G_OBJECT_CLASS (vtg_source_outliner_view_parent_class)->finalize (obj);
}


GType vtg_source_outliner_view_get_type (void) {
	return vtg_source_outliner_view_type_id;
}


GType vtg_source_outliner_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgSourceOutlinerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_source_outliner_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgSourceOutlinerView), 0, (GInstanceInitFunc) vtg_source_outliner_view_instance_init, NULL };
	vtg_source_outliner_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgSourceOutlinerView", &g_define_type_info, 0);
	return vtg_source_outliner_view_type_id;
}


static void _vala_vtg_source_outliner_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgSourceOutlinerView * self;
	self = VTG_SOURCE_OUTLINER_VIEW (object);
	switch (property_id) {
		case VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW:
		g_value_set_object (value, vtg_source_outliner_view_get_active_view (self));
		break;
		case VTG_SOURCE_OUTLINER_VIEW_SHOW_PRIVATE_SYMBOLS:
		g_value_set_boolean (value, vtg_source_outliner_view_get_show_private_symbols (self));
		break;
		case VTG_SOURCE_OUTLINER_VIEW_CURRENT_LINE:
		g_value_set_int (value, vtg_source_outliner_view_get_current_line (self));
		break;
		case VTG_SOURCE_OUTLINER_VIEW_CURRENT_COLUMN:
		g_value_set_int (value, vtg_source_outliner_view_get_current_column (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vtg_source_outliner_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgSourceOutlinerView * self;
	self = VTG_SOURCE_OUTLINER_VIEW (object);
	switch (property_id) {
		case VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW:
		vtg_source_outliner_view_set_active_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



