/* vtgprojects.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgprojects.vala, do not modify */

/*
 *  vtgprojects.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2010 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas-gtk/peas-gtk.h>
#include <girepository.h>
#include <gmodule.h>
#include <libpeas/peas.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <vbf.h>
#include <gedit/gedit-document.h>
#include <glib/gstdio.h>
#include <gio/gio.h>


#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;
typedef struct _VtgProjectsPrivate VtgProjectsPrivate;

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _VtgProjects {
	GObject parent_instance;
	VtgProjectsPrivate * priv;
};

struct _VtgProjectsClass {
	GObjectClass parent_class;
};

struct _VtgProjectsPrivate {
	VtgPlugin* _plugin;
	ValaList* _project_managers;
	VtgProjectManager* _default_project;
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	gchar* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	gchar* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};


static gpointer vtg_projects_parent_class = NULL;
extern VtgPlugin* vtg_plugin_main_instance;
static GType vtg_projects_type_id = 0;

GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
#define VTG_PROJECTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECTS, VtgProjectsPrivate))
enum  {
	VTG_PROJECTS_DUMMY_PROPERTY,
	VTG_PROJECTS_DEFAULT_PROJECT,
	VTG_PROJECTS_PROJECT_MANAGERS
};
VtgProjects* vtg_projects_new (VtgPlugin* plugin);
VtgProjects* vtg_projects_construct (GType object_type, VtgPlugin* plugin);
static void vtg_projects_initialize_default_project (VtgProjects* self);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
gboolean vtg_configuration_get_symbol_enabled (VtgConfiguration* self);
VtgProjectManager* vtg_project_manager_new (gboolean enable_completion);
VtgProjectManager* vtg_project_manager_construct (GType object_type, gboolean enable_completion);
void vtg_project_manager_create_default_project (VtgProjectManager* self);
static void vtg_projects_add (VtgProjects* self, VtgProjectManager* project_manager);
static void vtg_projects_on_project_updated (VtgProjects* self, VtgProjectManager* sender);
static void _vtg_projects_on_project_updated_vtg_project_manager_updated (VtgProjectManager* _sender, gpointer self);
static void vtg_projects_remove (VtgProjects* self, VtgProjectManager* project_manager);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
VtgProjectManager* vtg_projects_open_project (VtgProjects* self, const gchar* path, GError** error);
gboolean vtg_project_manager_open (VtgProjectManager* self, const gchar* project_filename, GError** error);
void vtg_projects_close_project (VtgProjects* self, VtgProjectManager* project);
void vtg_project_manager_close (VtgProjectManager* self);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document, GError** error);
gchar* vtg_utils_get_document_name (GeditDocument* doc);
gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const gchar* filename);
gboolean vtg_configuration_get_project_find_root_folder (VtgConfiguration* self);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
static gboolean vtg_projects_find_project_root_folder (VtgProjects* self, const gchar* file, gchar** root);
void vtg_project_manager_set_automanaged (VtgProjectManager* self, gboolean value);
void vtg_utils_trace (const gchar* format, ...);
VtgProjectManager* vtg_projects_get_project_manager_for_project_id (VtgProjects* self, const gchar* project_id);
VtgProjectManager* vtg_projects_get_project_manager_for_project_name (VtgProjects* self, const gchar* project_name);
VbfTarget* vtg_projects_get_target_for_document (VtgProjects* self, GeditDocument* document);
VbfSource* vtg_project_manager_get_source_file_for_filename (VtgProjectManager* self, const gchar* filename);
VtgProjectManager* vtg_projects_get_default_project (VtgProjects* self);
ValaList* vtg_projects_get_project_managers (VtgProjects* self);
static void vtg_projects_finalize (GObject* obj);
static void _vala_vtg_projects_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


VtgProjects* vtg_projects_construct (GType object_type, VtgPlugin* plugin) {
	VtgProjects * self = NULL;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (VtgProjects*) g_object_new (object_type, NULL);
	self->priv->_plugin = plugin;
	vtg_projects_initialize_default_project (self);
	return self;
}


VtgProjects* vtg_projects_new (VtgPlugin* plugin) {
	return vtg_projects_construct (VTG_TYPE_PROJECTS, plugin);
}


static void vtg_projects_initialize_default_project (VtgProjects* self) {
	VtgConfiguration* _tmp0_ = NULL;
	gboolean _tmp1_;
	VtgProjectManager* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_plugin_get_config (self->priv->_plugin);
	_tmp1_ = vtg_configuration_get_symbol_enabled (_tmp0_);
	_tmp2_ = vtg_project_manager_new (_tmp1_);
	_g_object_unref0 (self->priv->_default_project);
	self->priv->_default_project = _tmp2_;
	vtg_project_manager_create_default_project (self->priv->_default_project);
	vala_collection_add ((ValaCollection*) self->priv->_project_managers, self->priv->_default_project);
}


static void _vtg_projects_on_project_updated_vtg_project_manager_updated (VtgProjectManager* _sender, gpointer self) {
	vtg_projects_on_project_updated (self, _sender);
}


static void vtg_projects_add (VtgProjects* self, VtgProjectManager* project_manager) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (project_manager != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_project_managers, project_manager);
	g_signal_connect_object (project_manager, "updated", (GCallback) _vtg_projects_on_project_updated_vtg_project_manager_updated, self, 0);
}


static void vtg_projects_remove (VtgProjects* self, VtgProjectManager* project_manager) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project_manager != NULL);
	g_signal_parse_name ("updated", VTG_TYPE_PROJECT_MANAGER, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (project_manager, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_projects_on_project_updated_vtg_project_manager_updated, self);
	vala_collection_remove ((ValaCollection*) self->priv->_project_managers, project_manager);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vtg_projects_on_project_updated (VtgProjects* self, VtgProjectManager* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (sender->is_default) {
		return;
	}
	{
		ValaList* _tmp0_;
		ValaList* _source_list;
		gint _tmp1_;
		gint _source_size;
		gint _source_index;
		_tmp0_ = _vala_iterable_ref0 (sender->all_vala_sources);
		_source_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_list);
		_source_size = _tmp1_;
		_source_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfSource* source;
			_source_index = _source_index + 1;
			if (!(_source_index < _source_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_source_list, _source_index);
			source = (VbfSource*) _tmp2_;
			{
				ValaList* _tmp3_;
				ValaList* _def_source_list;
				gint _tmp4_;
				gint _def_source_size;
				gint _def_source_index;
				_tmp3_ = _vala_iterable_ref0 (self->priv->_default_project->all_vala_sources);
				_def_source_list = _tmp3_;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _def_source_list);
				_def_source_size = _tmp4_;
				_def_source_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					VbfSource* def_source;
					_def_source_index = _def_source_index + 1;
					if (!(_def_source_index < _def_source_size)) {
						break;
					}
					_tmp5_ = vala_list_get (_def_source_list, _def_source_index);
					def_source = (VbfSource*) _tmp5_;
					if (g_strcmp0 (((VbfFile*) source)->filename, ((VbfFile*) def_source)->filename) == 0) {
						VbfProject* _tmp6_ = NULL;
						VbfGroup* _tmp7_ = NULL;
						VbfGroup* group;
						VbfTarget* _tmp8_ = NULL;
						VbfTarget* target;
						_tmp6_ = vtg_project_manager_get_project (self->priv->_default_project);
						_tmp7_ = vbf_project_get_group (_tmp6_, "Sources");
						group = _tmp7_;
						_tmp8_ = vbf_group_get_target_for_id (group, "Default");
						target = _tmp8_;
						vbf_target_remove_source (target, def_source);
						g_signal_emit_by_name (self->priv->_default_project, "updated");
						_g_object_unref0 (target);
						_g_object_unref0 (group);
						_g_object_unref0 (def_source);
						break;
					}
					_g_object_unref0 (def_source);
				}
				_vala_iterable_unref0 (_def_source_list);
			}
			_g_object_unref0 (source);
		}
		_vala_iterable_unref0 (_source_list);
	}
}


VtgProjectManager* vtg_projects_open_project (VtgProjects* self, const gchar* path, GError** error) {
	VtgProjectManager* result = NULL;
	VtgConfiguration* _tmp0_ = NULL;
	gboolean _tmp1_;
	VtgProjectManager* _tmp2_ = NULL;
	VtgProjectManager* project;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp1_ = vtg_configuration_get_symbol_enabled (_tmp0_);
	_tmp2_ = vtg_project_manager_new (_tmp1_);
	project = _tmp2_;
	_tmp3_ = vtg_project_manager_open (project, path, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (project);
		return NULL;
	}
	if (_tmp4_) {
		vtg_projects_add (self, project);
		g_signal_emit_by_name (self, "project-opened", (GObject*) project);
	}
	result = project;
	return result;
}


void vtg_projects_close_project (VtgProjects* self, VtgProjectManager* project) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_signal_emit_by_name (self, "project-closed", (GObject*) project);
	vtg_project_manager_close (project);
	vtg_projects_remove (self, project);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document, GError** error) {
	VtgProjectManager* result = NULL;
	VtgProjectManager* _result_;
	gchar* _tmp0_ = NULL;
	gchar* file;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (document != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = vtg_utils_get_document_name (document);
	file = _tmp0_;
	if (file != NULL) {
		{
			ValaList* _tmp1_;
			ValaList* _project_manager_list;
			gint _tmp2_;
			gint _project_manager_size;
			gint _project_manager_index;
			_tmp1_ = _vala_iterable_ref0 (self->priv->_project_managers);
			_project_manager_list = _tmp1_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _project_manager_list);
			_project_manager_size = _tmp2_;
			_project_manager_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				VtgProjectManager* project_manager;
				gboolean _tmp4_;
				_project_manager_index = _project_manager_index + 1;
				if (!(_project_manager_index < _project_manager_size)) {
					break;
				}
				_tmp3_ = vala_list_get (_project_manager_list, _project_manager_index);
				project_manager = (VtgProjectManager*) _tmp3_;
				_tmp4_ = vtg_project_manager_contains_filename (project_manager, file);
				if (_tmp4_) {
					VtgProjectManager* _tmp5_;
					_tmp5_ = _g_object_ref0 (project_manager);
					_g_object_unref0 (_result_);
					_result_ = _tmp5_;
					_g_object_unref0 (project_manager);
					break;
				}
				_g_object_unref0 (project_manager);
			}
			_vala_iterable_unref0 (_project_manager_list);
		}
	}
	if (_result_ == NULL) {
		gboolean _tmp7_;
		_tmp7_ = g_file_test (file, G_FILE_TEST_EXISTS);
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar* root;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		VtgConfiguration* _tmp10_ = NULL;
		gboolean _tmp11_;
		root = NULL;
		_tmp10_ = vtg_plugin_get_config (vtg_plugin_main_instance);
		_tmp11_ = vtg_configuration_get_project_find_root_folder (_tmp10_);
		if (_tmp11_) {
			gboolean _tmp12_;
			_tmp12_ = vtg_utils_is_vala_doc (document);
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gchar* _tmp13_ = NULL;
			gboolean _tmp14_;
			_tmp14_ = vtg_projects_find_project_root_folder (self, file, &_tmp13_);
			_g_free0 (root);
			root = _tmp13_;
			_tmp8_ = _tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			{
				ValaList* _tmp15_;
				ValaList* _project_manager_list;
				gint _tmp16_;
				gint _project_manager_size;
				gint _project_manager_index;
				_tmp15_ = _vala_iterable_ref0 (self->priv->_project_managers);
				_project_manager_list = _tmp15_;
				_tmp16_ = vala_collection_get_size ((ValaCollection*) _project_manager_list);
				_project_manager_size = _tmp16_;
				_project_manager_index = -1;
				while (TRUE) {
					gpointer _tmp17_ = NULL;
					VtgProjectManager* project_manager;
					VbfProject* _tmp18_ = NULL;
					gboolean _tmp19_;
					_project_manager_index = _project_manager_index + 1;
					if (!(_project_manager_index < _project_manager_size)) {
						break;
					}
					_tmp17_ = vala_list_get (_project_manager_list, _project_manager_index);
					project_manager = (VtgProjectManager*) _tmp17_;
					_tmp18_ = vtg_project_manager_get_project (project_manager);
					_tmp19_ = g_str_has_prefix (_tmp18_->id, root);
					if (_tmp19_) {
						VtgProjectManager* _tmp20_;
						_tmp20_ = _g_object_ref0 (project_manager);
						_g_object_unref0 (_result_);
						_result_ = _tmp20_;
						_g_object_unref0 (project_manager);
						break;
					}
					_g_object_unref0 (project_manager);
				}
				_vala_iterable_unref0 (_project_manager_list);
			}
			if (_result_ == NULL) {
				VtgProjectManager* _tmp21_ = NULL;
				VtgProjectManager* project;
				VtgProjectManager* _tmp22_;
				_tmp21_ = vtg_projects_open_project (self, root, &_inner_error_);
				project = _tmp21_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (root);
					_g_free0 (file);
					_g_object_unref0 (_result_);
					return NULL;
				}
				vtg_project_manager_set_automanaged (project, TRUE);
				_tmp22_ = _g_object_ref0 (project);
				_g_object_unref0 (_result_);
				_result_ = _tmp22_;
				_g_object_unref0 (project);
			}
		}
		_g_free0 (root);
	}
	if (_result_ == NULL) {
		VtgProjectManager* _tmp23_;
		_tmp23_ = _g_object_ref0 (self->priv->_default_project);
		_g_object_unref0 (_result_);
		_result_ = _tmp23_;
	}
	result = _result_;
	_g_free0 (file);
	return result;
}


static gboolean vtg_projects_find_project_root_folder (VtgProjects* self, const gchar* file, gchar** root) {
	gchar* _root = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFile* dir;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_path_get_dirname (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	_g_free0 (_root);
	_root = NULL;
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			VbfIProjectBackend* dummy = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			VbfIProjectBackend* _tmp9_ = NULL;
			gboolean _tmp10_;
			gboolean _tmp11_;
			GFile* _tmp13_ = NULL;
			if (!_tmp4_) {
				if (!(dir != NULL)) {
					break;
				}
			}
			_tmp4_ = FALSE;
			_tmp5_ = g_file_get_path (dir);
			_tmp6_ = _tmp5_;
			vtg_utils_trace ("vtgprojects.vala:172: testing directory: %s", _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = g_file_get_path (dir);
			_tmp8_ = _tmp7_;
			_tmp10_ = vbf_probe (_tmp8_, &_tmp9_);
			_g_object_unref0 (dummy);
			dummy = _tmp9_;
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			if (_tmp11_) {
				gchar* _tmp12_ = NULL;
				_tmp12_ = g_file_get_path (dir);
				_g_free0 (_root);
				_root = _tmp12_;
			} else {
				if (_root != NULL) {
					_g_object_unref0 (dummy);
					break;
				}
			}
			_tmp13_ = g_file_get_parent (dir);
			_g_object_unref0 (dir);
			dir = _tmp13_;
			_g_object_unref0 (dummy);
		}
	}
	if (_root != NULL) {
		vtg_utils_trace ("vtgprojects.vala:185: found project directory: %s", _root);
	}
	result = _root != NULL;
	_g_object_unref0 (dir);
	if (root) {
		*root = _root;
	} else {
		_g_free0 (_root);
	}
	return result;
}


VtgProjectManager* vtg_projects_get_project_manager_for_project_id (VtgProjects* self, const gchar* project_id) {
	VtgProjectManager* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		ValaList* _tmp0_;
		ValaList* _item_list;
		gint _tmp1_;
		gint _item_size;
		gint _item_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_project_managers);
		_item_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _item_list);
		_item_size = _tmp1_;
		_item_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgProjectManager* item;
			VbfProject* _tmp3_ = NULL;
			_item_index = _item_index + 1;
			if (!(_item_index < _item_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_item_list, _item_index);
			item = (VtgProjectManager*) _tmp2_;
			_tmp3_ = vtg_project_manager_get_project (item);
			if (g_strcmp0 (_tmp3_->id, project_id) == 0) {
				result = item;
				_vala_iterable_unref0 (_item_list);
				return result;
			}
			_g_object_unref0 (item);
		}
		_vala_iterable_unref0 (_item_list);
	}
	result = NULL;
	return result;
}


VtgProjectManager* vtg_projects_get_project_manager_for_project_name (VtgProjects* self, const gchar* project_name) {
	VtgProjectManager* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (project_name != NULL) {
		{
			ValaList* _tmp0_;
			ValaList* _item_list;
			gint _tmp1_;
			gint _item_size;
			gint _item_index;
			_tmp0_ = _vala_iterable_ref0 (self->priv->_project_managers);
			_item_list = _tmp0_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) _item_list);
			_item_size = _tmp1_;
			_item_index = -1;
			while (TRUE) {
				gpointer _tmp2_ = NULL;
				VtgProjectManager* item;
				VbfProject* _tmp3_ = NULL;
				_item_index = _item_index + 1;
				if (!(_item_index < _item_size)) {
					break;
				}
				_tmp2_ = vala_list_get (_item_list, _item_index);
				item = (VtgProjectManager*) _tmp2_;
				_tmp3_ = vtg_project_manager_get_project (item);
				if (g_strcmp0 (_tmp3_->name, project_name) == 0) {
					result = item;
					_vala_iterable_unref0 (_item_list);
					return result;
				}
				_g_object_unref0 (item);
			}
			_vala_iterable_unref0 (_item_list);
		}
	}
	result = NULL;
	return result;
}


VbfTarget* vtg_projects_get_target_for_document (VtgProjects* self, GeditDocument* document) {
	VbfTarget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (document != NULL) {
		gchar* _tmp0_ = NULL;
		gchar* file;
		_tmp0_ = vtg_utils_get_document_name (document);
		file = _tmp0_;
		if (file != NULL) {
			{
				ValaList* _tmp1_;
				ValaList* _item_list;
				gint _tmp2_;
				gint _item_size;
				gint _item_index;
				_tmp1_ = _vala_iterable_ref0 (self->priv->_project_managers);
				_item_list = _tmp1_;
				_tmp2_ = vala_collection_get_size ((ValaCollection*) _item_list);
				_item_size = _tmp2_;
				_item_index = -1;
				while (TRUE) {
					gpointer _tmp3_ = NULL;
					VtgProjectManager* item;
					VbfSource* _tmp4_ = NULL;
					VbfSource* source;
					_item_index = _item_index + 1;
					if (!(_item_index < _item_size)) {
						break;
					}
					_tmp3_ = vala_list_get (_item_list, _item_index);
					item = (VtgProjectManager*) _tmp3_;
					_tmp4_ = vtg_project_manager_get_source_file_for_filename (item, file);
					source = _tmp4_;
					if (source != NULL) {
						VbfTarget* _tmp5_;
						_tmp5_ = _g_object_ref0 (((VbfFile*) source)->target);
						result = _tmp5_;
						_g_object_unref0 (source);
						_g_object_unref0 (item);
						_vala_iterable_unref0 (_item_list);
						_g_free0 (file);
						return result;
					}
					_g_object_unref0 (source);
					_g_object_unref0 (item);
				}
				_vala_iterable_unref0 (_item_list);
			}
		}
		_g_free0 (file);
	}
	result = NULL;
	return result;
}


VtgProjectManager* vtg_projects_get_default_project (VtgProjects* self) {
	VtgProjectManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_project;
	return result;
}


ValaList* vtg_projects_get_project_managers (VtgProjects* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project_managers;
	return result;
}


static void vtg_projects_class_init (VtgProjectsClass * klass) {
	vtg_projects_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_projects_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_projects_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECTS_DEFAULT_PROJECT, g_param_spec_object ("default-project", "default-project", "default-project", VTG_TYPE_PROJECT_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECTS_PROJECT_MANAGERS, vala_param_spec_iterable ("project-managers", "project-managers", "project-managers", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("project_opened", VTG_TYPE_PROJECTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
	g_signal_new ("project_closed", VTG_TYPE_PROJECTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
}


static void vtg_projects_instance_init (VtgProjects * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VTG_PROJECTS_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VTG_TYPE_PROJECT_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_project_managers = (ValaList*) _tmp0_;
	self->priv->_default_project = NULL;
}


static void vtg_projects_finalize (GObject* obj) {
	VtgProjects * self;
	self = VTG_PROJECTS (obj);
	_vala_iterable_unref0 (self->priv->_project_managers);
	_g_object_unref0 (self->priv->_default_project);
	G_OBJECT_CLASS (vtg_projects_parent_class)->finalize (obj);
}


GType vtg_projects_get_type (void) {
	return vtg_projects_type_id;
}


GType vtg_projects_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjects), 0, (GInstanceInitFunc) vtg_projects_instance_init, NULL };
	vtg_projects_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjects", &g_define_type_info, 0);
	return vtg_projects_type_id;
}


static void _vala_vtg_projects_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjects * self;
	self = VTG_PROJECTS (object);
	switch (property_id) {
		case VTG_PROJECTS_DEFAULT_PROJECT:
		g_value_set_object (value, vtg_projects_get_default_project (self));
		break;
		case VTG_PROJECTS_PROJECT_MANAGERS:
		vala_value_set_iterable (value, vtg_projects_get_project_managers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



