/* vtgoutputview.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgoutputview.vala, do not modify */

/*
 *  vtgoutputview.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-panel.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>


#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;
typedef struct _VtgOutputViewPrivate VtgOutputViewPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROCESS_WATCH_INFO (vtg_process_watch_info_get_type ())
#define VTG_PROCESS_WATCH_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROCESS_WATCH_INFO, VtgProcessWatchInfo))
#define VTG_PROCESS_WATCH_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROCESS_WATCH_INFO, VtgProcessWatchInfoClass))
#define VTG_IS_PROCESS_WATCH_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROCESS_WATCH_INFO))
#define VTG_IS_PROCESS_WATCH_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROCESS_WATCH_INFO))
#define VTG_PROCESS_WATCH_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROCESS_WATCH_INFO, VtgProcessWatchInfoClass))

typedef struct _VtgProcessWatchInfo VtgProcessWatchInfo;
typedef struct _VtgProcessWatchInfoClass VtgProcessWatchInfoClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _VtgProcessWatchInfoPrivate VtgProcessWatchInfoPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vtg_process_watch_info_unref0(var) ((var == NULL) ? NULL : (var = (vtg_process_watch_info_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;

struct _VtgOutputView {
	GObject parent_instance;
	VtgOutputViewPrivate * priv;
	VtgPluginInstance* _plugin_instance;
};

struct _VtgOutputViewClass {
	GObjectClass parent_class;
	void (*start_watch) (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
	void (*stop_watch) (VtgOutputView* self, guint id);
};

struct _VtgOutputViewPrivate {
	ValaList* _processes;
	GString* line;
	GtkTextBuffer* _messages;
	GtkTextView* _textview;
	GtkScrolledWindow* _ui;
	char** keywords;
	gint keywords_length1;
	gint _keywords_size_;
};

struct _VtgProcessWatchInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgProcessWatchInfoPrivate * priv;
	guint id;
	GIOChannel* stdin;
	GIOChannel* stdout;
	GIOChannel* stderr;
	guint stdout_watch_id;
	guint stderr_watch_id;
	VtgOutputTypes output_type;
};

struct _VtgProcessWatchInfoClass {
	GTypeClass parent_class;
	void (*finalize) (VtgProcessWatchInfo *self);
};


static gpointer vtg_output_view_parent_class = NULL;
static GType vtg_output_view_type_id = 0;

GType vtg_output_types_get_type (void) G_GNUC_CONST;
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
gpointer vtg_process_watch_info_ref (gpointer instance);
void vtg_process_watch_info_unref (gpointer instance);
GParamSpec* vtg_param_spec_process_watch_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_process_watch_info (GValue* value, gpointer v_object);
void vtg_value_take_process_watch_info (GValue* value, gpointer v_object);
gpointer vtg_value_get_process_watch_info (const GValue* value);
GType vtg_process_watch_info_get_type (void) G_GNUC_CONST;
GType vtg_process_watch_info_register_type (GTypeModule * module);
#define VTG_OUTPUT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewPrivate))
enum  {
	VTG_OUTPUT_VIEW_DUMMY_PROPERTY,
	VTG_OUTPUT_VIEW_PLUGIN_INSTANCE
};
VtgOutputView* vtg_output_view_new (VtgPluginInstance* plugin_instance);
VtgOutputView* vtg_output_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
static gboolean vtg_output_view_on_textview_key_press (VtgOutputView* self, GtkWidget* sender, GdkEventKey* evt);
static VtgProcessWatchInfo* vtg_output_view_find_process_by_id (VtgOutputView* self, guint id);
static VtgProcessWatchInfo* vtg_output_view_find_process_by_io_channel (VtgOutputView* self, GIOChannel* chan);
static VtgProcessWatchInfo* vtg_output_view_add_process_view (VtgOutputView* self, guint id);
VtgProcessWatchInfo* vtg_process_watch_info_new (guint id);
VtgProcessWatchInfo* vtg_process_watch_info_construct (GType object_type, guint id);
void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
static void vtg_output_view_real_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
void vtg_output_view_stop_watch (VtgOutputView* self, guint id);
static gboolean vtg_output_view_on_messages (VtgOutputView* self, GIOChannel* source, GIOCondition condition);
static gboolean _vtg_output_view_on_messages_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_output_view_real_stop_watch (VtgOutputView* self, guint id);
void vtg_process_watch_info_cleanup (VtgProcessWatchInfo* self);
void vtg_output_view_clean_output (VtgOutputView* self);
static void vtg_output_view_log_channel (VtgOutputView* self, GIOChannel* source, GError** error);
void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const char* message);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
char* vtg_string_utils_replace (const char* data, const char* search, const char* replace);
void vtg_output_view_activate (VtgOutputView* self);
VtgPluginInstance* vtg_output_view_get_plugin_instance (VtgOutputView* self);
static void vtg_output_view_set_plugin_instance (VtgOutputView* self, VtgPluginInstance* value);
static gboolean _vtg_output_view_on_textview_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static GObject * vtg_output_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vtg_output_view_finalize (GObject* obj);
static void vtg_output_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_output_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType vtg_output_types_get_type (void) {
	static volatile gsize vtg_output_types_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_output_types_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_OUTPUT_TYPES_MESSAGE, "VTG_OUTPUT_TYPES_MESSAGE", "message"}, {VTG_OUTPUT_TYPES_ERROR, "VTG_OUTPUT_TYPES_ERROR", "error"}, {VTG_OUTPUT_TYPES_CHILD_PROCESS, "VTG_OUTPUT_TYPES_CHILD_PROCESS", "child-process"}, {VTG_OUTPUT_TYPES_BUILD, "VTG_OUTPUT_TYPES_BUILD", "build"}, {VTG_OUTPUT_TYPES_SEARCH, "VTG_OUTPUT_TYPES_SEARCH", "search"}, {0, NULL, NULL}};
		GType vtg_output_types_type_id;
		vtg_output_types_type_id = g_enum_register_static ("VtgOutputTypes", values);
		g_once_init_leave (&vtg_output_types_type_id__volatile, vtg_output_types_type_id);
	}
	return vtg_output_types_type_id__volatile;
}


VtgOutputView* vtg_output_view_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgOutputView * self;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgOutputView*) g_object_new (object_type, "plugin-instance", plugin_instance, NULL);
	return self;
}


VtgOutputView* vtg_output_view_new (VtgPluginInstance* plugin_instance) {
	return vtg_output_view_construct (VTG_TYPE_OUTPUT_VIEW, plugin_instance);
}


static gboolean vtg_output_view_on_textview_key_press (VtgOutputView* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if ((*evt).keyval == GDK_Return) {
		char* buffer;
		buffer = NULL;
		if (self->priv->line->len == 0) {
			char* _tmp0_;
			buffer = (_tmp0_ = g_strdup ("\n"), _g_free0 (buffer), _tmp0_);
		} else {
			char* _tmp1_;
			buffer = (_tmp1_ = g_strdup_printf ("%s\n", self->priv->line->str), _g_free0 (buffer), _tmp1_);
		}
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_processes);
			while (TRUE) {
				VtgProcessWatchInfo* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (VtgProcessWatchInfo*) vala_iterator_get (_item_it);
				if (item->stdin != NULL) {
					gsize bw = 0UL;
					{
						g_io_channel_write_chars (item->stdin, (gchar*) buffer, -1, &bw, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch31_g_error;
						}
						g_io_channel_flush (item->stdin, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch31_g_error;
						}
					}
					goto __finally31;
					__catch31_g_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
							g_warning ("vtgoutputview.vala:107: on_textview_key_press - error: %s", err->message);
							_g_error_free0 (err);
						}
					}
					__finally31:
					if (_inner_error_ != NULL) {
						_vtg_process_watch_info_unref0 (item);
						_vala_collection_object_unref0 (_item_it);
						_g_free0 (buffer);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				_vtg_process_watch_info_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
		g_string_erase (self->priv->line, (gssize) 0, (gssize) (-1));
		_g_free0 (buffer);
	} else {
		gunichar ch;
		ch = (gunichar) gdk_keyval_to_unicode ((*evt).keyval);
		g_string_append_unichar (self->priv->line, ch);
	}
	result = FALSE;
	return result;
}


static VtgProcessWatchInfo* vtg_output_view_find_process_by_id (VtgOutputView* self, guint id) {
	VtgProcessWatchInfo* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		ValaIterator* _target_it;
		_target_it = vala_iterable_iterator ((ValaIterable*) self->priv->_processes);
		while (TRUE) {
			VtgProcessWatchInfo* target;
			if (!vala_iterator_next (_target_it)) {
				break;
			}
			target = (VtgProcessWatchInfo*) vala_iterator_get (_target_it);
			if (target->id == id) {
				result = target;
				_vala_collection_object_unref0 (_target_it);
				return result;
			}
			_vtg_process_watch_info_unref0 (target);
		}
		_vala_collection_object_unref0 (_target_it);
	}
	result = NULL;
	return result;
}


static VtgProcessWatchInfo* vtg_output_view_find_process_by_io_channel (VtgOutputView* self, GIOChannel* chan) {
	VtgProcessWatchInfo* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chan != NULL, NULL);
	{
		ValaIterator* _target_it;
		_target_it = vala_iterable_iterator ((ValaIterable*) self->priv->_processes);
		while (TRUE) {
			VtgProcessWatchInfo* target;
			gboolean _tmp0_ = FALSE;
			if (!vala_iterator_next (_target_it)) {
				break;
			}
			target = (VtgProcessWatchInfo*) vala_iterator_get (_target_it);
			if (target->stdout == chan) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = target->stderr == chan;
			}
			if (_tmp0_) {
				result = target;
				_vala_collection_object_unref0 (_target_it);
				return result;
			}
			_vtg_process_watch_info_unref0 (target);
		}
		_vala_collection_object_unref0 (_target_it);
	}
	result = NULL;
	return result;
}


static VtgProcessWatchInfo* vtg_output_view_add_process_view (VtgOutputView* self, guint id) {
	VtgProcessWatchInfo* result = NULL;
	VtgProcessWatchInfo* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = vtg_process_watch_info_new (id);
	vala_collection_add ((ValaCollection*) self->priv->_processes, _result_);
	result = _result_;
	return result;
}


static gboolean _vtg_output_view_on_messages_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = vtg_output_view_on_messages (self, source, condition);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void vtg_output_view_real_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		VtgProcessWatchInfo* target;
		VtgProcessWatchInfo* _tmp0_;
		GIOChannel* _tmp2_;
		GIOChannel* _tmp3_;
		GeditPanel* panel;
		target = vtg_output_view_find_process_by_id (self, id);
		if (target != NULL) {
			vtg_output_view_stop_watch (self, id);
		}
		target = (_tmp0_ = vtg_output_view_add_process_view (self, id), _vtg_process_watch_info_unref0 (target), _tmp0_);
		target->output_type = output_type;
		if (stdi != (-1)) {
			GIOChannel* _tmp1_;
			target->stdin = (_tmp1_ = g_io_channel_unix_new (stdi), _g_io_channel_unref0 (target->stdin), _tmp1_);
		}
		target->stdout = (_tmp2_ = g_io_channel_unix_new (stdo), _g_io_channel_unref0 (target->stdout), _tmp2_);
		target->stdout_watch_id = g_io_add_watch (target->stdout, G_IO_IN | G_IO_PRI, _vtg_output_view_on_messages_gio_func, self);
		g_io_channel_set_flags (target->stdout, g_io_channel_get_flags (target->stdout) | G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			_vtg_process_watch_info_unref0 (target);
			goto __catch32_g_error;
		}
		target->stderr = (_tmp3_ = g_io_channel_unix_new (stde), _g_io_channel_unref0 (target->stderr), _tmp3_);
		target->stderr_watch_id = g_io_add_watch (target->stderr, G_IO_IN | G_IO_PRI, _vtg_output_view_on_messages_gio_func, self);
		g_io_channel_set_flags (target->stderr, g_io_channel_get_flags (target->stderr) | G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			_vtg_process_watch_info_unref0 (target);
			goto __catch32_g_error;
		}
		g_string_erase (self->priv->line, (gssize) 0, (gssize) (-1));
		panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->_plugin_instance)));
		if (!gtk_widget_get_visible ((GtkWidget*) panel)) {
			gtk_widget_show_all ((GtkWidget*) panel);
		}
		_g_object_unref0 (panel);
		_vtg_process_watch_info_unref0 (target);
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgoutputview.vala:181: error during watch setup: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi) {
	VTG_OUTPUT_VIEW_GET_CLASS (self)->start_watch (self, output_type, id, stdo, stde, stdi);
}


static void vtg_output_view_real_stop_watch (VtgOutputView* self, guint id) {
	VtgProcessWatchInfo* target;
	g_return_if_fail (self != NULL);
	target = vtg_output_view_find_process_by_id (self, id);
	if (target == NULL) {
		g_warning ("vtgoutputview.vala:190: stop_watch: no target with id %u found", id);
		_vtg_process_watch_info_unref0 (target);
		return;
	}
	vtg_process_watch_info_cleanup (target);
	vala_list_remove_at (self->priv->_processes, vala_list_index_of (self->priv->_processes, target));
	_vtg_process_watch_info_unref0 (target);
}


void vtg_output_view_stop_watch (VtgOutputView* self, guint id) {
	VTG_OUTPUT_VIEW_GET_CLASS (self)->stop_watch (self, id);
}


void vtg_output_view_clean_output (VtgOutputView* self) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_set_text (self->priv->_messages, "", 0);
}


static void vtg_output_view_log_channel (VtgOutputView* self, GIOChannel* source, GError** error) {
	GString* message;
	gsize len;
	gint buff_length1;
	gint _buff_size_;
	gchar* _tmp0_;
	gchar* buff;
	GIOStatus res;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	message = g_string_new ("");
	len = (gsize) 0;
	buff = (_tmp0_ = g_new0 (gchar, 4096), buff_length1 = 4096, _buff_size_ = buff_length1, _tmp0_);
	res = G_IO_STATUS_NORMAL;
	while (TRUE) {
		GIOStatus _tmp1_;
		if (!(res == G_IO_STATUS_NORMAL)) {
			break;
		}
		_tmp1_ = g_io_channel_read_chars (source, buff, buff_length1, &len, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			_g_string_free0 (message);
			return;
		}
		res = _tmp1_;
		if (len > 0) {
			g_string_append_len (message, (const char*) buff, (gssize) len);
		}
	}
	if (message->len > 0) {
		VtgProcessWatchInfo* process;
		VtgOutputTypes output_type = 0;
		process = vtg_output_view_find_process_by_io_channel (self, source);
		if (process != NULL) {
			output_type = process->output_type;
		} else {
			output_type = VTG_OUTPUT_TYPES_CHILD_PROCESS;
		}
		vtg_output_view_log_message (self, output_type, message->str);
		_vtg_process_watch_info_unref0 (process);
	}
	buff = (g_free (buff), NULL);
	_g_string_free0 (message);
}


static gboolean vtg_output_view_on_messages (VtgOutputView* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	{
		if ((condition & (G_IO_IN | G_IO_PRI)) != 0) {
			vtg_output_view_log_channel (self, source, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch33_g_error;
			}
		}
		result = TRUE;
		return result;
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgoutputview.vala:236: Error reading from process %s", err->message);
			result = FALSE;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally33:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const char* message) {
	gint lines_length1;
	gint _lines_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** lines;
	GtkTextIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	lines = (_tmp1_ = _tmp0_ = g_strsplit (message, "\n", 0), lines_length1 = _vala_array_length (_tmp0_), _lines_size_ = lines_length1, _tmp1_);
	gtk_text_buffer_get_iter_at_mark (self->priv->_messages, &iter, gtk_text_buffer_get_insert (self->priv->_messages));
	{
		gint count;
		count = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				char* line;
				if (!_tmp2_) {
					count++;
				}
				_tmp2_ = FALSE;
				if (!(count < lines_length1)) {
					break;
				}
				line = g_strdup (lines[count]);
				if (!vtg_string_utils_is_null_or_empty (line)) {
					char* _tmp4_;
					char* _tmp5_;
					char* _tmp6_;
					{
						char** keyword_collection;
						int keyword_collection_length1;
						int keyword_it;
						keyword_collection = self->priv->keywords;
						keyword_collection_length1 = self->priv->keywords_length1;
						for (keyword_it = 0; keyword_it < self->priv->keywords_length1; keyword_it = keyword_it + 1) {
							char* keyword;
							keyword = g_strdup (keyword_collection[keyword_it]);
							{
								if (g_str_has_prefix (line, keyword)) {
									char* _tmp3_;
									gtk_text_buffer_insert_with_tags_by_name (self->priv->_messages, &iter, keyword, -1, "keyword", NULL);
									line = (_tmp3_ = string_substring (line, string_get_length (keyword), -1), _g_free0 (line), _tmp3_);
								}
								_g_free0 (keyword);
							}
						}
					}
					line = (_tmp4_ = vtg_string_utils_replace (line, "[1m", ""), _g_free0 (line), _tmp4_);
					line = (_tmp5_ = vtg_string_utils_replace (line, "[m", ""), _g_free0 (line), _tmp5_);
					line = (_tmp6_ = vtg_string_utils_replace (line, "(B", ""), _g_free0 (line), _tmp6_);
				}
				if (count < (lines_length1 - 1)) {
					if (line == NULL) {
						char* _tmp7_;
						line = (_tmp7_ = g_strdup ("\n"), _g_free0 (line), _tmp7_);
					} else {
						if (!g_str_has_suffix (line, "\n")) {
							char* _tmp8_;
							line = (_tmp8_ = g_strconcat (line, "\n", NULL), _g_free0 (line), _tmp8_);
						}
					}
				}
				if (!vtg_string_utils_is_null_or_empty (line)) {
					gtk_text_buffer_insert (self->priv->_messages, &iter, line, -1);
				}
				_g_free0 (line);
			}
		}
	}
	gtk_text_view_scroll_mark_onscreen (self->priv->_textview, gtk_text_buffer_get_insert (self->priv->_messages));
	g_signal_emit_by_name (self, "message-added", output_type, message);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


void vtg_output_view_activate (VtgOutputView* self) {
	GeditPanel* panel;
	g_return_if_fail (self != NULL);
	panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->_plugin_instance)));
	gedit_panel_activate_item (panel, (GtkWidget*) self->priv->_ui);
	_g_object_unref0 (panel);
}


VtgPluginInstance* vtg_output_view_get_plugin_instance (VtgOutputView* self) {
	VtgPluginInstance* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->_plugin_instance;
	return result;
}


static void vtg_output_view_set_plugin_instance (VtgOutputView* self, VtgPluginInstance* value) {
	g_return_if_fail (self != NULL);
	self->_plugin_instance = value;
	g_object_notify ((GObject *) self, "plugin-instance");
}


static gboolean _vtg_output_view_on_textview_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_output_view_on_textview_key_press (self, _sender, event);
	return result;
}


static GObject * vtg_output_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VtgOutputView * self;
	parent_class = G_OBJECT_CLASS (vtg_output_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VTG_OUTPUT_VIEW (obj);
	{
		GeditPanel* panel;
		GtkTextBuffer* _tmp1_;
		GtkTextView* _tmp2_;
		PangoFontDescription* font_desc;
		GtkScrolledWindow* _tmp3_;
		panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->_plugin_instance)));
		self->priv->_messages = (_tmp1_ = gtk_text_buffer_new (NULL), _g_object_unref0 (self->priv->_messages), _tmp1_);
		gtk_text_buffer_create_tag (self->priv->_messages, "keyword", "weight", PANGO_WEIGHT_BOLD, NULL, NULL);
		self->priv->_textview = (_tmp2_ = g_object_ref_sink ((GtkTextView*) gtk_text_view_new_with_buffer (self->priv->_messages)), _g_object_unref0 (self->priv->_textview), _tmp2_);
		g_signal_connect_object ((GtkWidget*) self->priv->_textview, "key-press-event", (GCallback) _vtg_output_view_on_textview_key_press_gtk_widget_key_press_event, self, 0);
		font_desc = pango_font_description_from_string ("Monospace");
		gtk_widget_modify_font ((GtkWidget*) self->priv->_textview, font_desc);
		gtk_text_view_set_wrap_mode (self->priv->_textview, GTK_WRAP_CHAR);
		self->priv->_ui = (_tmp3_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (self->priv->_ui), _tmp3_);
		gtk_container_add ((GtkContainer*) self->priv->_ui, (GtkWidget*) self->priv->_textview);
		gtk_widget_show_all ((GtkWidget*) self->priv->_ui);
		gedit_panel_add_item (panel, (GtkWidget*) self->priv->_ui, _ ("Output"), NULL);
		_pango_font_description_free0 (font_desc);
		_g_object_unref0 (panel);
	}
	return obj;
}


static void vtg_output_view_class_init (VtgOutputViewClass * klass) {
	vtg_output_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgOutputViewPrivate));
	VTG_OUTPUT_VIEW_CLASS (klass)->start_watch = vtg_output_view_real_start_watch;
	VTG_OUTPUT_VIEW_CLASS (klass)->stop_watch = vtg_output_view_real_stop_watch;
	G_OBJECT_CLASS (klass)->get_property = vtg_output_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_output_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = vtg_output_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = vtg_output_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_OUTPUT_VIEW_PLUGIN_INSTANCE, g_param_spec_object ("plugin-instance", "plugin-instance", "plugin-instance", VTG_TYPE_PLUGIN_INSTANCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("message_added", VTG_TYPE_OUTPUT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_STRING, G_TYPE_NONE, 2, VTG_TYPE_OUTPUT_TYPES, G_TYPE_STRING);
}


static void vtg_output_view_instance_init (VtgOutputView * self) {
	char** _tmp0_ = NULL;
	self->priv = VTG_OUTPUT_VIEW_GET_PRIVATE (self);
	self->_plugin_instance = NULL;
	self->priv->_processes = (ValaList*) vala_array_list_new (VTG_TYPE_PROCESS_WATCH_INFO, (GBoxedCopyFunc) vtg_process_watch_info_ref, vtg_process_watch_info_unref, g_direct_equal);
	self->priv->line = g_string_new ("");
	self->priv->_ui = NULL;
	self->priv->keywords = (_tmp0_ = g_new0 (char*, 4 + 1), _tmp0_[0] = g_strdup ("checking"), _tmp0_[1] = g_strdup ("Checking"), _tmp0_[2] = g_strdup ("Running"), _tmp0_[3] = g_strdup ("  testing"), _tmp0_);
	self->priv->keywords_length1 = 4;
	self->priv->_keywords_size_ = self->priv->keywords_length1;
}


static void vtg_output_view_finalize (GObject* obj) {
	VtgOutputView * self;
	self = VTG_OUTPUT_VIEW (obj);
	{
		GeditPanel* panel;
		panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->_plugin_instance)));
		gedit_panel_remove_item (panel, (GtkWidget*) self->priv->_ui);
		_g_object_unref0 (panel);
	}
	_vala_collection_object_unref0 (self->priv->_processes);
	_g_string_free0 (self->priv->line);
	_g_object_unref0 (self->priv->_messages);
	_g_object_unref0 (self->priv->_textview);
	_g_object_unref0 (self->priv->_ui);
	self->priv->keywords = (_vala_array_free (self->priv->keywords, self->priv->keywords_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (vtg_output_view_parent_class)->finalize (obj);
}


GType vtg_output_view_get_type (void) {
	return vtg_output_view_type_id;
}


GType vtg_output_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgOutputViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_output_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgOutputView), 0, (GInstanceInitFunc) vtg_output_view_instance_init, NULL };
	vtg_output_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgOutputView", &g_define_type_info, 0);
	return vtg_output_view_type_id;
}


static void vtg_output_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgOutputView * self;
	self = VTG_OUTPUT_VIEW (object);
	switch (property_id) {
		case VTG_OUTPUT_VIEW_PLUGIN_INSTANCE:
		g_value_set_object (value, vtg_output_view_get_plugin_instance (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_output_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgOutputView * self;
	self = VTG_OUTPUT_VIEW (object);
	switch (property_id) {
		case VTG_OUTPUT_VIEW_PLUGIN_INSTANCE:
		vtg_output_view_set_plugin_instance (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



static void g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__ENUM_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_string (param_values + 2), data2);
}



