/* vbfproject.c generated by valac 0.10.0, the Vala compiler
 * generated from vbfproject.vala, do not modify */

/*
 *  vbfproject.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;
typedef struct _VbfConfigNodePrivate VbfConfigNodePrivate;

#define VBF_TYPE_PROJECT (vbf_project_get_type ())
#define VBF_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PROJECT, VbfProject))
#define VBF_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PROJECT, VbfProjectClass))
#define VBF_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PROJECT))
#define VBF_IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PROJECT))
#define VBF_PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PROJECT, VbfProjectClass))

typedef struct _VbfProject VbfProject;
typedef struct _VbfProjectClass VbfProjectClass;
typedef struct _VbfProjectPrivate VbfProjectPrivate;

#define VBF_TYPE_IPROJECT_BACKEND (vbf_iproject_backend_get_type ())
#define VBF_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackend))
#define VBF_IS_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_IPROJECT_BACKEND))
#define VBF_IPROJECT_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackendIface))

typedef struct _VbfIProjectBackend VbfIProjectBackend;
typedef struct _VbfIProjectBackendIface VbfIProjectBackendIface;

#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;

#define VBF_TYPE_MODULE (vbf_module_get_type ())
#define VBF_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_MODULE, VbfModule))
#define VBF_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_MODULE, VbfModuleClass))
#define VBF_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_MODULE))
#define VBF_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_MODULE))
#define VBF_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_MODULE, VbfModuleClass))

typedef struct _VbfModule VbfModule;
typedef struct _VbfModuleClass VbfModuleClass;

#define VBF_TYPE_VARIABLE (vbf_variable_get_type ())
#define VBF_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_VARIABLE, VbfVariable))
#define VBF_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_VARIABLE, VbfVariableClass))
#define VBF_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_VARIABLE))
#define VBF_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_VARIABLE))
#define VBF_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_VARIABLE, VbfVariableClass))

typedef struct _VbfVariable VbfVariable;
typedef struct _VbfVariableClass VbfVariableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _VbfGroupPrivate VbfGroupPrivate;

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;

#define VBF_TYPE_SOURCE (vbf_source_get_type ())
#define VBF_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_SOURCE, VbfSource))
#define VBF_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_SOURCE, VbfSourceClass))
#define VBF_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_SOURCE))
#define VBF_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_SOURCE))
#define VBF_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_SOURCE, VbfSourceClass))

typedef struct _VbfSource VbfSource;
typedef struct _VbfSourceClass VbfSourceClass;
typedef struct _VbfFilePrivate VbfFilePrivate;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())

struct _VbfConfigNode {
	GObject parent_instance;
	VbfConfigNodePrivate * priv;
	VbfConfigNode* parent;
};

struct _VbfConfigNodeClass {
	GObjectClass parent_class;
	char* (*to_string) (VbfConfigNode* self);
};

struct _VbfIProjectBackendIface {
	GTypeInterface parent_iface;
	gboolean (*probe) (VbfIProjectBackend* self, const char* project_file);
	VbfProject* (*open) (VbfIProjectBackend* self, const char* project_file);
	void (*refresh) (VbfIProjectBackend* self, VbfProject* project);
	char* (*get_configure_command) (VbfIProjectBackend* self);
	char* (*get_build_command) (VbfIProjectBackend* self);
	char* (*get_clean_command) (VbfIProjectBackend* self);
};

struct _VbfProject {
	VbfConfigNode parent_instance;
	VbfProjectPrivate * priv;
	char* id;
	char* name;
	char* url;
	char* version;
	char* working_dir;
	VbfIProjectBackend* backend;
};

struct _VbfProjectClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfProjectPrivate {
	ValaList* groups;
	ValaList* modules;
	ValaList* variables;
	gboolean in_update;
};

struct _VbfGroup {
	GObject parent_instance;
	VbfGroupPrivate * priv;
	char* name;
	char* id;
	VbfProject* project;
};

struct _VbfGroupClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfFile {
	GObject parent_instance;
	VbfFilePrivate * priv;
	char* name;
	char* filename;
	char* uri;
	VbfFileTypes type;
	VbfTarget* target;
};

struct _VbfFileClass {
	GObjectClass parent_class;
};


static gpointer vbf_project_parent_class = NULL;

GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_project_get_type (void) G_GNUC_CONST;
GType vbf_iproject_backend_get_type (void) G_GNUC_CONST;
GType vbf_group_get_type (void) G_GNUC_CONST;
GType vbf_module_get_type (void) G_GNUC_CONST;
GType vbf_variable_get_type (void) G_GNUC_CONST;
#define VBF_PROJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_TYPE_PROJECT, VbfProjectPrivate))
enum  {
	VBF_PROJECT_DUMMY_PROPERTY,
	VBF_PROJECT_CONFIGURE_COMMAND,
	VBF_PROJECT_BUILD_COMMAND,
	VBF_PROJECT_CLEAN_COMMAND
};
VbfProject* vbf_project_new (const char* id);
VbfProject* vbf_project_construct (GType object_type, const char* id);
VbfConfigNode* vbf_config_node_construct (GType object_type);
ValaList* vbf_project_get_groups (VbfProject* self);
VbfGroup* vbf_project_get_group (VbfProject* self, const char* id);
void vbf_project_add_group (VbfProject* self, VbfGroup* group);
ValaList* vbf_project_get_modules (VbfProject* self);
void vbf_project_add_module (VbfProject* self, VbfModule* module);
ValaList* vbf_project_get_variables (VbfProject* self);
void vbf_project_add_variable (VbfProject* self, VbfVariable* variable);
static char* vbf_project_real_to_string (VbfConfigNode* base);
char* vbf_project_get_all_source_files (VbfProject* self);
GType vbf_target_get_type (void) G_GNUC_CONST;
ValaList* vbf_group_get_targets (VbfGroup* self);
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_source_get_type (void) G_GNUC_CONST;
ValaList* vbf_target_get_sources (VbfTarget* self);
GType vbf_file_types_get_type (void) G_GNUC_CONST;
void vbf_project_clear (VbfProject* self);
void vbf_project_update (VbfProject* self);
void vbf_iproject_backend_refresh (VbfIProjectBackend* self, VbfProject* project);
char* vbf_project_get_configure_command (VbfProject* self);
char* vbf_iproject_backend_get_configure_command (VbfIProjectBackend* self);
char* vbf_project_get_build_command (VbfProject* self);
char* vbf_iproject_backend_get_build_command (VbfIProjectBackend* self);
char* vbf_project_get_clean_command (VbfProject* self);
char* vbf_iproject_backend_get_clean_command (VbfIProjectBackend* self);
static void vbf_project_finalize (GObject* obj);
static void vbf_project_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



VbfProject* vbf_project_construct (GType object_type, const char* id) {
	VbfProject * self;
	char* _tmp0_;
	g_return_val_if_fail (id != NULL, NULL);
	self = (VbfProject*) vbf_config_node_construct (object_type);
	self->id = (_tmp0_ = g_strdup (id), _g_free0 (self->id), _tmp0_);
	return self;
}


VbfProject* vbf_project_new (const char* id) {
	return vbf_project_construct (VBF_TYPE_PROJECT, id);
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vbf_project_get_groups (VbfProject* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->groups);
	return result;
}


VbfGroup* vbf_project_get_group (VbfProject* self, const char* id) {
	VbfGroup* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		ValaIterator* _group_it;
		_group_it = vala_iterable_iterator ((ValaIterable*) self->priv->groups);
		while (TRUE) {
			VbfGroup* group;
			if (!vala_iterator_next (_group_it)) {
				break;
			}
			group = (VbfGroup*) vala_iterator_get (_group_it);
			if (_vala_strcmp0 (group->id, id) == 0) {
				result = group;
				_vala_collection_object_unref0 (_group_it);
				return result;
			}
			_g_object_unref0 (group);
		}
		_vala_collection_object_unref0 (_group_it);
	}
	result = NULL;
	return result;
}


void vbf_project_add_group (VbfProject* self, VbfGroup* group) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	vala_collection_add ((ValaCollection*) self->priv->groups, group);
}


ValaList* vbf_project_get_modules (VbfProject* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->modules);
	return result;
}


void vbf_project_add_module (VbfProject* self, VbfModule* module) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (module != NULL);
	vala_collection_add ((ValaCollection*) self->priv->modules, module);
}


ValaList* vbf_project_get_variables (VbfProject* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->variables);
	return result;
}


void vbf_project_add_variable (VbfProject* self, VbfVariable* variable) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	vala_collection_add ((ValaCollection*) self->priv->variables, variable);
}


static char* vbf_project_real_to_string (VbfConfigNode* base) {
	VbfProject * self;
	char* result = NULL;
	self = (VbfProject*) base;
	result = g_strdup_printf ("%s %s: %s", self->name, self->version, self->id);
	return result;
}


char* vbf_project_get_all_source_files (VbfProject* self) {
	char* result = NULL;
	char* res;
	g_return_val_if_fail (self != NULL, NULL);
	res = g_strdup ("");
	{
		ValaIterator* _group_it;
		_group_it = vala_iterable_iterator ((ValaIterable*) self->priv->groups);
		while (TRUE) {
			VbfGroup* group;
			if (!vala_iterator_next (_group_it)) {
				break;
			}
			group = (VbfGroup*) vala_iterator_get (_group_it);
			{
				ValaList* _tmp0_;
				ValaIterator* _tmp1_;
				ValaIterator* _target_it;
				_target_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					VbfTarget* target;
					if (!vala_iterator_next (_target_it)) {
						break;
					}
					target = (VbfTarget*) vala_iterator_get (_target_it);
					{
						ValaList* _tmp2_;
						ValaIterator* _tmp3_;
						ValaIterator* _source_it;
						_source_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
						while (TRUE) {
							VbfSource* source;
							char* _tmp4_;
							if (!vala_iterator_next (_source_it)) {
								break;
							}
							source = (VbfSource*) vala_iterator_get (_source_it);
							res = (_tmp4_ = g_strconcat (res, "\"", ((VbfFile*) source)->filename, "\"", NULL), _g_free0 (res), _tmp4_);
							_g_object_unref0 (source);
						}
						_vala_collection_object_unref0 (_source_it);
					}
					_g_object_unref0 (target);
				}
				_vala_collection_object_unref0 (_target_it);
			}
			_g_object_unref0 (group);
		}
		_vala_collection_object_unref0 (_group_it);
	}
	result = res;
	return result;
}


void vbf_project_clear (VbfProject* self) {
	g_return_if_fail (self != NULL);
	vala_collection_clear ((ValaCollection*) self->priv->groups);
	vala_collection_clear ((ValaCollection*) self->priv->variables);
	vala_collection_clear ((ValaCollection*) self->priv->modules);
}


void vbf_project_update (VbfProject* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->in_update) {
		return;
	}
	self->priv->in_update = TRUE;
	if (self->backend != NULL) {
		vbf_iproject_backend_refresh (self->backend, self);
	}
	g_signal_emit_by_name (self, "updated");
	self->priv->in_update = FALSE;
}


char* vbf_project_get_configure_command (VbfProject* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->backend == NULL) {
		result = NULL;
		return result;
	}
	result = vbf_iproject_backend_get_configure_command (self->backend);
	return result;
}


char* vbf_project_get_build_command (VbfProject* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->backend == NULL) {
		result = NULL;
		return result;
	}
	result = vbf_iproject_backend_get_build_command (self->backend);
	return result;
}


char* vbf_project_get_clean_command (VbfProject* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->backend == NULL) {
		result = NULL;
		return result;
	}
	result = vbf_iproject_backend_get_clean_command (self->backend);
	return result;
}


static void vbf_project_class_init (VbfProjectClass * klass) {
	vbf_project_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfProjectPrivate));
	VBF_CONFIG_NODE_CLASS (klass)->to_string = vbf_project_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = vbf_project_get_property;
	G_OBJECT_CLASS (klass)->finalize = vbf_project_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VBF_PROJECT_CONFIGURE_COMMAND, g_param_spec_string ("configure-command", "configure-command", "configure-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VBF_PROJECT_BUILD_COMMAND, g_param_spec_string ("build-command", "build-command", "build-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VBF_PROJECT_CLEAN_COMMAND, g_param_spec_string ("clean-command", "clean-command", "clean-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("updated", VBF_TYPE_PROJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vbf_project_instance_init (VbfProject * self) {
	self->priv = VBF_PROJECT_GET_PRIVATE (self);
	self->priv->groups = (ValaList*) vala_array_list_new (VBF_TYPE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->modules = (ValaList*) vala_array_list_new (VBF_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->variables = (ValaList*) vala_array_list_new (VBF_TYPE_VARIABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->in_update = FALSE;
	self->backend = NULL;
}


static void vbf_project_finalize (GObject* obj) {
	VbfProject * self;
	self = VBF_PROJECT (obj);
	_g_free0 (self->id);
	_g_free0 (self->name);
	_g_free0 (self->url);
	_g_free0 (self->version);
	_g_free0 (self->working_dir);
	_vala_collection_object_unref0 (self->priv->groups);
	_vala_collection_object_unref0 (self->priv->modules);
	_vala_collection_object_unref0 (self->priv->variables);
	_g_object_unref0 (self->backend);
	G_OBJECT_CLASS (vbf_project_parent_class)->finalize (obj);
}


GType vbf_project_get_type (void) {
	static volatile gsize vbf_project_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_project_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfProjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_project_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfProject), 0, (GInstanceInitFunc) vbf_project_instance_init, NULL };
		GType vbf_project_type_id;
		vbf_project_type_id = g_type_register_static (VBF_TYPE_CONFIG_NODE, "VbfProject", &g_define_type_info, 0);
		g_once_init_leave (&vbf_project_type_id__volatile, vbf_project_type_id);
	}
	return vbf_project_type_id__volatile;
}


static void vbf_project_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VbfProject * self;
	self = VBF_PROJECT (object);
	switch (property_id) {
		case VBF_PROJECT_CONFIGURE_COMMAND:
		g_value_take_string (value, vbf_project_get_configure_command (self));
		break;
		case VBF_PROJECT_BUILD_COMMAND:
		g_value_take_string (value, vbf_project_get_build_command (self));
		break;
		case VBF_PROJECT_CLEAN_COMMAND:
		g_value_take_string (value, vbf_project_get_clean_command (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




