/* tagcloud.c generated by valac 0.10.0, the Vala compiler
 * generated from tagcloud.vala, do not modify */

/* tagcloud.vala
 *
 * Copyright (C) 2010  Andrea Del Signore
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <pango/pango.h>


#define VALA_TYPE_TAG_CLOUD (vala_tag_cloud_get_type ())
#define VALA_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloud))
#define VALA_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))
#define VALA_IS_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD))
#define VALA_IS_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD))
#define VALA_TAG_CLOUD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))

typedef struct _ValaTagCloud ValaTagCloud;
typedef struct _ValaTagCloudClass ValaTagCloudClass;
typedef struct _ValaTagCloudPrivate ValaTagCloudPrivate;

#define VALA_TYPE_TAG_CLOUD_ITEM (vala_tag_cloud_item_get_type ())
#define VALA_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItem))
#define VALA_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))
#define VALA_IS_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_IS_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_TAG_CLOUD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))

typedef struct _ValaTagCloudItem ValaTagCloudItem;
typedef struct _ValaTagCloudItemClass ValaTagCloudItemClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ValaTagCloudItemPrivate ValaTagCloudItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _ValaTagCloud {
	GtkDrawingArea parent_instance;
	ValaTagCloudPrivate * priv;
};

struct _ValaTagCloudClass {
	GtkDrawingAreaClass parent_class;
};

struct _ValaTagCloudPrivate {
	GList* _items;
};

struct _ValaTagCloudItem {
	GObject parent_instance;
	ValaTagCloudItemPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _ValaTagCloudItemClass {
	GObjectClass parent_class;
};


static gpointer vala_tag_cloud_parent_class = NULL;

GType vala_tag_cloud_get_type (void) G_GNUC_CONST;
GType vala_tag_cloud_item_get_type (void) G_GNUC_CONST;
#define VALA_TAG_CLOUD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TAG_CLOUD, ValaTagCloudPrivate))
enum  {
	VALA_TAG_CLOUD_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
ValaTagCloud* vala_tag_cloud_new (void);
ValaTagCloud* vala_tag_cloud_construct (GType object_type);
void vala_tag_cloud_add_item (ValaTagCloud* self, ValaTagCloudItem* item);
static void vala_tag_cloud_on_tag_item_selected_changed (ValaTagCloud* self, GObject* sender, GParamSpec* pspec);
static void _vala_tag_cloud_on_tag_item_selected_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
ValaTagCloudItem* vala_tag_cloud_get_item_with_text (ValaTagCloud* self, const char* text);
const char* vala_tag_cloud_item_get_text (ValaTagCloudItem* self);
ValaTagCloudItem* vala_tag_cloud_hit_test (ValaTagCloud* self, double x, double y);
static gboolean vala_tag_cloud_real_button_release_event (GtkWidget* base, GdkEventButton* e);
gboolean vala_tag_cloud_item_get_selected (ValaTagCloudItem* self);
void vala_tag_cloud_item_set_selected (ValaTagCloudItem* self, gboolean value);
static gboolean vala_tag_cloud_real_motion_notify_event (GtkWidget* base, GdkEventMotion* e);
gboolean vala_tag_cloud_item_get_hilighted (ValaTagCloudItem* self);
void vala_tag_cloud_item_set_hilighted (ValaTagCloudItem* self, gboolean value);
static gboolean vala_tag_cloud_real_expose_event (GtkWidget* base, GdkEventExpose* e);
gint vala_tag_cloud_item_get_occourrences (ValaTagCloudItem* self);
static void vala_tag_cloud_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


ValaTagCloud* vala_tag_cloud_construct (GType object_type) {
	ValaTagCloud * self;
	self = (ValaTagCloud*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((GDK_BUTTON_MOTION_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK));
	return self;
}


ValaTagCloud* vala_tag_cloud_new (void) {
	return vala_tag_cloud_construct (VALA_TYPE_TAG_CLOUD);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_tag_cloud_on_tag_item_selected_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vala_tag_cloud_on_tag_item_selected_changed (self, _sender, pspec);
}


void vala_tag_cloud_add_item (ValaTagCloud* self, ValaTagCloudItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	self->priv->_items = g_list_append (self->priv->_items, _g_object_ref0 (item));
	g_signal_connect_object ((GObject*) item, "notify::selected", (GCallback) _vala_tag_cloud_on_tag_item_selected_changed_g_object_notify, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


ValaTagCloudItem* vala_tag_cloud_get_item_with_text (ValaTagCloud* self, const char* text) {
	ValaTagCloudItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* item;
			item = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			{
				if (_vala_strcmp0 (vala_tag_cloud_item_get_text (item), text) == 0) {
					result = item;
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	return result;
}


static void vala_tag_cloud_on_tag_item_selected_changed (ValaTagCloud* self, GObject* sender, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_signal_emit_by_name (self, "selected-items-changed");
}


ValaTagCloudItem* vala_tag_cloud_hit_test (ValaTagCloud* self, double x, double y) {
	ValaTagCloudItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* item;
			item = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			{
				gboolean _tmp0_ = FALSE;
				if (item->x <= x) {
					_tmp0_ = x <= (item->x + item->width);
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					gboolean _tmp1_ = FALSE;
					if (item->y <= y) {
						_tmp1_ = y <= (item->y + item->height);
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						result = item;
						return result;
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean vala_tag_cloud_real_button_release_event (GtkWidget* base, GdkEventButton* e) {
	ValaTagCloud * self;
	gboolean result = FALSE;
	ValaTagCloudItem* i;
	self = (ValaTagCloud*) base;
	i = vala_tag_cloud_hit_test (self, (*e).x, (*e).y);
	if (i != NULL) {
		vala_tag_cloud_item_set_selected (i, !vala_tag_cloud_item_get_selected (i));
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	result = FALSE;
	_g_object_unref0 (i);
	return result;
}


static gboolean vala_tag_cloud_real_motion_notify_event (GtkWidget* base, GdkEventMotion* e) {
	ValaTagCloud * self;
	gboolean result = FALSE;
	self = (ValaTagCloud*) base;
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* item;
			item = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			{
				ValaTagCloudItem* _tmp0_;
				gboolean _tmp1_;
				gboolean hitted;
				hitted = (_tmp1_ = (_tmp0_ = vala_tag_cloud_hit_test (self, (*e).x, (*e).y)) == item, _g_object_unref0 (_tmp0_), _tmp1_);
				if (vala_tag_cloud_item_get_hilighted (item) != hitted) {
					vala_tag_cloud_item_set_hilighted (item, hitted);
					gtk_widget_queue_draw_area ((GtkWidget*) self, item->x, item->y, item->width, item->height);
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_tag_cloud_real_expose_event (GtkWidget* base, GdkEventExpose* e) {
	ValaTagCloud * self;
	gboolean result = FALSE;
	cairo_t* c;
	gint w = 0;
	gint h = 0;
	cairo_text_extents_t te = {0};
	GtkStyle* style;
	char* font_name;
	double x;
	double y;
	double max_size;
	double min_size;
	gint min_occ;
	gint max_occ;
	double multiplier;
	double last_height;
	self = (ValaTagCloud*) base;
	c = gdk_cairo_create ((GdkDrawable*) (*e).window);
	gdk_drawable_get_size ((GdkDrawable*) (*e).window, &w, &h);
	cairo_set_source_rgb (c, (double) 1, (double) 1, (double) 1);
	cairo_rectangle (c, (double) 0, (double) 0, (double) w, (double) h);
	cairo_fill (c);
	style = _g_object_ref0 (gtk_widget_get_style ((GtkWidget*) self));
	font_name = g_strdup (pango_font_description_get_family (style->font_desc));
	cairo_select_font_face (c, font_name, CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	x = (double) 4;
	y = (double) 4;
	max_size = 24.0;
	min_size = 12.0;
	min_occ = 1;
	max_occ = 8;
	multiplier = (max_size - min_size) / (max_occ - min_occ);
	last_height = (double) 0;
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* item;
			item = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			{
				double size;
				double radius;
				size = min_size + ((max_occ - (max_occ - (vala_tag_cloud_item_get_occourrences (item) - min_occ))) * multiplier);
				cairo_set_font_size (c, size);
				cairo_text_extents (c, vala_tag_cloud_item_get_text (item), &te);
				if ((x + te.width) >= w) {
					x = (double) 4;
					y = y + (last_height + 8);
				}
				item->x = (gint) round (x);
				item->y = (gint) round (y);
				item->width = ((gint) round (te.width)) + 4;
				item->height = (gint) round (te.height - te.y_bearing);
				if (vala_tag_cloud_item_get_hilighted (item)) {
					GdkColor _tmp0_;
					gdk_cairo_set_source_color (c, (_tmp0_ = style->bg[GTK_STATE_PRELIGHT], &_tmp0_));
				} else {
					if (vala_tag_cloud_item_get_selected (item)) {
						GdkColor _tmp1_;
						gdk_cairo_set_source_color (c, (_tmp1_ = style->bg[GTK_STATE_SELECTED], &_tmp1_));
					} else {
						GdkColor _tmp2_;
						gdk_cairo_set_source_color (c, (_tmp2_ = style->bg[GTK_STATE_NORMAL], &_tmp2_));
					}
				}
				cairo_set_line_width (c, (double) 2);
				cairo_set_line_cap (c, CAIRO_LINE_CAP_ROUND);
				cairo_set_line_join (c, CAIRO_LINE_JOIN_ROUND);
				radius = (double) 5;
				cairo_move_to (c, item->x + radius, y);
				cairo_arc (c, (item->x + item->width) - radius, item->y + radius, radius, G_PI * 1.5, G_PI * 2);
				cairo_arc (c, (item->x + item->width) - radius, (item->y + item->height) - radius, radius, (double) 0, G_PI * 0.5);
				cairo_arc (c, item->x + radius, (item->y + item->height) - radius, radius, G_PI * 0.5, G_PI);
				cairo_arc (c, item->x + radius, item->y + radius, radius, G_PI, G_PI * 1.5);
				if (vala_tag_cloud_item_get_selected (item)) {
					cairo_fill (c);
				} else {
					cairo_stroke (c);
				}
				if (vala_tag_cloud_item_get_hilighted (item)) {
					GdkColor _tmp3_;
					gdk_cairo_set_source_color (c, (_tmp3_ = gtk_widget_get_style ((GtkWidget*) self)->fg[GTK_STATE_ACTIVE], &_tmp3_));
				} else {
					GdkColor _tmp4_;
					gdk_cairo_set_source_color (c, (_tmp4_ = gtk_widget_get_style ((GtkWidget*) self)->fg[GTK_STATE_NORMAL], &_tmp4_));
				}
				cairo_move_to (c, (item->x - (te.x_bearing / 2)) + 2, (item->y + te.height) - (te.y_bearing / 2));
				cairo_show_text (c, vala_tag_cloud_item_get_text (item));
				x = x + (te.width + 8);
				last_height = (double) item->height;
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	_g_free0 (font_name);
	_g_object_unref0 (style);
	_cairo_destroy0 (c);
	return result;
}


static void vala_tag_cloud_class_init (ValaTagCloudClass * klass) {
	vala_tag_cloud_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTagCloudPrivate));
	GTK_WIDGET_CLASS (klass)->button_release_event = vala_tag_cloud_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = vala_tag_cloud_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->expose_event = vala_tag_cloud_real_expose_event;
	G_OBJECT_CLASS (klass)->finalize = vala_tag_cloud_finalize;
	g_signal_new ("selected_items_changed", VALA_TYPE_TAG_CLOUD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vala_tag_cloud_instance_init (ValaTagCloud * self) {
	self->priv = VALA_TAG_CLOUD_GET_PRIVATE (self);
	self->priv->_items = NULL;
}


static void vala_tag_cloud_finalize (GObject* obj) {
	ValaTagCloud * self;
	self = VALA_TAG_CLOUD (obj);
	__g_list_free_g_object_unref0 (self->priv->_items);
	G_OBJECT_CLASS (vala_tag_cloud_parent_class)->finalize (obj);
}


GType vala_tag_cloud_get_type (void) {
	static volatile gsize vala_tag_cloud_type_id__volatile = 0;
	if (g_once_init_enter (&vala_tag_cloud_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTagCloudClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_tag_cloud_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTagCloud), 0, (GInstanceInitFunc) vala_tag_cloud_instance_init, NULL };
		GType vala_tag_cloud_type_id;
		vala_tag_cloud_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "ValaTagCloud", &g_define_type_info, 0);
		g_once_init_leave (&vala_tag_cloud_type_id__volatile, vala_tag_cloud_type_id);
	}
	return vala_tag_cloud_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




