#ifndef __CURVEFRAME_H__
#define __CURVEFRAME_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

/**
 * CurveFrameStyle:
 * @CURVE_LINEAR: the curve is drawn with lines ;
 * @CURVE_BAR: the curve is drawn with bars ;
 * @CURVE_GAUSS: the curve is convoluted with gaussians (not
 * implemented yet).
 *
 * Possible styles for the curve rendering, see curveFrameSet_style().
 */
typedef enum
{
  CURVE_LINEAR,
  CURVE_BAR,
  CURVE_GAUSS
} CurveFrameStyle;

/**
 * CURVE_FRAME_TYPE:
 *
 * Return the associated #GType to the #CurveFrame objects.
 *
 * Since: 3.6
 */
#define CURVE_FRAME_TYPE          (curveFrame_get_type())
/**
 * CURVE_FRAME:
 * @obj: the widget to cast.
 *
 * Cast the given object to a #CurveFrame object.
 *
 * Since: 3.6
 */
#define CURVE_FRAME(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj), CURVE_FRAME_TYPE, CurveFrame))
/**
 * CURVE_FRAME_CLASS:
 * @obj: the class to cast.
 *
 * Cast the given class to a #CurveFrame object.
 *
 * Since: 3.6
 */
#define CURVE_FRAME_CLASS(obj)    (G_TYPE_CHECK_CLASS_CAST((obj), CURVE_FRAME, CurveFrameClass))
/**
 * IS_CURVE_FRAME:
 * @obj: the object to test.
 *
 * Return if the given object is a valid #CurveFrame object.
 *
 * Since: 3.6
 */
#define IS_CURVE_FRAME(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj), CURVE_FRAME_TYPE))
/**
 * IS_CURVE_FRAME_CLASS:
 * @obj: the class to test.
 *
 * Return if the given class is a valid #CurveFrameClass class.
 *
 * Since: 3.6
 */
#define IS_CURVE_FRAME_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((obj), CURVE_FRAME_TYPE))
/**
 * CURVE_FRAME_GET_CLASS:
 * @obj: the widget to get the class of.
 *
 * Get the class of the given object.
 *
 * Since: 3.6
 */
#define CURVE_FRAME_GET_CLASS     (G_TYPE_INSTANCE_GET_CLASS((obj), CURVE_FRAME_TYPE, CurveFrameClass))

typedef struct _CurveFrame            CurveFrame;
typedef struct _CurveFrameClass       CurveFrameClass;

/**
 * curveFrame_get_type:
 *
 * Internal routine to get #CURVE_FRAME_TYPE value.
 *
 * Since: 3.6
 */
GType curveFrame_get_type(void);
GtkWidget *curveFrameNew(float distMin, float distMax);
void curveFrameRedraw(CurveFrame *curve);

gboolean curveFrameSet_span(CurveFrame *curve, float span[2]);
void curveFrameGet_span(CurveFrame *curve, float span[2]);

gboolean curveFrameHas_data(CurveFrame *curve);
void curveFrameSet_data(CurveFrame *curve, float step, float min, float max);
void curveFrameAdd_data(CurveFrame *curve, const gchar *eleName, const gchar *lkName,
			const guint *data, guint nSteps, float init, float step);
gboolean curveFrameSet_style(CurveFrame *curve, CurveFrameStyle style);
gboolean curveFrameSet_filter(CurveFrame *curve, const gchar* filter);
gboolean curveFrameSet_highlightRange(CurveFrame *curve, float range[2]);
gboolean curveFrameGet_highlightRange(CurveFrame *curve, float range[2]);
void curveFrameSet_nNodes(CurveFrame *curve, const gchar *ele, guint n);
float curveFrameGet_integralInRange(CurveFrame *curve, gchar **label);
float curveFrameGet_meanInRange(CurveFrame *curve, gchar **label);

G_END_DECLS

#endif
