/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef GEOMETRY_H
#define GEOMETRY_H

#include <visu_data.h>
#include <coreTools/toolShade.h>

typedef struct VisuPathes_ VisuPathes;

VisuPathes* visu_pathes_new(float translation[3]);
void        visu_pathes_free(VisuPathes *pathes);
void        visu_pathes_empty(VisuPathes *pathes);

gboolean    visu_pathes_addFromDiff(VisuPathes *pathes, VisuData *data);
gboolean    visu_pathes_addNodeStep(VisuPathes *pathes, guint time, guint nodeId,
                                    float xyz[3], float dxyz[3], float energy);
void        visu_pathes_pinPositions(VisuPathes *pathes, VisuData *data);

void        visu_pathes_draw(VisuPathes *pathes);
void        visu_pathes_constrainInBox(VisuPathes *pathes, VisuData *data);
gboolean    visu_pathes_exportToXML(const VisuPathes *pathes,
                                    const gchar *filename, GError **error);
gboolean    visu_pathes_parseFromXML(const gchar* filename, VisuPathes *pathes,
                                     GError **error);

void        visu_pathes_setTranslation(VisuPathes *pathes, float cartCoord[3]);
gboolean    visu_pathes_setShade(VisuPathes *pathes, Shade* shade);
Shade*      visu_pathes_getShade(VisuPathes *pathes);
guint       visu_pathes_getLength(VisuPathes *pathes);


gboolean visu_geodiff_new(VisuData *dataRef, VisuData *data, gboolean reorder);
gboolean visu_geodiff_setActive(gboolean value);
void     visu_geodiff_rebuildList(VisuData *dataObj);
gboolean visu_geodiff_hasData(VisuData *data);
gchar*   visu_geodiff_export(VisuData *data);
void     visu_geodiff_getPeriodicDistance(float diff[3], VisuData *data,
                                          VisuNode *node1, VisuNode *node2);

void geometryInit();

#endif
