/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_STIPPLECOMBOBOXWIDGET_H
#define GTK_STIPPLECOMBOBOXWIDGET_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

G_BEGIN_DECLS
/**
 * VALUE_IO_TYPE
 *
 * Returns: the associated #GType to the ValueIO objects.
 *
 * Since: 3.5
 */
#define VALUE_IO_TYPE         (valueIO_get_type ())
/**
 * VALUE_IO:
 *
 * Cast the given object to a #ValueIO object.
 *
 * Since: 3.5
 */
#define VALUE_IO(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALUE_IO_TYPE, ValueIO))
/**
 * VALUE_IO_CLASS
 *
 * Cast the given class to a #ValueIOClass object.
 *
 * Since: 3.5
 */
#define VALUE_IO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALUE_IO_TYPE, ValueIOClass))
/**
 * IS_VALUE_IO
 *
 * Returns: if the given object is a valid #ValueIO object.
 *
 * Since: 3.5
 */
#define IS_VALUE_IO(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALUE_IO_TYPE))
/**
 * IS_VALUE_IO_CLASS
 *
 * Returns: if the given class is a valid #ValueIOClass class.
 *
 * Since: 3.5
 */
#define IS_VALUE_IO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALUE_IO_TYPE))

/**
 * ValueIO:
 *
 * Private structure to store informations of a #ValueIO object.
 *
 * Since: 3.5
 */
typedef struct _ValueIO ValueIO;
/* typedef struct ValueIOPrivate_struct ValueIOPrivate; */
/**
 * ValueIOClass
 *
 * Private structure to store informations of a #ValueIOClass object.
 *
 * Since: 3.5
 */
typedef struct _ValueIOClass ValueIOClass;

/**
 * valueIO_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #ValueIO objects.
 *
 * Since: 3.5
 */
GType valueIO_get_type(void);
/**
 * valueIO_new :
 *
 * A #ValueIO widget is like a #GtkComboBox widget, but it is already filled
 * with predefined line patterns (call stipple). Using this widget is
 * a convienient way to share stipples between all part of V_Sim and
 * to give a consistent look of all stipple selection.
 *
 * Returns: a newly created #ValueIO widget.
 *
 * Since: 3.5
 */
GtkWidget* valueIONew(GtkWindow *parent, const gchar*tipsOpen,
		      const gchar*tipsSave, const gchar*tipsSaveAs);

typedef gboolean (*ValueIOCallback)(const gchar *filename, GError **error);

void valueIOConnect_open(ValueIO *valueio, ValueIOCallback open);
void valueIOConnect_save(ValueIO *valueio, ValueIOCallback save);
void valueIOSet_openSensitive(ValueIO *valueio, gboolean status);
void valueIOSet_saveSensitive(ValueIO *valueio, gboolean status);
gboolean valueIOSet_filename(ValueIO *valueio, const gchar *filename);


gchar* valueIOGet_saveFilename(GtkWindow *parent);



G_END_DECLS

#endif
