AC_DEFUN([AC_CHECK_ABINIT],
[
  AC_MSG_CHECKING([for Abinit support])
  AC_ARG_WITH([abinit],
            [AS_HELP_STRING([--with-abinit=ARG],[ABINIT directory (with include and lib subdirs)])],
            [AB_PATH=$withval], 
            [AB_PATH="no"])

  AC_ARG_WITH([abinit_include],
            [AS_HELP_STRING([--with-abinit-include=ARG],[specific ABINIT include directory])],
            [AB_PATH_INC=$withval], 
            [AB_PATH_INC=""])

  AC_ARG_WITH([abinit_libdir],
            [AS_HELP_STRING([--with-abinit-libdir=ARG],[specific ABINIT library directory])],
            [AB_PATH_LIBDIR=$withval], 
            [AB_PATH_LIBDIR=""])
  AC_MSG_RESULT($AB_PATH)

  if test "z$AB_PATH" != "zno" ; then
    AS_IF([test "z$AB_PATH" = "zyes"],[AB_PATH="/opt/etsf/abinit"])
    AS_IF([test "z$AB_PATH_LIBDIR" = "z"],[AB_PATH_LIBDIR="$AB_PATH/lib"])
    AS_IF([test "z$AB_PATH_INC" = "z"],[AB_PATH_INC="$AB_PATH/include"])
  
    dnl First thing is to test the header file.
    CPPFLAGS_SVG=$CPPFLAGS
    CPPFLAGS="$CPPFLAGS -I$AB_PATH_INC"
    AC_CHECK_HEADER([ab6_invars.h],
                    [ac_abinit_parser_header="yes"],
                    [ac_abinit_parser_header="no"])
    AC_CHECK_HEADER([ab6_symmetry.h],
                    [ac_abinit_symmetry_header="yes"],
                    [ac_abinit_symmetry_header="no"])
    CPPFLAGS=$CPPFLAGS_SVG
    
    dnl Try to find the missing dependencies in libabinis.a.
    AC_FC_WRAPPERS()
    AC_FC_FUNC([wrtout])
    AC_FC_FUNC([leave_new])
    AC_FC_FUNC([timab])
  
    AC_LANG_PUSH([C])
  
    LIBS_SVG=$LIBS
    LIBS="$LIBS -L$AB_PATH_LIBDIR -labinis $FCLIBS"
    CFLAGS_SVG=$CFLAGS
    CFLAGS="$CFLAGS -Wno-error"

    dnl Look for the parser in libabinis.
    AC_MSG_CHECKING([for parser capabilities in libabinis.a from $AB_PATH_LIBDIR])
    AC_LINK_IFELSE([
void $wrtout()
{
}
void $leave_new()
{
}
void $timab()
{
}
int main(int argc, const char **argv)
{
  ab6_invars_new_from_file();
  return 0;
}
], [ac_abinit_parser_ok=yes], [ac_abinit_parser_ok=no])
    AC_MSG_RESULT([$ac_abinit_parser_ok])

    dnl Look for the symmetries in libabinis.
    AC_MSG_CHECKING([for symmetry capabilities in libabinis.a from $AB_PATH_LIBDIR])
    AC_LINK_IFELSE([
void $wrtout()
{
}
void $leave_new()
{
}
void $timab()
{
}
int main(int argc, const char **argv)
{
  ab6_symmetry_new();
  return 0;
}
], [ac_abinit_symmetry_ok=yes], [ac_abinit_symmetry_ok=no])
    AC_MSG_RESULT([$ac_abinit_symmetry_ok])

    LIBS=$LIBS_SVG
    CFLAGS=$CFLAGS_SVG
  
    AC_LANG_POP([C])

    AS_IF([test "z$ac_abinit_parser_header" = "zyes" -a "z$ac_abinit_parser_ok" = "zyes"],
          [ac_abinit_parser=yes],
          [ac_abinit_parser=no])
    AS_IF([test "z$ac_abinit_symmetry_header" = "zyes" -a "z$ac_abinit_symmetry_ok" = "zyes"],
          [ac_abinit_symmetry=yes],
          [ac_abinit_symmetry=no])
    AS_IF([test "z$ac_abinit_symmetry" = "zyes" -o "z$ac_abinit_parser" = "zyes"],
          [ac_abinit="yes";
           AB_LIBS="-L$AB_PATH_LIBDIR -labinis";
           AB_CPPFLAGS="-I$AB_PATH_INC"],
          [ac_abinit=no])
  else
    ac_abinit=no
  fi
])
