/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "gtk_about.h"

#include "interface.h"
#include "support.h"

#include "visu_object.h"
#include "visu_tools.h"
#include "visu_basic.h"
#include "visu_plugins.h"

#define V_SIM_LICENCE_FILE  _("licence.en.txt")
/* Translate if there is a authors file in another language. */
#define V_SIM_AUTHORS_FILE  _("authors")
/* Translate if there is a readme file in another language. */
#define V_SIM_README_FILE   _("readme")

enum
  {
    GTK_PLUGINS_COLUMN_ICON,
    GTK_PLUGINS_COLUMN_NAME,
    GTK_PLUGINS_COLUMN_DESCRIPTION,
    GTK_PLUGINS_COLUMN_AUTHORS,
    N_GTK_PLUGINS_COLUMNS
  };
static void buildPluginsTab();
/* static gboolean onUrlClicked(GtkTextTag *tag, GObject *object, */
/* 			     GdkEvent *event, GtkTextIter *iter, */
/* 			     gpointer user_data); */
/* static gboolean onMouseMotion(GtkWidget *wd, GdkEventMotion *event, */
/* 			      gpointer user_data); */


/* create the window. */
void gtkAboutBuild_window(GtkMain *main)
{
  GtkWidget *wd;
  gchar *buffer, *utf8Buffer, *start, *end;
  GtkTextBuffer *text;
  GtkTextIter startIter, endIter;
  GtkTextTag *monoTag, *boldTag, *linkTag;
  gsize taille;
  GError *err;
  gchar *chemin;

  DBG_fprintf(stderr, "Gtk About : creating the dialog window.\n");
  main->aboutDialog = create_infoDialog();
  gtk_widget_set_name(main->aboutDialog, "message");

  wd = lookup_widget(main->aboutDialog, "labelInfoVersion");
  gtk_label_set_text(GTK_LABEL(wd), V_SIM_VERSION);
  wd = lookup_widget(main->aboutDialog, "labelInfoReleaseDate");
  gtk_label_set_text(GTK_LABEL(wd), V_SIM_RELEASE_DATE);
  wd = lookup_widget(main->aboutDialog, "labelInfoWebSite");
/* #if GTK_MINOR_VERSION > 9 */
/*   gtk_widget_destroy(wd); */
/*   wd = lookup_widget(main->aboutDialog, "table4"); */
/*   gtk_table_attach(GTK_TABLE(wd), gtk_link_button_new(V_SIM_WEB_SITE), */
/* 		   1, 2, 2, 3, GTK_SHRINK, GTK_SHRINK, 5, 0); */
/*   gtk_widget_show_all(wd); */
/* #else */
  gtk_label_set_markup(GTK_LABEL(wd), "<span font_desc=\"monospace\"><u>"
		       V_SIM_WEB_SITE"</u></span>");
/* #endif */

  wd = lookup_widget(main->aboutDialog, "notebookAbout");
  gtk_widget_set_name(wd, "message_notebook");

  /* Create the interior of the tabs. */
  chemin = g_build_filename(V_SIM_LEGAL_DIR, V_SIM_LICENCE_FILE, NULL);
  buffer = (gchar*)0;
  err = (GError*)0;
  if (!g_file_get_contents(chemin, &buffer, &taille, &err))
    g_warning("Can't find the licence file, normally"
	      " it should be in '%s'.\n", chemin);
  else
    {
      utf8Buffer = g_convert(buffer, taille, "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
      g_free(buffer);

      wd = lookup_widget(main->aboutDialog, "textviewLicence");
      text = gtk_text_view_get_buffer(GTK_TEXT_VIEW(wd));
      gtk_text_buffer_get_start_iter(text, &startIter);
      monoTag = gtk_text_buffer_create_tag(text, "typewriter", "family", "monospace", NULL);
      gtk_text_buffer_insert_with_tags(text, &startIter, utf8Buffer,
				       -1, monoTag, NULL);
	  
      g_free(utf8Buffer);
    }
  g_free(chemin);

  chemin = g_build_filename(V_SIM_LEGAL_DIR, V_SIM_README_FILE, NULL);
  buffer = (gchar*)0;
  err = (GError*)0;
  if (!g_file_get_contents(chemin, &buffer, &taille, &err))
    g_warning("Can't find the readme file, normally it"
	      " should be in '%s'.\n", chemin);
  else
    {
      utf8Buffer = g_convert(buffer, taille, "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
      g_free(buffer);

      wd = lookup_widget(main->aboutDialog, "textviewReadme");
      gtk_widget_add_events(wd, GDK_POINTER_MOTION_MASK);
      text = gtk_text_view_get_buffer(GTK_TEXT_VIEW(wd));
      gtk_text_buffer_set_text (text, utf8Buffer, -1);

      start = strstr(utf8Buffer, "http://");
      end = g_utf8_strchr(start, -1, ' ');
      if (*g_utf8_prev_char(end) == '.')
	end = g_utf8_prev_char(end);
      linkTag = gtk_text_buffer_create_tag(text, "link",
					   "underline", PANGO_UNDERLINE_SINGLE, NULL);
/* 					   "foreground", "blue", NULL); */
/*       g_signal_connect(G_OBJECT(linkTag), "event", */
/* 		       G_CALLBACK(onUrlClicked), NULL); */
/*       g_signal_connect(G_OBJECT(wd), "motion-notify-event", */
/* 		       G_CALLBACK(onMouseMotion), (gpointer)linkTag); */
      gtk_text_buffer_get_iter_at_offset
	(text, &startIter,(gint)g_utf8_pointer_to_offset(utf8Buffer, start));
      gtk_text_buffer_get_iter_at_offset
	(text, &endIter, (gint)g_utf8_pointer_to_offset(utf8Buffer, end));
      gtk_text_buffer_apply_tag(text, linkTag, &startIter, &endIter);
	  
      g_free(utf8Buffer);
    }
  g_free(chemin);

  chemin = g_build_filename(V_SIM_LEGAL_DIR, V_SIM_AUTHORS_FILE, NULL);
  buffer = (gchar*)0;
  err = (GError*)0;
  if (!g_file_get_contents(chemin, &buffer, &taille, &err))
    g_warning("Can't find the authors file, normally"
	      " it should be in '%s'.\n", chemin);
  else
    {
      utf8Buffer = g_convert(buffer, taille, "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
      g_free(buffer);

      wd = lookup_widget(main->aboutDialog, "textviewAuthors");
      text = gtk_text_view_get_buffer(GTK_TEXT_VIEW(wd));
      gtk_text_buffer_get_start_iter(text, &startIter);
      monoTag = gtk_text_buffer_create_tag(text, "typewriter",
					   "family", "monospace", NULL);
      gtk_text_buffer_insert_with_tags(text, &startIter, utf8Buffer,
				       -1, monoTag, NULL);
      boldTag = gtk_text_buffer_create_tag(text, "bold",
					   "weight", PANGO_WEIGHT_BOLD, NULL);
      end = utf8Buffer;
      do
	{
	  start = g_utf8_strchr(end, -1, '*');
	  if (start)
	    {
	      end = g_utf8_strchr(g_utf8_next_char(start), -1, '*');
	      if (end)
		{
		  gtk_text_buffer_get_iter_at_offset
		    (text, &startIter,(gint)g_utf8_pointer_to_offset(utf8Buffer, start));
		  gtk_text_buffer_get_iter_at_offset
		    (text, &endIter, (gint)g_utf8_pointer_to_offset(utf8Buffer, end));
		  gtk_text_buffer_apply_tag(text, boldTag, &startIter, &endIter);
		  end = g_utf8_next_char(end);
		}
	    }
	} while (start);
	  
      g_free(utf8Buffer);
    }
  g_free(chemin);

  buildPluginsTab(main);
}

/* static gboolean onMouseMotion(GtkWidget *wd, GdkEventMotion *event, */
/* 			      gpointer user_data) */
/* { */
/*   gint x, y; */
/*   GtkTextIter iter; */
/*   static GdkCursor *cur = NULL; */

/*   gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(wd), GTK_TEXT_WINDOW_WIDGET, */
/* 					event->x, event->y, &x, &y); */
/*   gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(wd), &iter, x, y); */

/*   if (gtk_text_iter_has_tag(&iter, GTK_TEXT_TAG(user_data))) */
/*     { */
/*       if (!cur) */
/* 	cur = gdk_cursor_new(GDK_HAND1); */
/*       gdk_window_set_cursor(event->window, cur); */
/*       g_object_set(G_OBJECT(user_data), "underline", PANGO_UNDERLINE_SINGLE, NULL); */
/*     } */
/*   else */
/*     { */
/*       gdk_window_set_cursor(event->window, NULL); */
/*       g_object_set(G_OBJECT(user_data), "underline", PANGO_UNDERLINE_NONE, NULL); */
/*     } */
/*   return FALSE; */
/* } */

/* static gboolean onUrlClicked(GtkTextTag *tag _U_, GObject *object _U_, */
/* 			     GdkEvent *event, GtkTextIter *iter _U_, */
/* 			     gpointer user_data _U_) */
/* { */
/*   if (event->type == GDK_BUTTON_RELEASE) */
/*     { */
/*       if (((GdkEventButton*)event)->button != 1) */
/* 	return FALSE; */
/*       DBG_fprintf(stderr, "Gtk About: clicked on URL.\n"); */
/*     } */
/*   return FALSE; */
/* } */

static void buildPluginsTab(GtkMain *main)
{
  GtkListStore *liststore;
  GtkTreeIter iter;
  GList *pnt;
  GtkWidget *tree, *wd;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GdkPixbuf *pixbuf;

  liststore = gtk_list_store_new(N_GTK_PLUGINS_COLUMNS,
				 GDK_TYPE_PIXBUF,
				 G_TYPE_STRING,
				 G_TYPE_STRING,
				 G_TYPE_STRING);
  gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(liststore),
				       GTK_PLUGINS_COLUMN_NAME, GTK_SORT_ASCENDING);

  pnt = visuPluginsGet_listLoaded();
  while(pnt)
    {
      if (((VisuPlugin*)pnt->data)->getIcon)
	pixbuf = gdk_pixbuf_new_from_file_at_size(((VisuPlugin*)pnt->data)->getIcon(),
						  32, 32, (GError**)0);
      else
	pixbuf = (GdkPixbuf*)0;
      gtk_list_store_append(liststore, &iter);
      gtk_list_store_set(liststore, &iter,
			 GTK_PLUGINS_COLUMN_ICON, pixbuf,
			 GTK_PLUGINS_COLUMN_NAME, ((VisuPlugin*)pnt->data)->name,
			 GTK_PLUGINS_COLUMN_DESCRIPTION, ((VisuPlugin*)pnt->data)->getDescription(),
			 GTK_PLUGINS_COLUMN_AUTHORS, ((VisuPlugin*)pnt->data)->getAuthors(),
			 -1);
      pnt = g_list_next(pnt);
    }

  /* Build the treeview. */
  tree= gtk_tree_view_new_with_model(GTK_TREE_MODEL(liststore));
  
  gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(tree)), GTK_SELECTION_NONE);
  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), TRUE);

  renderer = gtk_cell_renderer_pixbuf_new();
  column = gtk_tree_view_column_new_with_attributes("", renderer,
						    "pixbuf", GTK_PLUGINS_COLUMN_ICON,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_text_new();
  g_object_set(renderer, "weight", 600, "weight-set", TRUE, NULL);
  column = gtk_tree_view_column_new_with_attributes(_("Name"), renderer,
						    "text", GTK_PLUGINS_COLUMN_NAME,
						    NULL);
  gtk_tree_view_column_set_alignment(column, 0.5);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_text_new();
  g_object_set(renderer, "xalign", 0.5, NULL);
  column = gtk_tree_view_column_new_with_attributes(_("Description"), renderer,
						    "markup", GTK_PLUGINS_COLUMN_DESCRIPTION,
						    NULL);
  gtk_tree_view_column_set_expand(column, TRUE);
  gtk_tree_view_column_set_alignment(column, 0.5);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes(_("Authors"), renderer,
						    "text", GTK_PLUGINS_COLUMN_AUTHORS,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  gtk_widget_show(tree);

  wd = lookup_widget(main->aboutDialog, "scrolledwindowPlugins");
  gtk_container_add(GTK_CONTAINER(wd), tree);
}
