/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Xlib.h>
#include <GL/glx.h>

#include <glib.h>

#include "visu_openGL.h"
#include <visu_tools.h>

static Display *dpy = (Display*)0;

struct DumpImage_struct
{
  GLXContext context;
  GLXPixmap glxPixmap;
  Pixmap pixmap;
  guint width, height;
};

int handler(Display *dpy _U_, XErrorEvent *error _U_)
{
  return 0;
}

XVisualInfo* visuOpenGLGet_visualInfo(Display *dpy, int screenId)
{
  XVisualInfo *vinfo;
  int list[] = {
    GLX_RGBA,
    GLX_RED_SIZE, 1, GLX_GREEN_SIZE, 1, GLX_BLUE_SIZE, 1,
    GLX_DEPTH_SIZE, 1,
    GLX_DOUBLEBUFFER,
    GLX_STEREO,
    None
  };

  if ( (vinfo = glXChooseVisual(dpy, screenId, list)) == NULL )
    {
      list[10] = None; 
      if ( (vinfo = glXChooseVisual(dpy, screenId, list)) == NULL )
	{
	  g_error("Cannot find a visual.\n"
		  "Have you enough right access on the X server?");
	}
      DBG_fprintf(stderr, " | not a stereo buffer.\n");
    }
  else
    DBG_fprintf(stderr, " | stereo buffer.\n");

  return vinfo;
}

DumpImage* visuOpenGLNew_pixmapContext(guint width, guint height)
{
  DumpImage *image;
  int screenId, res;
  XVisualInfo *visualInfo;

  DBG_fprintf(stderr, "Visu GLX : creating a off-screen buffer (%dx%d).\n", width, height);
  image = g_malloc(sizeof(DumpImage));
  image->pixmap = (Pixmap)0;
  image->glxPixmap = (GLXPixmap)0;
  image->context = (GLXContext)0;

  if (!dpy)
    dpy = XOpenDisplay(0);

  if (!dpy)
    {
      g_warning("Cannot connect to the X server.");
      g_free(image);
      return (DumpImage*)0;
    }
  DBG_fprintf(stderr, "Visu GLX : display opened.\n");

  screenId = DefaultScreen(dpy);
  visualInfo = visuOpenGLGet_visualInfo(dpy, screenId);

  image->width = width;
  image->height = height;
  image->pixmap = XCreatePixmap(dpy, RootWindow(dpy, screenId),
				width, height, visualInfo->depth);
  if (!image->pixmap)
    {
      g_warning("Cannot allocate a XPixmap for the indirect rendering.");
      g_free(image);
      XFree(visualInfo);
      return (DumpImage*)0;
    }

  image->glxPixmap = glXCreateGLXPixmap(dpy, visualInfo, image->pixmap);
  if (!image->glxPixmap)
    {
      g_warning("Cannot allocate a GLXPixmap for the indirect rendering.");
      XFreePixmap(dpy, image->pixmap);
      g_free(image);
      XFree(visualInfo);
      return (DumpImage*)0;
    }

  image->context = glXCreateContext(dpy, visualInfo, 0, GL_FALSE);
  if (!image->context)
    {
      g_warning("Cannot create indirect GLX context.");
      XFreePixmap(dpy, image->pixmap);
      glXDestroyGLXPixmap(dpy, image->glxPixmap);
      g_free(image);
      XFree(visualInfo);
      return (DumpImage*)0;
    }

  XSetErrorHandler(handler);
  res = glXMakeCurrent(dpy, image->glxPixmap, image->context);
  if (!res)
    {
      g_warning("Cannot make current the pixmap context.");
      XFreePixmap(dpy, image->pixmap);
      glXDestroyGLXPixmap(dpy, image->glxPixmap);
      g_free(image);
      XFree(visualInfo);
      return (DumpImage*)0;
    }
  XSetErrorHandler(NULL);

  XFree(visualInfo);
  return image;
}

void visuOpenGLFree_pixmapContext(DumpImage *dumpData)
{
  g_return_if_fail(dumpData);

  if (dpy)
    {
      if (dumpData->pixmap)
	XFreePixmap(dpy, dumpData->pixmap);
      if (dumpData->glxPixmap)
	glXDestroyGLXPixmap(dpy, dumpData->glxPixmap);
      if (dumpData->context)
	glXDestroyContext(dpy, dumpData->context);
      /* We do NOT close the display since it is shared
	 by all the application and thus dpy structure
	 is unique and will be closed by the main program when quiting. */
      /*   XCloseDisplay(dumpData->dpy); */
    }
  g_free(dumpData);
}

GLuint visuOpenGLinit_fontList()
{
  static XFontStruct *fontInfo = (XFontStruct*)0;
  unsigned int first, last; 
  char name[] =  
    "-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1"; 
  GLuint BASE;
  static Display *dpy = (Display*)0;
        
  DBG_fprintf(stderr, "Visu GLX : initialise fonts.\n");
  if (!fontInfo)
    {
      if (!dpy)
	dpy = XOpenDisplay(0);
      if ((fontInfo = XLoadQueryFont(dpy, name)) == NULL) 
	{
	  g_warning("Specified font not available in gl_font_init\n" 
		    "Trying to use fixed font\n"); 
	  if ((fontInfo = XLoadQueryFont(dpy, "fixed")) == NULL) 
	    {
	      g_error("Fixed font not available.\n"); 
	    }
	}
    }

  first = fontInfo->min_char_or_byte2; 
  last = fontInfo->max_char_or_byte2; 
 
  /* this creates display lists 1 to 256 (not checked) */ 
  if ( (BASE = glGenLists(last+1)) == 0 )
    return 0;
    
  glXUseXFont(fontInfo->fid, first, last-first+1, BASE+first); 
  return BASE; 
}
