AC_DEFUN([AC_CHECK_ABINIT],
[
  AC_ARG_WITH([abinit],
            [AS_HELP_STRING([--with-abinit=ARG],[ABINIT directory (with include and lib subdirs)])],
            [AB_PATH=$withval], 
            [AB_PATH=""])

  AC_ARG_WITH([abinit_include],
            [AS_HELP_STRING([--with-abinit-include=ARG],[specific ABINIT include directory])],
            [AB_PATH_INC=$withval], 
            [AB_PATH_INC=""])

  AC_ARG_WITH([abinit_libdir],
            [AS_HELP_STRING([--with-abinit-libdir=ARG],[specific ABINIT library directory])],
            [AB_PATH_LIBDIR=$withval], 
            [AB_PATH_LIBDIR=""])

  AS_IF([test "z$AB_PATH" = "z"],[AB_PATH="/opt/etsf/abinit"])
  AS_IF([test "z$AB_PATH_LIBDIR" = "z"],[AB_PATH_LIBDIR="$AB_PATH/lib"])
  AS_IF([test "z$AB_PATH_INC" = "z"],[AB_PATH_INC="$AB_PATH/include"])

  dnl First thing is to test the header file.
  CPPFLAGS_SVG=$CFLAGS
  CPPFLAGS="$CPPFLAGS -I$AB_PATH_INC"
  AC_CHECK_HEADER([ab_dtset_c.h],
                  [ac_abinit_header="yes"],
                  [ac_abinit_header="no"])
  CPPFLAGS=$CPPFLAGS_SVG
  
  dnl Try to find the missing dependencies in libabinis.a.
  AC_FC_WRAPPERS()
  AC_FC_FUNC([wrtout])
  AC_FC_FUNC([leave_new])
  AC_FC_FUNC([timab])

  AC_LANG_PUSH([C])

  AC_MSG_CHECKING([for libabinis.a in $AB_PATH_LIBDIR])
  LIBS_SVG=$LIBS
  LIBS="$LIBS -L$AB_PATH_LIBDIR -labinis $FCLIBS"
  AC_LINK_IFELSE([
void $wrtout()
{
}
void $leave_new()
{
}
void $timab()
{
}
int main(int argc, const char *argv[])
{
  ab_dtset_new();
  return 0;
}
], [ac_abinit_ok=yes], [ac_abinit_ok=no])
  AC_MSG_RESULT([$ac_abinit_ok])
  LIBS=$LIBS_SVG

  AC_LANG_POP([C])

  AS_IF([test "z$ac_abinit_header" = "zyes" -a "z$ac_abinit_ok" = "zyes"],
        [AB_LIBS="-L$AB_PATH_LIBDIR -labinis";
         AB_CPPFLAGS="-I$AB_PATH_INC";
         ac_abinit=yes],
        [ac_abinit=no])
])
