/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISUTOOLS_H
#define VISUTOOLS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#ifndef DEBUG
  #define DEBUG 0
#endif
#ifndef INSTALL_DIR
  #define INSTALL_DIR "/usr/local"
#endif
/**
 * DBG_fprintf
 *
 * For developpers : use this macro instead of fprintf.
 */
#define DBG_fprintf if(DEBUG) (void)fprintf

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


#define V_SIM_NAME             PACKAGE
#define V_SIM_VERSION          VERSION
#define V_SIM_WEB_SITE         "<u>http://www-drfmc.cea.fr/sp2m/L_Sim/V_Sim</u>"

#define V_SIM_LICENCE_FILE  _("licence.en.txt")
#define V_SIM_AUTHORS_FILE  _("authors")
#define V_SIM_README_FILE   _("readme")


gchar *v_sim_data_dir;
gchar *v_sim_conf_dir;
gchar *v_sim_legal_dir;
gchar *v_sim_pixmaps_dir;
gchar *v_sim_local_conf_dir;
gchar *v_sim_plugins_dir;
gchar *v_sim_locale_dir;

/**
 * MAX_LINE_LENGTH
 *
 * This is the maximum number of characters read on a
 * line of an input file.
 */
#define MAX_LINE_LENGTH 256

/**
 * voidDataFunc:
 * @data: a pointer to some user defined object.
 *
 * These methods are used when no specific argument is required except
 * a user-defined object and when void is the return type.
 */
typedef void (*voidDataFunc)(gpointer data);



/**
 * setFileSystemInUTF8:
 * @val: a boolean to specify if the file system is in UTF-8 or not.
 *
 * A call to this method stores a flag to identify the file system
 * as in UTF-8 or not. If system is not in UTF-8, the programmer needs
 * to convert from locale to UTF-8 to use file names in the GTK interface
 * and have to do some transformations from UTF-8 to locale when strings
 * are retrieve from the GTK interface.
 */
void setFileSystemInUTF8(int val);
/**
 * getFileSystemInUTF8:
 *
 * This method can retrieve the flag for the coding of the file system.
 * This flag must have been initialized by a call to %setFileSystemInUTF8
 * before using this method. If system is not in UTF-8, the programmer needs
 * to convert from locale to UTF-8 to use file names in the GTK interface
 * and have to do some transformations from UTF-8 to locale when strings
 * are retrieve from the GTK interface.
 *
 * Returns: 1 if the flag of the file system is on UTF-8, 0 otherwise.
 */
int getFileSystemInUTF8();
/**
 * getStringInUTF8:
 * @str: a string to convert.
 *
 * Convert the given string from the locale of the file system to UTF-8.
 *
 * Returns: a newly allocated string, must be freed by a call to g_free after use.
 */
gchar* getStringInUTF8(const gchar* str);

/* All signal emit by visu are handled by this ogbject. */
GObject *visu;


/**
 * freeUserDataFunc:
 * @data: some allocated data.
 *
 * This prototype is used when a method must be given to free some data.
 */
typedef void (*freeUserDataFunc)(gpointer data);

/**
 * freeString:
 * @ele: the char* to be freed.
 * 
 * It deallocates @ele. @ele must be a char* and have
 * been allocated with malloc or realloc. This function
 * can be used as a freed method for a GHashTable of which
 * values are char*.
 */
void freeString(gpointer ele);
/**
 * freeFloat:
 * @ele: the float* to be freed.
 * 
 * It deallocates @ele. @ele must be a float* and have
 * been allocated with malloc or realloc. This function
 * can be used as a freed method for a GHashTable of which
 * values are float*.
 */
void freeFloat(gpointer ele);
/**
 * freeInt:
 * @ele: the int* to be freed.
 * 
 * It deallocates @ele. @ele must be a int* and have
 * been allocated with malloc or realloc. This function
 * can be used as a freed method for a GHashTable of which
 * values are int*.
 */
void freeInt(gpointer ele);
/**
 * freeGPointer:
 * @ele: the gpointer to be freed.
 * 
 * It deallocates @ele. @ele must have been allocated with
 * malloc or realloc. This function can be used as a freed
 * method for a GHashTable of which values are of complex structure.
 */
void freeGPointer(gpointer ele);

/**
 * getValidPath:
 * @pathList: a pointer to a GList with all the possible path,
 * @fileName: a string,
 * @accessMode: a value from R_OK, W_OK and X_OK as described in unistd.h.
 *
 * @pathList contains a list of directories (first is most prefered)
 * and fileName is the file name which one likes have informations on. This routine
 * look for the first directory where fileName can be writen or read (depending
 * on accessMode parameter). The pointer to the GList indicates at the end the
 * first valid entry in the GList.
 *
 * Returns: the first valid complete path (from @pathList plus @fileName)
 * if one can be found depnding on @accessMode or NULL if none found.
 */
gchar* getValidPath(GList **pathList, char *fileName, int accessMode);

/**
 * visuWaitFunction:
 *
 * This function must be called in a blocking loop to update
 * different things like the gtk for example.
 */
void visuWaitFunction();

/**
 * allocationProblems:
 *
 * Print a message.
 */
void allocationProblems();

/**
 * fModulo:
 * @a: a float ;
 * @b: an int.
 * 
 * This function is just like a%b except it works with a float @a argument. 
 * @a can be negative, but the return value of the function is always positive.
 *
 * Returns: the new float value after the modulo.
*/
float fModulo(float a, int b);

/**
 * normalize_path:
 * @path: a string, NULL terminated.
 *
 * This function normalizes the path, i.e. it removes all . and .. It should
 * work also on Windows. It must take an absolute path as argument, if not it is converted
 * assuming the current working directory.
 *
 * Returns: a newly created string.
 */
gchar* normalize_path(gchar* path);

G_END_DECLS

#endif
