/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "visu_object.h"

#include <glib.h>

struct _VisuObjectPrivate
{
  int toto;
};

static void
visu_instance_init (GTypeInstance   *instance,
                         gpointer         g_class)
{
        VisuObject *self = (VisuObject *)instance;
        self->privateDt = g_new (VisuObjectPrivate, 1);
}

static void
visu_class_init (gpointer g_class,
                      gpointer g_class_data)
{
/*         GObjectClass *gobject_class = G_OBJECT_CLASS (g_class); */
        VisuObjectClass *klass = VISU_CLASS (g_class);
	GType paramPointer[1] = {G_TYPE_POINTER};
	GType paramObject[1] = {G_TYPE_OBJECT};

        klass->colorNewAvailable_signal_id = 
	  g_signal_newv ("colorNewAvailable",
			 G_TYPE_FROM_CLASS (g_class),
			 G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
			 NULL /* class closure */,
			 NULL /* accumulator */,
			 NULL /* accu_data */,
			 g_cclosure_marshal_VOID__POINTER,
			 G_TYPE_NONE /* return_type */,
			 1     /* n_params */,
			 paramPointer /* pointer to the added color */);

        klass->dataNew_signal_id = 
	  g_signal_newv("dataNew",
			G_TYPE_FROM_CLASS(g_class),
			G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
			NULL,
			NULL, 
			NULL,              
			g_cclosure_marshal_VOID__OBJECT,
			G_TYPE_NONE, 1, paramObject);
        klass->dataLoaded_signal_id = 
	  g_signal_newv("dataLoaded",
			G_TYPE_FROM_CLASS(g_class),
			G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
			NULL,
			NULL, 
			NULL,              
			g_cclosure_marshal_VOID__OBJECT,
			G_TYPE_NONE, 1, paramObject);
        klass->dataReadyForRendering_signal_id = 
                g_signal_newv ("dataReadyForRendering",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL /* class closure */,
                               NULL /* accumulator */,
                               NULL /* accu_data */,
                               g_cclosure_marshal_VOID__OBJECT,
                               G_TYPE_NONE /* return_type */,
                               1     /* n_params */,
                               paramObject  /* param_types */);
        klass->renderingChanged_signal_id = 
                g_signal_newv ("renderingChanged",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL /* class closure */,
                               NULL /* accumulator */,
                               NULL /* accu_data */,
                               g_cclosure_marshal_VOID__VOID,
                               G_TYPE_NONE /* return_type */,
                               0     /* n_params */,
                               NULL  /* param_types */);
        klass->resourcesLoaded_signal_id = 
                g_signal_newv ("resourcesLoaded",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL /* class closure */,
                               NULL /* accumulator */,
                               NULL /* accu_data */,
                               g_cclosure_marshal_VOID__VOID,
                               G_TYPE_NONE /* return_type */,
                               0     /* n_params */,
                               NULL  /* param_types */);
        klass->OpenGLAskForReDraw_signal_id = 
                g_signal_newv ("OpenGLAskForReDraw",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL /* class closure */,
                               NULL /* accumulator */,
                               NULL /* accu_data */,
                               g_cclosure_marshal_VOID__VOID,
                               G_TYPE_NONE /* return_type */,
                               0     /* n_params */,
                               NULL  /* param_types */);
        klass->OpenGLForceReDraw_signal_id = 
                g_signal_newv ("OpenGLForceReDraw",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL /* class closure */,
                               NULL /* accumulator */,
                               NULL /* accu_data */,
                               g_cclosure_marshal_VOID__VOID,
                               G_TYPE_NONE /* return_type */,
                               0     /* n_params */,
                               NULL  /* param_types */);

        klass->SpinAxes_signal_id = 
                g_signal_newv ("SpinAxes",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL , NULL, NULL,
                               g_cclosure_marshal_VOID__OBJECT,
                               G_TYPE_NONE /* return_type */,
                               1     /* n_params */,
                               paramObject  /* param_types */);
}

GType visu_get_type (void)
{
  static GType type = 0;
  if(type == 0) {
    static GTypeInfo info;

    info.class_size = sizeof (VisuObjectClass);
    info.base_init = NULL;
    info.base_finalize = NULL;
    info.class_init = visu_class_init;
    info.class_finalize = NULL;
    info.class_data = NULL;
    info.instance_size = sizeof(VisuObject);
    info.n_preallocs = 0;
    info.instance_init = visu_instance_init;
    info.value_table = NULL;
    
    type = g_type_register_static (G_TYPE_OBJECT,
				   "VisuObjectType",
				   &info, 0);
  }
  return type;
}

/* Other object for GTK signal */
struct _VisuGtkObjectPrivate
{
  int toto;
};

static void
visu_gtk_instance_init (GTypeInstance   *instance,
                         gpointer         g_class)
{
        VisuGtkObject *self = (VisuGtkObject *)instance;
        self->privateDt = g_new (VisuGtkObjectPrivate, 1);
}

static void
visu_gtk_class_init (gpointer g_class,
                      gpointer g_class_data)
{
/*         GObjectClass *gobject_class = G_OBJECT_CLASS (g_class); */
        VisuGtkObjectClass *klass = VISU_GTK_CLASS (g_class);
	GType paramFloat[1] = {G_TYPE_FLOAT};

        klass->spinBoundsChanged_signal_id = 
                g_signal_newv ("spinBoundsChanged",
                               G_TYPE_FROM_CLASS (g_class),
                               G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                               NULL , NULL, NULL, g_cclosure_marshal_VOID__FLOAT,
                               G_TYPE_NONE, 1, paramFloat);
}

GType visu_gtk_get_type (void)
{
  static GType typeGtk = 0;
  if(typeGtk == 0) {
    static GTypeInfo info;

    info.class_size = sizeof (VisuGtkObjectClass);
    info.base_init = NULL;
    info.base_finalize = NULL;
    info.class_init = visu_gtk_class_init;
    info.class_finalize = NULL;
    info.class_data = NULL;
    info.instance_size = sizeof(VisuGtkObject);
    info.n_preallocs = 0;
    info.instance_init = visu_gtk_instance_init;
    info.value_table = NULL;
    
    typeGtk = g_type_register_static (G_TYPE_OBJECT,
				      "VisuGtkObjectType",
				      &info, 0);
  }
  return typeGtk;
}

