/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_NODES_H
#define VISU_NODES_H

#include <glib.h>

/**
 * node_struct:
 * @x: a floating point value that positions the node on x axis ;
 * @y: a floating point value that positions the node on y axis ;
 * @z: a floating point value that positions the node on z axis ;
 * @translation: an array of three floating point values that translates the
 *               node to its drawn position from (x, y, z) ;
 * @number: an integer that corresponds to its position in the entry file, it references
 *          also the node itself in the array 'fromNumberToVisuNode' of the #VisuData
 *          that contains the node ;
 * @posElement: an integer that is the position of the #VisuElement of the node
 *              in the array 'fromIntToVisuElement' of the #VisuData object that
 *              contains the node ;
 * @posNode: an integer that is the position of the node itself in the array
 *           'nodes' of the #VisuData object that contains the node ;
 * @rendered: a boolean to store if the node is drwn or not.
 *
 * Structure to store primary data of a node.
 */
struct node_struct
{
  /* coordinates of the node. */
  double x, y, z;

  /* translation */
  float translation[3];

  /* Number of this element in the input file. */
  int number;
  /* Position in the #VisuData structure. */
  int posElement, posNode;

  /* A boolean to specify if if this node is rendered or not. */
  int rendered;
};
/**
 * VisuNode:
 *
 * Short way to address #node_struct objects.
 */
typedef struct node_struct VisuNode;


/**
 * visuNodeSet_newValues:
 * @node: an allocated #VisuNode object ;
 * @x: its x coordinate ;
 * @y: its y coordinate ;
 * @z: its z coordinate ;
 * @number: its position in the input file (or anything else that can uniqualy
 *          identify this new #VisuNode) ;
 * @rendered: 1 if draw, 0 otherwise ;
 * @posEle: an int corresponding the number of the #VisuElement
 *          it is associated with ;
 * @posNod: an int corresponding to the position of the node in the
 *          node table of the #VisuData in which it is allocated ;
 * 
 * This method doesn't allocate the node it works on. It should be already
 * allocated. Moreover it should not have been already initialised
 * since nothing from the node is freed before giving the values.
 */
void visuNodeSet_newValues(VisuNode *node, double x, double y, double z, 
			   int number, int rendered, int posEle, int posNod);
/**
 * visuNodeSet_visibility:
 * @node: a #VisuNode object ;
 * @visibility: a boolean.
 *
 * This method is used to turn on or off the drawing of the specified node.
 *
 * Returns: true if the calling method should recreate the node list with
 * a call to the visuData_createAllNodes() method.
 */
int visuNodeSet_visibility(VisuNode* node, gboolean visibility);
/**
 * visuNodeGet_visibility:
 * @node: a #VisuNode object.
 *
 * This method is used get the status of the drawing state of a node.
 *
 * Returns: true if the node is rendered, false otherwise.
 */
gboolean visuNodeGet_visibility(VisuNode* node);

#endif
