/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "visu_dump.h"

#include "visu_tools.h"
#include "dumpModules/externalDumpModules.h"

#include <stdio.h>
#include <unistd.h>

gboolean dumpListIsInitialized;
void initDumpList();

GList* getAllDumpModules()
{
  if (!dumpListIsInitialized)
    initDumpList();
  return allDumpModuleList;
}
int getNbDumpModules()
{
  if (!dumpListIsInitialized)
    initDumpList();
  return nbDumpModules;
}

void initDumpList()
{
  int i;
  DumpType *dump;

  for (i = 0; listInitDumpModuleFunc[i]; i++)
    {
      dump = listInitDumpModuleFunc[i]();
      if (dump)
	{
	  nbDumpModules ++;
	  allDumpModuleList = g_list_append(allDumpModuleList, dump);
	}
    }
  dumpListIsInitialized = TRUE;
  DBG_fprintf(stderr, "Visu Dump :  %d valid dump module(s) found.\n", nbDumpModules);
}

int initDumpModule()
{
  allDumpModuleList = (GList*)0;
  nbDumpModules = 0;
  dumpListIsInitialized = FALSE;
  return 1;
}

void abortDump(GObject *obj, gpointer data)
{
  /* TODO : mettre un stop dans le fichier en cours. */
  DBG_fprintf(stderr, "Visu dump : abortion requested.\n");
  *((int*)data) = 1;
}
