/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_ACTIONINTERFACE_H
#define VISU_ACTIONINTERFACE_H

#include <glib.h>

#include <visu_data.h>

/**
 * BUTTON_TYPE_PRESS:
 *
 * Value that can be put into field buttonType of structure #SimplifiedEvents_struct.
 */
#define BUTTON_TYPE_PRESS   1
/**
 * BUTTON_TYPE_RELEASE:
 *
 * Value that can be put into field buttonType of structure #SimplifiedEvents_struct.
 */
#define BUTTON_TYPE_RELEASE 2

/**
 * SimplifiedEvents_struct:
 * @x: the position x (on parent) for the event ;
 * @y: the position y (on parent) for the event ;
 * @button: the number of the button, 0 if not a button event ;
 * @buttonType: #BUTTON_TYPE_PRESS or #BUTTON_TYPE_RELEASE ;
 * @shiftMod: TRUE if Shift key is pressed during the event ;
 * @controlMod: TRUE if Control key is pressed during the event ;
 * @motion: TRUE if the event is a motion ;
 * @letter: The value of the letter if the event is a key stroke.
 *
 * This structure is a common interface for events (inspired from X). We don't
 * use the one introduced by GDK because we don't want this dependency be a
 * limitation.
 */
struct SimplifiedEvents_struct
{
  int x, y;
  unsigned int button;
  int buttonType;
  int shiftMod, controlMod;
  int motion;
  char letter;
};
/**
 * SimplifiedEvents:
 *
 * A short way to address SimplifiedEvents_struct objects.
 */
typedef struct SimplifiedEvents_struct SimplifiedEvents;


/**
 * ActionFunc:
 * @event: the event that triggered the action ;
 * @data: the #VisuData object on which the action occured.
 *
 * An interface to methods that can be called whenever an action occurs.
 *
 * Returns: TRUE if action should be stopped after this call.
 */
typedef gboolean (*ActionFunc)(SimplifiedEvents *event, VisuData *data);

/**
 * CallbackFunctions_struct:
 * @action: the method to be called ;
 * @stop: the method to be called if the action should be stopped ;
 * @data: the #VisuData object on which the action occured.
 *
 * This structure gather some routines and objects that are relevent when
 * an event occures and some actions need to be launched.
 */
struct CallbackFunctions_struct
{
  ActionFunc action;
  GDestroyNotify stop;
  VisuData *data;
};
/**
 * CallbackFunctions:
 *
 * A short way to address CallbackFunctions_struct objects.
 */
typedef struct CallbackFunctions_struct CallbackFunctions;


#endif
