#ifndef NQ_BASIC_H
#define NQ_BASIC_H

#include <glib.h>
#include <netcdf.h>

GQuark NQ_ERROR;
enum
  {
    NQ_ERROR_FILE_OPEN,     /* Error when opening. */
    NQ_ERROR_FILE_UNKNOWN,  /* Wrong or unknown headers. */
    NQ_ERROR_FILE_HEADER,   /* Wrong header value. */
    NQ_ERROR_FILE_FORMAT    /* Wrong syntax (missing variables... */
  };

/**
 * nqOpen_netcdfFile:
 * @filename: a path to the file to load ;
 * @netcdfId: a pointer to store the id returned by netcdf ;
 * @error: a pointer to store possible error.
 *
 * Open a file supposed to be a NETCDF file following the Nanoquanta
 * specifications. The @netcdfId argument will store the integer id used by
 * netcdf in future calls if the given @filename has a right header.
 * 
 * Returns: TRUE if the file is a valid NETCDF file, if FALSE, no file
 *          is opened.
 */
gboolean nqOpen_netcdfFile(const char* filename, int *netcdfId, GError **error);

/**
 * nqClose_netcdfFile:
 * @netcdfId: a netcdf identifier ;
 *
 * Close the file that is currently opened by Netcdf.
 *
 * Returns: TRUE if the file is succesfully closed.
 */
gboolean nqClose_netcdfFile(int netcdfId);

gboolean nqGetDim(int netcdfId, GError **error, char *name, int *varId, size_t *value);
gboolean nqCheckVar(int netcdfId, GError **error, char *name, int *varId,
			              nc_type ncType, int nbDims, size_t *nbEleDims);


#endif
