/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef PANELBROWSER_H
#define PANELBROWSER_H

#include <glib.h>
#include <gtk/gtk.h>

/**
 * BROWSER_PREVIOUS:
 *
 * Value that give the direction when the selector is moved around file list.
 * See panelBrowserGet_nextSelected().
 */
#define BROWSER_PREVIOUS 0
/**
 * BROWSER_NEXT:
 *
 * Value that give the direction when the selector is moved around file list.
 * See panelBrowserGet_nextSelected().
 */
#define BROWSER_NEXT     1

/**
 * panelBrowserGet_nextSelected:
 * @path: a pointer to returned the path of the newly selected file ;
 * @iterSelected: a pointer to store the newly selected iter ;
 * @direction: BROWSER_NEXT or BROWSER_PREVIOUS.
 *
 * Change the selected file in the browser given the direction.
 */
gboolean panelBrowserGet_nextSelected(GtkTreePath **path, GtkTreeIter *iterSelected, int direction);
/**
 * panelBrowserGet_currentSelected:
 * @path: a pointer to returned the path of the currently selected file ;
 * @iterSelected: a pointer to store the currently selected iter.
 *
 * Get iter and path of the currently sleected file.
 */
gboolean panelBrowserGet_currentSelected(GtkTreePath **path, GtkTreeIter *iterSelected);

#endif

