/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef RENDERINGMODE_H
#define RENDERINGMODE_H

#include <glib.h>

/**
 * RenderingModeId:
 * @Wireframe: objects are rendered with lines only ;
 * @Flat: objects are rendered with polygons whose colours are uniform
 *        on each polygon ;
 * @Smooth: objects are rendered with polygons whose colours
 *          are shaded to be smooth all along the object.
 * @nb_renderingModes: number of rendering mode.
 *
 * Implemented mode to draw objects.
 */
typedef enum
  {
    Wireframe,
    Flat,
    Smooth,
/*     SmoothAndEdge, */
    nb_renderingModes
  } RenderingModeId;

/**
 * openGLInit_renderingMode:
 *
 * This method is used by opengl.c to initialise this module (declare config file
 * options...). It should not be called elsewhere.
 */
void openGLInit_renderingMode();

/**
 * openGLSet_globalRenderingMode:
 * @value: an integer to represent the method of rendering.
 *
 * This function change the value of the parameter renderingOption.
 * It controls how V_Sim renders objects, in wireframe for example.
 *
 * Returns: TRUE if the signal OpenGLAskForReDraw should be emitted.
 */
gboolean openGLSet_globalRenderingMode(RenderingModeId value);
/**
 * openGLGet_globalRenderingOption:
 *
 * This function retrieve the value of the parameter renderingOption.
 *
 * Returns: the identifier of the current rendering option.
 */
RenderingModeId openGLGet_globalRenderingOption();
/**
 * openGLGet_allRenderingModesI18n:
 *
 * This function retrieve al the names (translated) of available rendering modes.
 *
 * Returns: an array of string, NULL terminated that is private (not to be freed).
 */
const char** openGLGet_allRenderingModesI18n();
/**
 * openGLApply_renderingMode:
 * @mode: an integer.
 *
 * Change the rendering mode of current OpenGL context.
 */
void openGLApply_renderingMode(RenderingModeId mode);



#endif
