/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef DATANODE_H
#define DATANODE_H

/* This module is a wrapper around node properties from
   VisuData. It adds some capabilities, such as a translatable
   name, a way to go from data to strings and reverse, callbacks when
   the properties is changed... */

#include <visu_nodes.h>
#include <visu_data.h>

G_BEGIN_DECLS

/**
 * DATA_NODE_TYPE:
 *
 * return the type of #DataNode.
 */
#define DATA_NODE_TYPE	     (data_node_get_type ())
/**
 * DATA_NODE:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #DataNode type.
 */
#define DATA_NODE(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, DATA_NODE_TYPE, DataNode))
/**
 * DATA_NODE_CLASS:
 * @klass: a #GClassObject to cast.
 *
 * Cast the given @klass into #DataNodeClass.
 */
#define DATA_NODE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, DATA_NODE_TYPE, DataNodeClass))
/**
 * IS_DATA_NODE_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #DataNode object.
 */
#define IS_DATA_NODE_TYPE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, DATA_NODE_TYPE))
/**
 * IS_DATA_NODE_CLASS:
 * @klass: a #GClassObject to test.
 *
 * Test if the given @klass is of the type of #DataNodeClass class.
 */
#define IS_DATA_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, DATA_NODE_TYPE))
/**
 * DATA_NODE_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define DATA_NODE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, DATA_NODE_TYPE, DataNodeClass))

/**
 * DataNodeClass:
 *
 * A short way to identify #DataNodeClass_struct structure.
 */
typedef struct DataNodeClass_struct DataNodeClass;

/**
 * DataNode:
 *
 * A short wy to address #DataNode_struct objects.
 */
typedef struct DataNode_struct DataNode;



/* Maybe removed if the stuff is converted to GObject. */
/**
 * DataNodeCallbackMethod:
 * @dataObj: the #VisuData object on which the callback is done ;
 * @node: the #VisuNode on which the callback is done ;
 * @data: a user defined pointer.
 *
 * Interface for callbacks methods that are called whenever a data is changed
 * on a node.
 *
 * WARNING: it may be removed later.
 */
typedef void (*DataNodeCallbackMethod)(VisuData *dataObj, VisuNode *node, gpointer data);

/**
 * data_node_get_type:
 *
 * This method returns the type of #DataNode, use DATA_NODE_TYPE instead.
 *
 * Returns : the type of #DataNode.
 */
GType data_node_get_type(void);



/**
 * nodeDataNew:
 * @name: a string used to store the data as a node property ;
 * @type: the type of data stored (array or not).
 *
 * This method creates a new #DataNode and registers it. A #DataNode is
 * characterised by a string used as a key to store it as a node property
 * (see visuDataAdd_nodeProperty()). The stored data can be arrays or not.
 * Notice that @name is not copied.
 *
 * Returns: a newly created #DataNode.
 */
DataNode* nodeDataNew(const gchar *name, GType type);

/**
 * nodeDataGet_list:
 *
 * All registered #DataNode are stored in an intern list. This method is
 * used to retrieve it.
 *
 * Returns: a #GList of all registereed #DataNode (this list is owned by V_Sim).
 */
GList* nodeDataGet_list();

/**
 * nodeDataSet_label:
 * @data: a #DataNode ;
 * @label: an UTF8 string (may be translated).
 *
 * A #DataNode can have a label, if not its name is used.
 * Notice that @label is not copied.
 */
void nodeDataSet_label(DataNode *data, const gchar *label);
/**
 * nodeDataGet_label:
 * @data: a #DataNode ;
 *
 * A #DataNode can have a label, if not its name is used.
 *
 * Returns: the label of the node (in UTF8), this string is owned by V_Sim.
 */
const gchar* nodeDataGet_label(DataNode *data);

/**
 * nodeDataSet_used:
 * @data: a #DataNode ;
 * @dataObj: a #VisuData object ;
 * @nb: a positive or null integer.
 *
 * A #DataNode stores data for each node of a given #VisuData. The number of data stored for
 * each node is set with this method. When some part wants to set a new node property
 * and wants to make it public, this method can be called. It also can be called when
 * the node property is removed (using a null @nb argument).
 * If @nb is changed for a positive value, the "propertyUsed"
 * signal is emitted with @dataObj as argument, instead if the value is changed
 * for null, the "propertyUnused" signal is triggered also with @dataObj as argument.
 */
void nodeDataSet_used(DataNode *data, VisuData *dataObj, gint nb);
/**
 * nodeDataGet_used:
 * @data: a #DataNode ;
 * @dataObj: a #VisuData object.
 *
 * Access method to know if the given @dataObj has a public node property of the type
 * @data.
 *
 * Returns: TRUE if @dataObj has a node property of the given type.
 */
gboolean nodeDataGet_used(DataNode *data, VisuData *dataObj);

/**
 * nodeDataSet_valueAsString:
 * @data: a #DataNode ;
 * @dataObj: a #VisuData object ;
 * @node: a #VisuNode ;
 * @labelIn: a formatted string ;
 * @labelOut: a pointer to store a string ;
 *
 * If the string is correctly formatted (that means it has the same format as
 * the string returned by nodeDataGet_valueAsString()) the stored values are modified.
 * The resulting string is created and put into @labelOut. If the input string @labelIn
 * is unparsable, @labelOut will contain current values. Notice that this method is
 * callable only if the @data is editable (see nodeDataGet_editable()).
 *
 * Returns: TRUE if the string was correctly parsed.
 */
gboolean nodeDataSet_valueAsString(DataNode *data, VisuData *dataObj,
				   VisuNode *node, gchar *labelIn, gchar **labelOut);
/**
 * nodeDataGet_valueAsString:
 * @data: a #DataNode ;
 * @dataObj: a #VisuData object ;
 * @node: a #VisuNode.
 *
 * For the given node, the values stored are printed into a string.
 *
 * Returns: a newly created string.
 */
gchar* nodeDataGet_valueAsString(DataNode *data, VisuData *dataObj, VisuNode *node);

/**
 * nodeDataSet_callback:
 * @data: a #DataNode ;
 * @callback: a #DataNodeCallbackMethod method ;
 * @user_data: a pointer to a location used to store some user data.
 *
 * When nodeDataSet_valueAsString(), values may be modified. If true, the given
 * callback method is called with @user_data as argument.
 */
void nodeDataSet_callback(DataNode *data, DataNodeCallbackMethod callback,
			  gpointer user_data);
/**
 * nodeDataGet_editable:
 * @data: a #DataNode.
 *
 * If some callback method has been given with nodeDataSet_callback(), then
 * the values are considered editable.
 *
 * Returns: TRUE if values are editable.
 */
gboolean nodeDataGet_editable(DataNode *data);

G_END_DECLS

#endif
