/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef SCALE_H
#define SCALE_H

#include <visu_extension.h>
#include <visu_tools.h>
#include <visu_data.h>

/**
 * MASK_XYZ_X:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the x direction.
 */
#define MASK_XYZ_X (1 << 0)
/**
 * MASK_XYZ_Y:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the y direction.
 */
#define MASK_XYZ_Y (1 << 1)
/**
 * MASK_XYZ_Z:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the z direction.
 */
#define MASK_XYZ_Z (1 << 2)
/**
 * MASK_XYZ_ALL:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value is a
 * shortcut for #MASK_XYZ_X | #MASK_XYZ_Y | #MASK_XYZ_Z.
 */
#define MASK_XYZ_ALL (7)

/**
 * initExtensionScale
 *
 * It initialises all variables of the OpenGL extension.
 * It creates all resources and parameters introduced by
 * this extension.
 * This method should be added in the #listInitExtensionFunc to
 * be called automatically by the initOpenGLExtensions() at V_Sim
 * startup.
 *
 * Returns: a pointer to the OpenGLExtension it created or
 * NULL otherwise.
 */
OpenGLExtension* initExtensionScale();

/**
 * scaleSet_RGBValues:
 * @rgb: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_RGB_R, #MASK_RGB_G, #MASK_RGB_B, #MASK_RGB_ALL or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the private parameter scale_color.
 *
 * Returns: 1 if scaleDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
int scaleSet_RGBValues(float rgb[3], int mask);
/**
 * scaleSet_lineWidth:
 * @width: value of the desired width.
 *
 * Method used to change the value of the parameter scale_line_width.
 *
 * Returns: 1 if scaleDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
int scaleSet_lineWidth(float width);
/**
 * scaleSet_areOn:
 * @value: 1 if a scale must be drawn, 0 otherwise.
 *
 * Method used to change the value of the parameter Scale_are_on.
 *
 * Returns: 1 if scaleDraw() should be called. In all cases, 'OpenGLAskForReDraw'
 *          signal should then be emitted.
 */
int scaleSet_isOn(int value);

/**
 * axesGet_redValue:
 *
 * Returns: the red value of the current scale color.
 */
float scaleGet_redValue();
/**
 * scaleGet_greenValue:
 *
 * Returns: the green value of the current scale color.
 */
float scaleGet_greenValue();
/**
 * scaleGet_blueValue:
 *
 * Returns: the blue value of the current scale color.
 */
float scaleGet_blueValue();
/**
 * scaleGet_areOn:
 *
 * Returns: 1 if scale are drawn, 0 otherwise.
 */
int scaleGet_isOn();
/**
 * scaleGet_LineWidth:
 *
 * Returns: the value of current width.
 */
float scaleGet_LineWidth();
/**
 * scaleDraw:
 * @dataObj: the #VisuData object to build axes for.
 *
 * This method create a compile list that draw a box for the given @data.
 */
void scaleDraw(VisuData *dataObj);

/* Routine that changes the origin of the scale. */
int scaleSet_origin(float xyz[3], int mask);
/* Routine that changes the direction of the scale. */
int scaleSet_orientation(float xyz[3], int mask);
/* Routine to change the length of tha scale. */
int scaleSet_length(float lg);
/* Routine to change the text drwn near the scale. */
void scaleSet_legend(const gchar *legend);

float scaleGet_length();

void scaleGet_origin(float xyz[3]); 

void scaleGet_orientation(float xyz[3]);

/****************/
/* Private part */
/****************/

OpenGLExtension* extensionScale;


#endif
