/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef TOOLCOLOR_H
#define TOOLCOLOR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * MASK_RGB_R:
 *
 * This value can be used to create a mask for methods that
 * require one for reading rgb color array. This value actually
 * correspond to red.
 */
#define MASK_RGB_R (1 << 0)
/**
 * MASK_RGB_G:
 *
 * This value can be used to create a mask for methods that
 * require one for reading rgb color array. This value actually
 * correspond to green.
 */
#define MASK_RGB_G (1 << 1)
/**
 * MASK_RGB_B:
 *
 * This value can be used to create a mask for methods that
 * require one for reading rgb color array. This value actually
 * correspond to blue.
 */
#define MASK_RGB_B (1 << 2)
/**
 * MASK_RGB_ALL:
 *
 * This value can be used to create a mask for methods that
 * require one for reading rgb color array. This value is a
 * shortcut for #MASK_RGB_R | #MASK_RGB_G | #MASK_RGB_B.
 */
#define MASK_RGB_ALL (7)

/******************/
/* Storing colors */
/******************/
/**
 * Color:
 * @rgba: the coding of color in Red, Green, Blue, Alpha format,
 *        floating point numbers between 0 and 1 ;
 * @userData: a pointer to store some data (should be used with care).
 *
 * A structure to store colors.
 */
typedef struct Color_struct
{
  float rgba[4];
  gpointer userData;
} Color;
/**
 * initColorStorage:
 *
 * This method must be called once at the beginning of the program, if
 * you want to use the color storage system.
 */
void initColorStorage();
/**
 * colorNew_floatRGBA:
 * @rgba: four values between 0. and 1. that represent [Red, Green, Blue, Alpha].
 * 
 * Create a new color with initial values given as arguments.
 *
 * Returns: a new allocated %Color.
 */
Color* colorNew_floatRGBA(float rgba[4]);
/**
 * colorGet_byId:
 * @num: an integer (>0).
 *
 * This function retrieves the nth stored color. Number 0, is the last
 * added color.
 *
 * Returns: the corresponding color, or NULL if none has been found.
 */
Color* colorGet_byId(int num);
/**
 * colorGet_lastStored:
 *
 * This method is typiccally called after a client has catched
 * the colorNewAvailable signal.
 *
 * Returns: the last added color, NULL if no color exists.
 */
Color* colorGet_lastStored();
/**
 * colorGet_byColor:
 * @color: a pointer to a stored color.
 *
 * This function retrieves the number (begining at 0) of the specified color.
 *
 * Returns: the position of the specified color or -1 if not found.
 */
int colorGet_byColor(Color *color);
/**
 * colorGet_byValues:
 * @pos: an allocated int to store the position of the found color ;
 * @red: a value between 0. and 1. ;
 * @green: a value between 0. and 1. ;
 * @blue: a value between 0. and 1. ;
 * @alpha: a value between 0. and 1..
 *
 * This method is used to look for a specific color in the stored list. The argument @pos
 * is -1 if nothing is found or stores the position (beginning at 0) of the found color.
 *
 * Returns: the found color, or NULL if none exists.
 */
Color* colorGet_byValues(int *pos, float red, float green, float blue, float alpha);
/**
 * colorGet_storedColors:
 *
 * Use this method to get a pointeur to the list of stored colors.
 *
 * Returns: a GList pointer to the stored colors.
 */
GList* colorGet_storedColors();
/**
 * colorCopy_color:
 * @color: an allocated #Color object to receive values ;
 * @color_old: a #Color to read the values from.
 * 
 * This method copies all values from @color_old to @color.
 */
void colorCopy_color(Color *color, Color *color_old);
/**
 * colorAdd_color:
 * @color: a %Color.
 *
 * This method copies color informations from @color to the list of stored colors.
 *
 * Returns: 0 if everything is OK.
 */
Color* colorAdd_color(Color* color);
/**
 * colorAdd_floatRGBA:
 * @rgba: four values between 0. and 1. that represent [Red, Green, Blue, Alpha] ;
 * @position: an int pointer to store the position off the returned colour.
 *
 * This method adds a new color in the list of stored colors with the given values.
 * If it already exits it returns the pointer of that color.
 *
 * Returns: a pointer to the color.
 */
Color* colorAdd_floatRGBA(float rgba[4], int *position);
/**
 * colorAdd_intRGBA:
 * @rgba: four values between 0 and 255 that represent [Red, Green, Blue, Alpha].
 *
 * This method adds a new color in the list of stored colors with the given values.
 *
 * Returns: 0 if everything is OK.
 */
Color* colorAdd_intRGBA(int rgba[4]);


/**
 * color_HSVtoRGB:
 * @rgb: an allocated 3 elements array to receive the RGB values ;
 * @hsv: a 3 elements array to retrieve the HSV values from.
 *
 * This methods convert a HSV color to a RGB one.
 */
void color_HSVtoRGB(float* rgb, float* hsv);

/**
 * color_HSLtoRGB:
 * @rgb: an allocated 3 elements array to receive the RGB values ;
 * @hsl: a 3 elements array to retrieve the HSL values from.
 *
 * This methods convert a HSL color to a RGB one.
 */
void color_HSLtoRGB(float *rgb, float *hsl);


G_END_DECLS

#endif
