/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h> /* For the access markers R_OK, W_OK ... */

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "visu_tools.h"
#include "visu_data.h"
#include "visu_basic.h"
#include "visu_rendering.h"
#include "visu_object.h"
#include "visu_configFile.h"
#include "visu_pickMesure.h"
#include "opengl.h"
#include "renderingBackend/visu_windowInterface.h"
#include "gtk_main.h"
#include "gtk_observePick.h"
#include "gtk_pairs.h"
#include "gtk_about.h"
#include "gtk_save.h"
#include "extraGtkFunctions/gtk_dumpDialogWidget.h"
#include "extraGtkFunctions/gtk_toolPanelWidget.h"
#include "gtk_renderingWindowWidget.h"


GtkProgressBar *dumpBar;


void filterChanged(GtkEditable *entry, gpointer data)
{
  char *label;
  
  label = (char*)gtk_entry_get_text(GTK_ENTRY(entry));
  if (!label || label[0] == '\0')
    return;
  gtk_file_selection_complete(GTK_FILE_SELECTION(data), label);
}

void on_loadButton_clicked(GtkButton *button, gpointer user_data)
{
  renderingWindowLoad_file(RENDERING_WINDOW(visuRenderingWindowGet_current()));
}

void on_saveButton_clicked(GtkButton *button, gpointer user_data)
{
  gtkSaveInit();
}

void on_observeButton_clicked(GtkButton *button, gpointer user_data)
{
  /* Start new pick & observe session. */
  gtkObservePickInit_session();
}


void on_spinTheta_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_angleOfView(renderingWindowGet_visuData(window),
					 (float)gtk_spin_button_get_value(spinbutton),
					 0., 0., MASK_THETA);
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}

void on_spinOmega_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_angleOfView(renderingWindowGet_visuData(window),
					 0., 0., (float)gtk_spin_button_get_value(spinbutton),
					 MASK_OMEGA);
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}


void on_spinDx_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_positionOfView(renderingWindowGet_visuData(window),
					    (float)gtk_spin_button_get_value(spinbutton),
					    0., MASK_XS);
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}


void on_spinGross_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_zoomOfView(renderingWindowGet_visuData(window),
					(float)gtk_spin_button_get_value(spinbutton));
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}


void on_spinPhi_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_angleOfView(renderingWindowGet_visuData(window), 0.,
					 (float)gtk_spin_button_get_value(spinbutton),
					 0., MASK_PHI);
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}


void on_spinDy_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_positionOfView(renderingWindowGet_visuData(window), 0.,
					    (float)gtk_spin_button_get_value(spinbutton), MASK_YS);
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}


void on_spinPersp_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_perspectiveOfView(renderingWindowGet_visuData(window),
					       (float)gtk_spin_button_get_value(spinbutton));
  if (reDrawNeeded)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL);
}


void on_visuAbout_clicked(GtkButton *button, gpointer user_data)
{
  if (!aboutWindow)
    buildAboutWindow();
  gtk_widget_show(aboutWindow);
}

void on_pairsButton_clicked(GtkButton *button, gpointer user_data)
{
  gboolean realised;

  /* Store in realised if the window is already built (then realised). */
  realised = (pairsDialog != (gpointer)0);
  if (!realised)
    buildPairsDialog();

  pairsIsHide = 0;
  if (pairsIsOutOfDate)
    gtkPairsBuild_viewport();

  if (realised)
    gdk_window_raise(GDK_WINDOW(GTK_WIDGET(pairsDialog)->window));
  visuShowWindow(GTK_WINDOW(pairsDialog));
}


void on_closebutton3_clicked(GtkButton *button, gpointer user_data)
{
  visuHideWindow(GTK_WINDOW(pairsDialog));
  pairsIsHide = 1;
}

gboolean on_pairsDialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  pairsDialog = (GtkWidget*)0;
  return FALSE;
}
