/*
 * $Id: bus.h 1102 2008-02-27 03:38:31Z jiez $
 *
 * Bus driver interface
 * Copyright (C) 2002 ETC s.r.o.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Written by Marcel Telka <marcel@telka.sk>, 2002.
 *
 */

#ifndef BUS_H
#define	BUS_H

#include <stdint.h>

#include <bus_driver.h>

typedef struct {
	int len;
	bus_t **buses;
} buses_t;

extern buses_t buses;
extern const bus_driver_t *bus_drivers[];

void buses_free( void );
void buses_add( bus_t *abus );
void buses_delete( bus_t *abus );

#endif /* BUS_H */
