// ==UserScript==
// @include       http://www.facebook.com/*
// @include       https://www.facebook.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['mercurymessagesCountValue'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var countElement = document.getElementById('mercurymessagesCountValue');
    var notificationElement = document.getElementById('notificationsCountValue');

    function checkMessangesCount() {
        function makeCallback(node) {
            return function () { launchClickEvent(node.parentNode); };
        }
        Unity.MessagingIndicator.showIndicator(_("Messages"), { count: countElement.textContent,
                                                                callback: makeCallback(countElement) });
        Unity.MessagingIndicator.showIndicator(_("Notifications"), { count: notificationElement.textContent,
                                                                     callback: makeCallback(notificationElement) });
    }

    setInterval(checkMessangesCount, 1000);
    checkMessangesCount();
}

if (isCorrectPage()) {
    Unity.init({ name: "facebook",
                 iconUrl: "icon://unity-webapps-facebook",
                 login: localStorage.getItem('login'),
		 domain: 'facebook.com',
		 homepage: 'https://www.facebook.com/',
                 onInit: wrapCallback(messagingIndicatorSetup) });
} else if (document.getElementById('email')) {
    var email = document.getElementById('email');

    window.onunload = function () {
        localStorage.setItem('login', email.value);
    };
}

