/*
 * Copyright (c) 2003-2006 Erez Zadok
 * Copyright (c) 2003-2006 Charles P. Wright
 * Copyright (c) 2005-2006 Josef Sipek
 * Copyright (c) 2005      Arun M. Krishnakumar
 * Copyright (c) 2005-2006 David P. Quigley
 * Copyright (c) 2003-2004 Mohammad Nayyer Zubair
 * Copyright (c) 2003      Puja Gupta
 * Copyright (c) 2003      Harikesavan Krishnan
 * Copyright (c) 2003-2006 Stony Brook University
 * Copyright (c) 2003-2006 The Research Foundation of State University of New York
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package.
 *
 * This Copyright notice must be kept intact and distributed with all sources.
 */


#ifndef __UNIIONCTL_H_
#define __UNIONCTL_H_

#include "config.h"
#include "unionfs.h"

#ifdef HAVE_STDLIB_H
	#include <stdlib.h>
#else /* HAVE_STDLIB_H */
	#error Need stdlib.h to compile
#endif /* HAVE_STDLIB_H */

#ifdef HAVE_STDIO_H
	#include <stdio.h>
#else /* HAVE_STDIO_H */
	#error Need stdio.h to compile
#endif /* HAVE_STDIO_H */

#ifdef HAVE_STRING_H
	#include <string.h>
#else /* HAVE_STRING_H */
	#error Need string.h to compile
#endif /* HAVE_STRING_H */

#ifdef HAVE_SYS_IOCTL_H
	#include <sys/ioctl.h>
#else	/* HAVE_SYS_IOCTL_H */
	#error Need sys/ioctl.h to compile
#endif /* HAVE_SYS_IOCTL_H */

#ifdef HAVE_FCNTL_H
	#include <fcntl.h>
#else /* HAVE_FCNTL_H */
	#error Need fcntl.h to compile
#endif /* HAVE_FCNTL_H */

#ifdef HAVE_ERRNO_H
	#include <errno.h>
#else /* HAVE_ERRNO_H */
	#error Need errno.h to compile
#endif /* HAVE_ERRNO_H */

#ifdef HAVE_LIMITS_H
	#include <limits.h>
#else /* HAVE_LIMITS_H */
	#define PATH_MAX 4096
#endif /* HAVE_LIMITS_H */

#ifdef HAVE_SYS_MOUNT_H
	#include <sys/mount.h>
#else /* HAVE_SYS_MOUNT_H */
	#error Need sys/mount.h to compile
#endif /* HAVE_SYS_MOUNT_H */

#define MAY_READ 4
#define MAY_WRITE 2

/* Branch information */
struct unionfs_branch {
        char *path;
        int perms;
};

inline int parse_rw(char *p);

static void dump_branches(const char *prefix);
static int load_branches(const char *union_path);
static char **parse_options(char *options);

extern int get_real_path(const char *path, char *resolv_path);
extern int find_union(const char *path, char **options, char **actual_path,
		int uniononly);

int unionfs_query(const char *file_path, struct unionfs_branch **ufs_branches);
int unionfs_dump(const char *union_path, const char *prefix);
int unionfs_get_branch(const char *union_path, const char *branch_path);
int unionfs_add(const char *union_path, const char *branch_path, int branch_number, int perms);
int unionfs_mode(const char *union_path, int branch_number, int perms);
int unionfs_remove(const char *union_path, int branch);

#endif /* __UNIONCTL_H_ */
