/*
 * Copyright (c) 2003-2006 Erez Zadok
 * Copyright (c) 2003-2006 Charles P. Wright
 * Copyright (c) 2005-2006 Josef Sipek
 * Copyright (c) 2005      Arun M. Krishnakumar
 * Copyright (c) 2005-2006 David P. Quigley
 * Copyright (c) 2003-2004 Mohammad Nayyer Zubair
 * Copyright (c) 2003      Puja Gupta
 * Copyright (c) 2003      Harikesavan Krishnan
 * Copyright (c) 2003-2006 Stony Brook University
 * Copyright (c) 2003-2006 The Research Foundation of State University of New York
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package.
 *
 * This Copyright notice must be kept intact and distributed with all sources.
 */

#include "unionfs.h"
#include "uniondbg.h"

int unionfs_debug_value(int fd, int *val, unsigned int flag);

/*
   Get/set the debug value of a file
   fd is assumed to be valid
 */
int unionfs_debug_get_value(int fd, int *val)
{
	return unionfs_debug_value(fd, val, FIST_IOCTL_GET_DEBUG_VALUE);
}

int unionfs_debug_set_value(int fd, int *val)
{
	return unionfs_debug_value(fd, val, FIST_IOCTL_SET_DEBUG_VALUE);
}

int unionfs_debug_value(int fd, int *val, unsigned int flag)
{
	int ret;

	if ( flag != FIST_IOCTL_SET_DEBUG_VALUE
				&& flag != FIST_IOCTL_GET_DEBUG_VALUE ) {
		errno = EINVAL;
		return -1;
	}

	ret = ioctl(fd, flag, val);

	return ret;
}

/*
   Returns branch refcounts for file, fd is assumed to be valid.
   branches will contain the total number of branches
   counts will contain the refcount for each branch,
   and must be freed by the calling process
 */
int unionfs_debug_refcounts(int fd, int *num_branches, int **counts)
{
	int ret;

	*num_branches = ioctl(fd, UNIONFS_IOCTL_BRANCH_COUNT, NULL);
	if (*num_branches < 0) return -1;

	*counts = malloc((*num_branches) * sizeof(int));
	if (!(*counts)) return -1;

	ret = ioctl(fd, UNIONFS_IOCTL_BRANCH_COUNT, *counts);
	if (ret < 0) return -1;

	return 0;
}

/*
   Increment the super block generation count
 */
int unionfs_debug_inc_gencount (int fd)
{
	return ioctl(fd, UNIONFS_IOCTL_INCGEN, NULL);
}
