#!/usr/bin/env python
# 
# 2008-11-17 
# Unflag the first attachment marked as a patch and
# add a comment informing people as to why their attachment
# is not a patch
#
# Example usage:
# uncheck-patch-comment.py 348960
#
# Copyright 2009 Canonical, Ltd
# Author: Brian Murray <brian@ubuntu.com>
# Licensed under the GNU General Public License, version 3.

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials
import sys
import os

cachedir = os.path.expanduser("~/launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = sys.argv[0].split("/")[-1].split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(os.fdopen(os.open(credfile, os.O_WRONLY | os.O_CREAT, 0600), "w"))
   
def save_entry(entry):
    try:
        entry.lp_save()
    except HTTPError, error:
        print error.content

target = sys.argv[1]

bug = launchpad.bugs[target]

message_subject = "Re: %s" % bug.title

for attachment in bug.attachments:
    if attachment.type == "Patch":
        attachment_title = attachment.title
        attachment.type = "Unspecified"
        save_entry(attachment)
        message = '''Looking at the attachments in this bug report, I noticed that "%s" was flagged as a patch.  A patch contains changes to an Ubuntu package that will resolve a bug, since this was not one I've unchecked the patch flag for it.  In the future keep in mind the definition of a patch.  You can learn more about what qualifies as a patch at https://wiki.ubuntu.com/Bugs/Patches.  Thanks!''' % attachment_title
        bug.newMessage(content=message, subject=message_subject)
        break

print "There are no patches attached to LP: #%s" % target
