#!/usr/bin/env python
# 
# 2008-12-19 
# Flag the attachment marked as a patch and add a comment informing
# users as to why their attachment is a patch
#
# Example usage:
# check-patch-comment.py 348960
#
# Copyright 2009 Canonical, Ltd
# Author: Brian Murray <brian@ubuntu.com>

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials
import sys
import os

cachedir = os.path.expanduser("~/launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = sys.argv[0].split("/")[-1].split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(os.fdopen(os.open(credfile, os.O_WRONLY | os.O_CREAT, 0600), "w"))
  
target = sys.argv[1]

bug = launchpad.bugs[target]

def save_entry(entry):
    try:
        entry.lp_save()
    except HTTPError, error:
        print error.content

def which_attachment(dictionary):
    for key in dictionary.keys():
        print "[%s] %s" % ( key, dictionary[key]["title"] )
    print ("Which attachment number is a patch? "),
    answer = sys.stdin.readline()
    try:
        choice = attachment_dict[int(answer)]["self"]
    except:
        print "You did not enter a valid number.\n"
    return choice

message_subject = "Re: %s" % bug.title

attachment_dict = {} 
count = 1

for attachment in bug.attachments:
    if attachment.type == "Unspecified":
        attachment_dict[count] = { "self":attachment.self, "title":attachment.title }
        count += 1

if len(attachment_dict) == 1:
    patch = attachment_dict[1]["self"]
elif len(attachment_dict) > 1:
    patch = which_attachment(attachment_dict)
else:
    print "Bug %s has no unspecified attachments" % target
    sys.exit(1)

if patch.type == "Unspecified":
    patch.type = "Patch"
    save_entry(patch)
    patch_adder = patch.message.owner.display_name.encode('utf-8')
    message = '''Looking at the attachments in this bug report, I noticed that "%s" was not flagged as a patch.  A patch contains changes to an Ubuntu package that will resolve a bug and this attachment is one!  Subsequently, I've checked the patch flag for it.  In the future when submitting patches please use the patch checkbox as there are some Launchpad searches that use this feature.  You can learn more about patch workflow at https://wiki.ubuntu.com/Bugs/Patches.  Thanks for your contribution %s!''' % ( patch.title, patch_adder )
    bug.newMessage(content=message, subject=message_subject)
