#!/usr/bin/env python
# 
# 2009-01-30
# This script finds all the members of a team and then searches for Ubuntu bug
# tasks reported by them.
#
# Date reported might be interesting too.
#
# Replace STAGING_SERVICE_ROOT with EDGE_SERVICE_ROOT as needed

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials
from cgi import escape

import sys,os

cachedir = os.path.expanduser("~/.launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = os.path.basename(sys.argv[0]).split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(os.fdopen(os.open(credfile, os.O_WRONLY | os.O_CREAT, 0600), "w"))
    
team_name = sys.argv[1]

# write to this file
datafile = open('%s-reported-bug-tasks.html' % team_name, 'w')

# this could be modified to find any project's bugs assigned to a team
ubuntu = launchpad.distributions['ubuntu']

try:
    team = launchpad.people[team_name]
except:
    print "Unknown team!"

team_members = team.participants

# importance and status sorting

importances = { 'Critical':1, 'High':2, 'Medium':3, 'Low':4, 'Wishlist':5, 'Undecided':6 }

statuses = { "Won't Fix":1, 'New':2, 'Incomplete':3, 'Confirmed':4, 'Triaged':5, 'In Progress':6, 'Fix Committed':7, 'Fix Released':8 } 

# creating a list of all the task collections for each team member
task_collections= []

# also grab the bugs assigned to the team
#task_collections.append(ubuntu.searchTasks(bug_reporter=team))

for team_member in team_members:
    if team_member.is_team is False:
    # this uses the default search and only finds open bugs
        task_collections.append(ubuntu.searchTasks(bug_reporter=team_member))

templatefile = open('template.html', 'r')

for line in templatefile:
    if line.strip() == "<!-- *** Title Space *** -->":
        datafile.write("Bugs reported by members of the %s team\n" % team_name)
    elif line.strip() == "<!-- *** Header Space *** -->":
        datafile.write("Bugs reported by members of the %s team\n" % team_name)
    elif line.strip() == "<!-- *** Paragraph Space *** -->":
        datafile.write("All of these bugs were reporter by mebers of the %s team.  All of the column headers are sortable give them a click!" % team_name)
    elif line.strip() == "<!-- *** Table Header Space *** -->":
        table_header = "<th></th>"  # bug number in this column
        table_header += "<th>Summary</th>"
        table_header += "<th>In</th>"
        table_header += "<th>Importance</th>"
        table_header += "<th>Status</th>"
        table_header += "<th>Reporter</th>"
        table_header += "\n"
        datafile.write(table_header)
    elif line.strip() == "<!-- *** Table Body Space *** -->":
        for collection in task_collections:
            for task in collection:
                try:
                    table_row = "<tr>"
                    table_row += "<td>%s</td>" % task.bug.id
                    table_row += "<td><a href='http://launchpad.net/bugs/%s'>%s</a></td>" % (task.bug.id, escape(task.bug.title.encode('utf-8')))
                    # maybe assignee should be a link to the person's launchpad page
                    table_row += "<td>%s</td>" % task.bug_target_display_name.encode('utf-8')
                    importance = task.importance.encode('utf-8')
                    table_row += '<td><span class="sortkey">%s</span>%s</td>' % ( importances[importance], importance )
                    status = task.status.encode('utf-8')
                    table_row += '<td><span class="sortkey">%s</span>%s</td>' % ( statuses[status], status )
                    table_row += "<td>%s</td>" % task.bug.owner.display_name.encode('utf-8')
                    table_row += "</tr>"
                    table_row += "\n"
                    datafile.write(table_row)
                except HTTPError, error:
                    print "There was an error with bug %s: %s" % (task.title.split(' ')[1].replace('#',''), error)
    else:
        datafile.write(line)
datafile.close()
