#!/usr/bin/env python
# -*- encoding: utf-8 -*-
# 
# 2008-10-24
# This script finds all the members of a team and then search for Ubuntu bug
# tasks assigned to them
#
# Replace STAGING_SERVICE_ROOT with EDGE_SERVICE_ROOT as needed

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials
from operator import itemgetter
from datetime import *
from cgi import escape

import sys,os

cachedir = os.path.expanduser("~/.launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = os.path.basename(sys.argv[0]).split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(os.fdopen(os.open(credfile, os.O_WRONLY | os.O_CREAT, 0600), "w"))
    
team_name = sys.argv[1]

#def has_target(bug, series):
#    series_url = str(series)
#    for task in bug.bug_tasks:
#        if str(task.self_link).startswith(series_url):
#            return True
#    return False

# write to this file
datafile = open('%s-assigned-bug-tasks.html' % team_name, 'w')

# this could be modified to find any project's bugs assigned to a team
ubuntu = launchpad.distributions['ubuntu']

try:
    team = launchpad.people[team_name]
except:
    print "Unknown team!"

team_members = team.participants

# creating a list of all the task collections for each team member
task_collections= []

supported_releases = ['Dapper', 'Hardy', 'Intrepid', 'Jaunty', 'Karmic' ]

counts = {}

importances = { 'Critical':1, 'High':2, 'Medium':3, 'Low':4, 'Wishlist':5, 'Undecided':6 }

statuses = { "Won't Fix":1, 'New':2, 'Incomplete':3, 'Confirmed':4, 'Triaged':5, 'In Progress':6, 'Fix Committed':7, 'Fix Released':8 } 
 
# also grab the bugs assigned to the team
task_collections.append(ubuntu.searchTasks(assignee=team))

for team_member in team_members:
    # this uses the default search and only finds open bugs
    task_collections.append(ubuntu.searchTasks(assignee=team_member))

templatefile = open('template.html', 'r')

for line in templatefile:
    if line.strip() == "<!-- *** Title Space *** -->":
        datafile.write("Bugs assigned to members of the %s team\n" % team_name)
    elif line.strip() == "<!-- *** Header Space *** -->":
        datafile.write("Bugs assigned to members of the %s team\n" % team_name)
    elif line.strip() == "<!-- *** Paragraph Space *** -->":
        datafile.write("All of these bugs are assigned to the %s team or members of that team.  Some rows will be a different color, this indicates they are tagged as a regression.  All of the column headers are sortable give them a click!" % team_name)
    elif line.strip() == "<!-- *** Table Header Space *** -->":
        table_header = "<th></th>"  # bug number in this column
        table_header += "<th>Summary</th>"
        table_header += "<th>In</th>"
        table_header += "<th>Importance</th>"
        table_header += "<th>Status</th>"
        table_header += "<th>Release</th>"
        table_header += "<th>Milestone</th>"
        table_header += "<th>Assignee</th>"
        table_header += "<th>Date Assigned</th>"
        table_header += "<th>Regression</th>"
        table_header += "\n"
        datafile.write(table_header)
    elif line.strip() == "<!-- *** Table Body Space *** -->":
        for collection in task_collections:
            for task in collection:
                try:
                    # skipping any bugs that have this tag
                    if 'ct-rev' in task.bug.tags:
                        continue
                    if [tag for tag in task.bug.tags if 'regression-' in tag]:
                        # change the class to highlight for any bug that has a regression- tag in it
                        table_row = '<tr class="highlight">'
                    else:
                        table_row = "<tr>"
                    table_row += "<td>%s</td>" % task.bug.id
                    table_row += "<td><a href='http://launchpad.net/bugs/%s'>%s</a></td>" % (task.bug.id, escape(task.bug.title.encode('utf-8')))
                    # maybe assignee should be a link to the person's launchpad page
                    table_row += "<td>%s</td>" % task.bug_target_display_name.encode('utf-8')
                    importance = task.importance.encode('utf-8')
                    table_row += '<td><span class="sortkey">%s</span>%s</td>' % ( importances[importance], importance )
                    status = task.status.encode('utf-8')
                    table_row += '<td><span class="sortkey">%s</span>%s</td>' % ( statuses[status], status )

                    # thekorn's idea
                    # while this works it takes an hour
                    #for release in supported_releases:
                    #    target = ubuntu.getSeries(name_or_version=release.lower())
                    #    if has_target(task.bug, target):
                    #        table_row += "<td>%s</td>" % release
                    #    else:
                    #        table_row += "<td></td>" 
 
                    # this worked and takes half as long as the above
                    table_row += "<td>"
                    for release in supported_releases:
                        target = str(task)
                        rt = launchpad.load('%s' % target.replace('ubuntu', 'ubuntu/%s' % release.lower()))
                        if 'not in' not in rt.title:
                            table_row += "%s%s " % (release[0], release[0])
                    table_row += "</td>"

                    if task.milestone:
                        table_row += "<td>%s</td>" % task.milestone.name.encode('utf-8')
                    else:
                        table_row += "<td></td>"

                    #assignee = task.assignee.display_name.encode('utf-8')
                    assignee = task.assignee.display_name
                    try:
                        table_row += "<td>%s</td>" % assignee.encode('utf-8')
                    except UnicodeDecodeError:
                        table_row += "<td>%s</td>" % task.assignee.name
                    #table_row += "<td></td>"
                    #table_row += "<td>%s</td>" % task.date_assigned[:10].encode('utf-8')
                    table_row += "<td>%s</td>" % task.date_assigned.strftime("%Y-%m-%d")
                    items = [tag for tag in task.bug.tags if 'regression-' in tag]
                    if len(items) > 0:
                        table_row += "<td>"
                        for item in items:
                            table_row += "%s " % item.encode('utf-8')
                        table_row += "</td>"
                    else:
                        table_row += "<td></td>"
                    table_row += "</tr>"
                    table_row += "\n"
                    datafile.write(table_row)
                    # only count rows that show up on the report not hokey ones
                    counts['total'] = counts.setdefault('total', 0) + 1
                    counts['%s' % assignee] = counts.setdefault(assignee, 0) + 1
                except HTTPError, error:
                    print "There was an error with LP: #%s: %s" % (task.title.split(' ')[1].replace('#',''), error.content)
                    #1/0
    elif line.strip() == "<!-- *** Last Paragraph Space *** -->":
        datafile.write("A total of %s bug tasks are assigned to the %s team!<br><br>" % (counts['total'], team_name) )
        for k,v in sorted(counts.items(), key=itemgetter(1), reverse=True):
            if k == 'total':
                continue
            if counts[k] == 1:
                datafile.write("\n%s has %s task assigned<br>" % (k.encode('utf-8'), counts[k]))
            else:
                datafile.write("\n%s has %s tasks assigned<br>" % (k.encode('utf-8'), counts[k]))
    else:
        datafile.write(line)
datafile.close()
