

/*
   menu.c - menu & misc drawing functions
 */

#include "typespeed.h"


void drawmenu()
{

	dcolor_set(5, NULL);

	mvprintw(3, 30, "Typespeed %s", TVERSION);

	mvprintw(5, 30, "1. Test Your Speed");
	mvprintw(6, 30, "2. Network Head2Head");
	mvprintw(7, 30, "3. Story/Credits/RTFM!");
	mvprintw(8, 30, "4. Show Highscores");
	mvprintw(9, 30, "5. Options");
	mvprintw(10, 30, "6. Quit");

	mvprintw(12, 30, "Choose: ");

	dcolor_set(2, NULL);
}

void tell_story()
{

	int nappi;

	clear();
	drawscreen();
	dcolor_set(5, NULL);

	mvprintw(3, 2, "Typespeed %s", TVERSION);
	mvprintw(5, 2, "Typespeed is made by  Jani Ollikainen  <bestis@iki.fi>");
	mvprintw(6, 2, "                    & Jaakko Manelius  <jman@iki.fi>");
	mvprintw(8, 2, "Typespeed's idea is ripped from ztspeed (a dos game made");
	mvprintw(9, 2, "by Zorlim). Typespeed doesn't give scores that can be");
	mvprintw(10, 2, "compared with ztspeed anymore. We wanted to use our way.");
	mvprintw(12, 2, "Idea of the game should be clear to anyone, just type and");
	mvprintw(13, 2, "type it fast, or be a lewser. ");
	mvprintw(15, 2, "Bugs/Ideas/Comments to <bestis@iki.fi>");

	nodelay(stdscr, 0);
	cbreak();
	flushinp();

	dcolor_set(4, NULL);
	mvprintw(17, 2, "Press any key to continue...");
	do {
	}
	while ((nappi = getch()) == ERR);


	dcolor_set(2, NULL);
}

int dochange(int number)
{

	if (number == 1) {
		number = 0;
	} else {
		number = 1;
	}
	return number;
}

void multipmenu() {

        int wheretogo = 0;
	int exitnow=0;
	char *servo;

	servo=malloc(80*sizeof(char));

        do {

                clear();
                drawscreen();

                dcolor_set(5, NULL);

                mvprintw(3, 30, "Typespeed %s", TVERSION);

                mvprintw(5, 30, "1. Server    ");
                mvprintw(6, 30, "2. Client    ");
                mvprintw(7, 30, "3. Port      ");
                mvprintw(8, 30, "4. Return    ");

                if (opt.server) {
                        dcolor_set(3, NULL);
                        mvprintw(5, 44, "ON");
                } else {
                        dcolor_set(6, NULL);
                        mvprintw(5, 44, "OFF");
                }
                if (opt.client) {
                        dcolor_set(3, NULL);
                        mvprintw(6, 44, "ON");
                } else {
                        dcolor_set(6, NULL);
                        mvprintw(6, 44, "OFF");
                }
		
                dcolor_set(5, NULL);

		mvprintw(7, 44, "%d",opt.port);		

		mvprintw(10, 30, "Choose: ");

		nodelay(stdscr, 0);
		cbreak();

		wheretogo = getch();

		switch (wheretogo) {
			case 49: {
				if(!opt.client) {
					if(!opt.server) {
						opt.server=1;
						exitnow=1;
					} else {
						close_network();
						opt.server=0;
						typesocket=0;
						exitnow=0;
					}
				}
				break;
			}
			case 50: {
				if(!opt.server) {
					if(!opt.client) {
						opt.client=1;
	                                	dcolor_set(5, NULL);
        	                        	mvprintw(10, 30, "Enter Host: ");
						liima_mvgetnstr(10, 42, servo, 80);
						exitnow=1;
					} else {
						opt.client=0;
						typesocket=0;
						exitnow=0;
					}
				}		
				break;
			}
                        case 51: { 
                                dcolor_set(5, NULL);
                                mvprintw(10, 30, "Enter Port: ");
                                liima_mvgetnstr(10, 42, servo, 80);
				opt.port=strtol(servo, NULL, 10);
				if (opt.port <= 1024) opt.port=6025;
				exitnow=0;
				break;
			}
			case 52: {
				exitnow=1;
				break;
			}
                }
        } while (exitnow==0);

        if (wheretogo==52||(!opt.client && !opt.server)) return;
        
        clear();
        drawscreen();

        dcolor_set(5, NULL);

        mvprintw(3, 30, "Typespeed %s", TVERSION);
        mvprintw(5, 30, "When you get connect, choose a wordfile and");
        mvprintw(6, 30, "then wait for the game start. The game starts as");
        mvprintw(7, 30, "soon as the other player has chosen a wordfile.");

	refresh();
            
    	do {
        	if (opt.server || opt.client) typesocket = init_network(servo,1);
    	} while(typesocket<0);

	flushinp();
	free(servo);

}

void optionmenu()
{

	int wheretogo = 0;
	char *trasp;
	trasp = malloc(4 * sizeof(char));


	do {

		clear();
		drawscreen();

		dcolor_set(5, NULL);

		mvprintw(3, 30, "Typespeed %s", TVERSION);

		mvprintw(5, 30, "1. Colors    ");
		mvprintw(6, 30, "2. Cheat     ");
		mvprintw(7, 30, "3. Training  ");
		mvprintw(8, 30, "4. Trng Speed");
		mvprintw(9, 30, "5. Reset a Scorefile");
		mvprintw(10, 30, "6. Return");
		if (opt.usecolors) {
			dcolor_set(3, NULL);
			mvprintw(5, 44, "ON");
		} else {
			dcolor_set(6, NULL);
			mvprintw(5, 44, "OFF");
		}
		if (opt.cheat) {
			dcolor_set(3, NULL);
			mvprintw(6, 44, "ON");
		} else {
			dcolor_set(6, NULL);
			mvprintw(6, 44, "OFF");
		}
		if (opt.training) {
			dcolor_set(3, NULL);
			mvprintw(7, 44, "ON");
		} else {
			dcolor_set(6, NULL);
			mvprintw(7, 44, "OFF");
		}
		dcolor_set(3, NULL);
		mvprintw(8, 44, "%d", opt.traspeed);

		dcolor_set(5, NULL);
		mvprintw(12, 30, "Choose: ");

		nodelay(stdscr, 0);
		cbreak();

		dcolor_set(2, NULL);
		wheretogo = getch();

		switch (wheretogo) {
		case 53:
			{
				clear();
				drawscreen();
				choose_wordfile(2);
			}
			break;
		case 52:
			{
				dcolor_set(5, NULL);
				mvprintw(12, 30, "Enter Speed:     ");
				liima_mvgetnstr(12, 43, trasp, 2);
				if ((strtol(trasp, NULL, 10) >= 2) && (10 >= strtol(trasp, NULL, 10))) {
					opt.traspeed = strtol(trasp, NULL, 10);
				}
			}
			break;
		case 51:
			{
				opt.training = dochange(opt.training);
			}
			break;
		case 50:
			{
				opt.cheat = dochange(opt.cheat);
			}
			break;
		case 49:
			{
				opt.usecolors = dochange(opt.usecolors);
			}
			break;
		}

	}
	while (wheretogo != 54);

	free(trasp);

}

int showhighscores()
{

	clear();
	drawscreen();
	choose_wordfile(1);
	return 0;
}

void drawscreen()
{
	int i;

	dcolor_set(2, NULL);

	if (opt.usecolors == 1) {
		for (i = 0; i < 24; i++) {
			mvprintw(i, 0,
				 "                                                                                ");
		}
	}
	dcolor_set(4, NULL);

	for (i = 0; i < 80; i++)
		mvprintw(22, i, "-");

	dcolor_set(2, NULL);

	if (opt.cheat)
		mvprintw(22, 73, "CHE");
	if (opt.training)
		mvprintw(22, 76, "TRA");
	if (opt.client)
		mvprintw(22, 70, "CLI");
	if (opt.server)
		mvprintw(22, 70, "SER");	

	dcolor_set(4, NULL);

	mvprintw(23, 1, ">");
	mvprintw(23, 21, "<");

	dcolor_set(5, NULL);
	mvprintw(23, 25,
	      "                                                       ");
	mvprintw(23, 23, "Rank: ");
	mvprintw(23, 38, "Score: ");
	mvprintw(23, 49, "tCPS: ");
	mvprintw(23, 60, "cCPS: ");
	mvprintw(23, 71, "Misses: ");
/*      level(now.score); */
	mvprintw(23, 29, "%s", rankki[level(now.score)]);
	dcolor_set(3, NULL);
	mvprintw(23, 45, "%d", now.score);
	mvprintw(23, 55, "%2.2f", now.totalspeed);
	mvprintw(23, 66, "%2.2f", now.speed);
	mvprintw(23, 78, "%d", misses);
	dcolor_set(2, NULL);

}
