<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup installation
 * @module installation_show
 * @package installation
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("installation","show");
 loadmodule("installation");
 loadlayout();

 /**
  * display an overview of installations
  */
 class installation_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang,$current_user;

     echo $this->DataTableStart();

     echo "<tr>\n";
     echo " <th colspan=\"4\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";

     echo "</tr><tr>\n";
     echo $this->showfield($lang['ProductP']);
     if ( $this->obj->product != -1 ) {
       echo " <td colspan=\"3\">". $this->obj->product->getLink() ."&nbsp;</td>\n";
     } else {
       echo " <td colspan=\"3\">". $lang['HistoryDeleted'] ."&nbsp;</td>\n";
     }
     echo "</tr><tr>\n";
     echo $this->showfield($lang['Customer']);
     echo "<td colspan=\"3\">";
     if ( $this->obj->customer == -1 ) {
       echo "<i>". $lang['HistoryDeleted'] ."</i>";
     } else if ( $this->obj->customer->id != -1 ) {
       echo $this->obj->customer->getLink();
     } else {
       echo "&nbsp;";
     }
     echo "&nbsp;</td>\n";

     echo "</tr><tr>\n";
     echo $this->showfield($lang['Description']);
     echo $this->showdata(myentities($this->obj->description) ."&nbsp;",3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['InstalledBy']);
     if ( $this->obj->installer->id != -1 ) {
       echo " <td>". $this->obj->installer->getLink() ."&nbsp;</td>\n";
     } else {
       echo " <td>&nbsp;</td>\n";
     }
     echo $this->showfield($lang['atDateTime']);
     echo $this->showData($this->obj->instdate->getLinkDate(),1);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['SoldBy']);
     if ( $this->obj->seller->id != -1 ) {
       echo " <td>". $this->obj->seller->getLink() ."</td>\n";
     } else {
       echo " <td>&nbsp;</td>\n";
     }
     echo $this->showfield($lang['atDateTime']);
     echo $this->showData($this->obj->salesdate->getLinkDate(),1);

     echo "</tr><tr>\n";
     $x= array($this->obj->money,$this->obj->currency);
     echo $this->showfield($lang['Money']);
     echo $this->showdata(handle('money',$x,number_format($this->obj->money,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp<b>". $this->obj->currency ."</b>"),3);

     echo "</tr>\n";

     if ( $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $this->obj->readTimetrackSum();
       $rows = 0;
       if ( $this->obj->timetracksum > 0) {
         $rows++;
	   }
       @reset ($this->obj->tsum);
       while( list ($i,$f) = @each ($this->obj->tsum)) {
         if ( $this->obj->tsum[$i] > 0 ) {
           $rows++;
         }
       }
       $r = 0;
       if ( $rows > 0 ) {
         echo "<tr>\n";
         echo "<td class=\"desc\" valign=\"top\" rowspan=\"". $rows ."\">". $lang['Timetrack'] ;
         echo "</td>\n";

         if ( $this->obj->timetracksum > 0) {
           echo " <td valign=\"top\" align=\"right\">\n";
           echo makelink("timetrack_overview.php?link_id=". $this->obj->id ,number_format($this->obj->timetracksum,2),$lang['TimetrackOverview']);
           echo " </td>\n";
           echo " <td align=\"left\">". $lang['hours'] ."</td>\n";
           echo " <td>&nbsp;</td>\n";
           echo "</tr>\n";
           $r = 1;
         }
         @reset ($this->obj->tsum);
         while( list ($i,$f) = @each ($this->obj->tsum)) {
           if ( $this->obj->tsum[$i] > 0 ) {
             if ( $r == 1 ) {
               echo "<tr>\n";
             }
             echo " <td align=\"right\">". number_format($this->obj->tsum[$i],2) ."</td>\n";
             echo " <td align=\"left\">". $lang['hours'] ."</td>\n";
             echo " <td>(". $lang[$i] .")</td>\n";
             echo "</tr>\n";
             $r = 1;
           }
         }
       }
     }
     # References to modules
     show_module_infolists($this->user,$this->obj,4);
     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();
   }
   /**
    *
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<tr><td>";
     if ( $this->user->feature_ok(usetimetrack,PERM_NEW) ) {
       echo menulink("timetrack_new.php?mode=1&reftype=installation&lid=".$this->obj->id,$lang['TTRecord'],$lang['TTRecord']) ."<br>\n";
     }
     echo "</td></tr>";
   }
   /**
    * preapre everything read data , parse args etc
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['InstDetail'];

     $this->obj = new installation($this->dbconn);
     if (isset($_GET['id'])) {
       $this->obj->read($_GET['id']);
     }
     if ($this->obj->id < 1) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$$this->obj->getType()]);
     }

     # menu
     $m = installation::getOverviewLink($this->user,$lang['Installations']);
     $m[category][] = "obj";
     $this->addmenu($m);
     if ( $this->user->feature_ok(useinstmanagement,PERM_NEW) ) {
       $x = array( url => "installation/installation_new.php",
                   confirm => false,
                   text => $lang['NewEntry'],
                   info => sprintf($lang['InstCreateI'],""),
                   category => array("installation","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => $this->obj->getModURL(),
                   text => $lang['Modify'],
                   info => sprintf($lang['InstModifyI'],$this->obj->getFullname()),
                   category => array("installation","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => sprintf($lang['InstDelI'],$this->obj->getFullname()),
                   category => array("installation","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }

     $x = timetrack::getaddlink($this->user,$this->obj);
     $this->addMenu($x);

     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
	 $this->addtohistory();
   }
 }

 $l = new installation_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: installation_show.php,v 1.15 2003/10/22 17:47:21 gokohnert Exp $
    $Author: gokohnert $
-->
