<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * Editing of TUTOS users and their permissions
 *
 * @modulegroup user
 * @module user_new
 * @package user
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("user","new");

 /**
  * display a user change/create form
  */
 class user_new extends layout {
   /**
    * helpfunction to generate an option-field
    */
   Function acldefault_select($min,$max,$name) {
     global $lang,$tutos;

     $nr["r"] = 0;
     $nr["u"] = 1;
     $nr["m"] = 2;
     $nr["d"] = 3;
     $js = "onchange='deselect(this.form,". $nr[$name] .");'";
     echo " <select multiple size=\"". min(count($this->obj->teamlist),$tutos[maxshow]) ."\" name=\"". $name ."[]\" ". $js .">\n";
     if ( isset($this->obj->acldefault[MYTEAMS]) ) {
       $l = $this->obj->acldefault[MYTEAMS];
     } else {
       $l = 0;
     }
     if ( ($l < $max) && ($l >= $min) ) {
       echo "  <option value=\"". MYTEAMS ."\" selected>&nbsp;all my teams</option>\n";
     } else {
       echo "  <option value=\"". MYTEAMS ."\">&nbsp;all my teams</option>\n";
     }
     foreach ($this->obj->teamlist as $i => $fn) {
       if ( isset($this->obj->acldefault[$i]) ) {
         $l = $this->obj->acldefault[$i];
       } else {
         $l = 0;
       }
       if ( ($l < $max) && ($l >= $min) ) {
         echo "  <option value=\"". $i ."\" selected >&nbsp;". $this->obj->teamlist[$i]->getFullName() ."&nbsp;</option>\n";
       } else {
         echo "  <option value=\"". $i ."\">&nbsp;". $this->obj->teamlist[$i]->getFullName() ."&nbsp;</option>\n";
       }
     }
     echo " </select>\n";
   }

   /**
    * the data display part
    */
   Function info() {
     global $lang,$tutos,$table;

     $this->assign('action', "user_ins.php");
     $this->assign('UserInfo', $lang['UserInfo']);
     $this->assign('is_admin', $this->user->isAdmin());
     $this->assign('uid', $this->obj->uid);
     $this->assign('id',  $this->obj->id);

     $this->assign('login',
		   array('label' => $lang['Username'],
			 'id'    => 'login',
			 'name'  => 'login',
			 'value' => myentities($this->obj->login),
			 'size'  => min($table['people']['login'][size], 20),
			 'maxlength' => $table['people']['login'][size],
			 'disabled' => $this->obj->disabled));


     if ($this->obj->id == -1) {
       $this->assign('fname',
		     array('label' => $lang['AdrFirstName'],
			   'id'    => 'fname',
			   'name'  => 'fname',
			   'value' => myentities($this->obj->f_name),
			   'size'  => min(40,
					  $table['address']['f_name'][size]),
			   'maxlength' => $table['address']['f_name'][size]));
       
       $this->assign('lname',
		     array('label' => $lang['AdrLastName'],
			   'id'    => 'lname',
			   'name'  => 'lname',
			   'value' => myentities($this->obj->l_name),
			   'size'  => min(40,
					  $table['address']['l_name'][size]),
			   'maxlength' => $table['address']['l_name'][size]));
       
       $this->assign('email',
		     array('label' => $lang['AdrEmail'],
			   'id'    => 'email',
			   'name'  => 'email',
			   'value' => myentities($this->obj->email_1),
			   'size'  => min(40,
					  $table['location']['email_1'][size]),
			   'maxlength' => $table['location']['email_1'][size])
		     );

     }
     else {
       $this->assign('user',
		     array('label' => $lang['User'],
			   'value' => $this->obj->getFullName(),
			   'title' => $this->obj->getFullName(),
			   'link'  => $this->obj->getUrl()));
		     
       $this->assign('lastseen',
		     array('label' => $lang['UserLastSeen'],
			   'value' => $this->obj->last_seen->getDateTime()));
       
       $this->assign('lasthost',
		     array('label' => $lang['UserLastHost'],
			   'value' => $this->obj->last_host));

     }

     $this->assign('no',  $lang['no']);
     $this->assign('yes', $lang['yes']);
     $this->assign('admin',
		   array('label' => $lang['UserAdmin'],
			 'id'    => 'admin',
			 'name'  => 'admin',
			 'value' => $this->obj->isadmin()));

     $ask_password = 
	$tutos[authtype] != "pam" && $tutos[authtype] != "ldap";

     $this->assign('ask_password', $ask_password);

     if ( ($tutos[authtype] != "pam") && ($tutos[authtype] != "ldap") ) {
       if ( $this->dbconn->Password("a") == "'a'" ) {
	 $this->assign('pass_crypt_warn', $lang['Err0055']);
       }
       if ( ! $this->user->isAdmin()
	    && $this->dbconn->gettype() != "MySQL" ) {

	 $this->assign('oldpw',
		       array('label' => $lang['OldPassword'],
			     'id'    => 'p0',
			     'name'  => 'p0',
			     'value' => ""));
       }
       $this->assign('newpw',
		     array('label' => $lang['NewPassword'],
			   'id'    => 'p1',
			   'name'  => 'p1',
			   'value' => ""));
       
       $this->assign('confirmpw',
		     array('label' => $lang['ConfirmPassword'],
			   'id'    => 'p2',
			   'name'  => 'p2',
			   'value' => ""));
     }

     /*
     // Feature Permissions
     permission_form($this,$this->user,$this->obj);

     // Default-Groups for new objects
     if ( ($tutos[defaultacl] == 2) &&
        ( ($this->user->isAdmin())  || (count($this->user->teamlist) > 0) ) 
       ) {
       // read a list of all teams;
       $q = "select * from ". $this->dbconn->prefix ."teams";
       $r = $this->dbconn->Exec($q);
       $n = $r->numrows();
       $a = 0;
       $this->obj->teamlist = array();
       while ( $a < $n ) {
         $t = new team($this->dbconn);
         $t->read_result($r,$a);
         $this->obj->teamlist[$t->id] = &$t;
         unset ($t);
         $a++;
       }
       $r->free();
       echo "<tr>\n";
       echo $this->showfieldc($lang['UserDefaultGrp'],0,"acldefault");
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."</th>\n";
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLuse'] ."</th>\n";
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLuse'] ."<br>". $lang['ACLmodify'] ."</th>\n";
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLuse'] ."<br>". $lang['ACLmodify'] ."<br>". $lang['ACLdelete'] ."</th>\n";
       echo "</tr>\n";
       echo "<tr>\n"; 
       echo " <td colspan=\"1\">&nbsp;</td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select(1,$tutos[useok],"r");
       echo " </center></td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select($tutos[useok], $tutos[modok],"u");
       echo " </center></td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select($tutos[modok], $tutos[delok],"m");
       echo " </center></td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select($tutos[delok], 99, "d");
       echo " </center></td>\n";
       echo "</tr>\n";
     }
     */

     $languages = array();
     foreach($lang['lang'] as $i => $f) {
       $languages[$i] = myentities($f);
     }

     $this->assign('language',
		   array('label' => $lang['UserLanguage'],
			 'id'    => 'lng',
			 'name'  => 'lng',
			 'options'  => $languages,
			 'selected' => $this->obj->lang));

     $timezones = array();
     foreach($tutos[timezones] as $f) {
       $timezones[] = $f;
     }

     $this->assign('timezone',
		   array('label' => $lang['UserTimezone'],
			 'id'    => 'tz',
			 'name'  => 'tz',
			 'options'  => $timezones,
			 'selected' => $this->obj->tz));

     $this->assign('ws',
		   array('label' => $lang['UserWeekstart'],
			 'id'    => 'ws',
			 'name'  => 'ws',
			 'options'  => array(0 => $lang['Day0'],
					     1 => $lang['Day1'],
					     2 => $lang['Day2']),
			 'selected' => $this->obj->weekstart));
     
     $wdays = array();
     $swdays = array();
     for( $i = 0 ; $i < 7 ; $i++ ) {
       $wdays[$i] = $lang['Day'.$i];

       if( $this->obj->isworkday($i) )
	 $swdays[] = $i;
     }
     $this->assign('wdays',
		   array('label' => $lang['UserWorkdays'],
			 'id'    => 'wd[]',
			 'name'  => 'wd',
			 'options'  => $wdays,
			 'selected' => $swdays));

     $hdays = array();
     $shdays = array();
     foreach( $tutos[holiday] as $i => $f ) {
       if ( $tutos[holiday][$i] != 1 ) {
         continue;
       }

       $hdays[$i] = $i;
       if( $this->obj->holiday[strtolower($i)] == 1 )
	 $shdays[] = $i;
     }
     $this->assign('hdays',
		   array('label' => $lang['UserHoliday'],
			 'id'    => 'h[]',
			 'name'  => 'h[]',
			 'options'  => $hdays,
			 'selected' => $shdays));

     /*
     // Namedays
     $xx = 1;
     echo $this->showfield($lang['UserNamedays'],0,"nd[]");
     echo " <td colspan=\"2\">\n";
     foreach ($tutos[nameday] as $i => $f) {
       if ( $tutos[nameday][$i] != 1 ) {
         continue;
       }
       echo "  <input id=\"nd[]\" type=\"checkbox\" name=\"nd[]\" value=\"". strtolower($i) ."\" ". ($this->obj->nameday[strtolower($i)] == 1 ? "checked":"") .">". $i;
       if ( 0 == ($xx % 3) ) {
         echo "<br>\n";
       } else {
         echo "&nbsp;&nbsp;";
       }
       $xx++;
     }
     echo " </td>\n";

     echo "<td colspan=\"3\">&nbsp;</td>\n";

     echo "</tr>\n";

     echo "<tr>\n";

     // THEME
     echo $this->showfieldc($lang['UserTheme'],1,"theme");
     echo " <td colspan=\"2\">\n";
     echo " <select id=\"theme\" name=\"theme\">\n";
     foreach($tutos[themes] as $f) {
       echo "  <option value=\"". $f ."\" ". ($f == $this->obj->theme ? " selected":"") .">". $f ."</option>\n";
     }
     echo " </select>\n";
     echo " </td>\n";

     // Layout Engine
     echo $this->showfieldc($lang['UserLayout'],1,"layout");
     echo " <td colspan=\"2\">\n";
     echo " <select id=\"layout\" name=\"layout\">\n";
     foreach($tutos[layouts] as $f) {
       echo "  <option value=\"". $f ."\" ". ($f == $this->obj->ly ? " selected":"") .">". $f ."</option>\n";
     }
     echo " </select>\n";
     echo " </td>\n";

     echo "<td colspan=\"3\">&nbsp;</td>\n";

     echo "</tr>\n";

     // References to modules
     module_addforms($this->user,$this->obj,8);

     echo "<tr>\n";
     if ($this->obj->uid > 0 ) {
       submit_reset(0,1,3,1,3,0);
     } else {
       submit_reset(0,-1,3,1,3,0);
     }
     echo "</tr>\n";
     if ( ($this->obj->uid != -1) && ($this->user->feature_ok(usehistory,PERM_SEE)) ) {
       echo "<tr>\n";
       echo " <td colspan=\"8\">". makelink("history_show.php?id=". $this->obj->uid,$lang['HistoryLink'],sprintf($lang['HistoryLinkI'],$this->obj->getFullname())) ."</td>\n";
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     echo $this->getHidden();
     hiddenFormElements();
     echo "</form>\n";
     echo $lang['FldsRequired'] ."\n";
     echo $this->setfocus("useradd.login");
     */

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "addrnew.name");
     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('user_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->obj = new tutos_user($this->dbconn);
     if ( isset($_GET['id']) ) {
       # Read address as a user entry
       $this->obj->read($_GET['id'],0);
       $this->obj->read_permissions();
     } else if ( isset($_GET['uid']) ) {
       $this->obj->read($_GET['uid'],1);
       $this->obj->read_permissions();
     } else {
       # We need a new adress entry and location
       $this->obj->email_1 = "";
       if ( isset($_GET['fname']) ) {
         $this->obj->f_name = $_GET['fname'];
       }
       if ( isset($_GET['lname']) ) {
         $this->obj->l_name = $_GET['lname'];
       }
       if ( isset($_GET['email']) ) {
         $this->obj->email_1 = $_GET['email'];
       }
     }

     if ( ($this->obj->uid == -1) && !$this->user->feature_ok(useuser,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ($this->obj->id == -1) && !$this->user->feature_ok(useuser,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     if ( $tutos[useacl] != 1) {
       if ( !$this->user->isadmin() && ($this->user->id != $this->obj->id ) ) {
         $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }

     if ( $this->obj->uid != -1 ) {
       $this->name = $lang['UserModify'] .": ". $this->obj->login;
     } else {
       $this->name = $lang['UserCreate'];
     }

     if (isset($_GET['login'])) {
       $this->obj->login = StripSlashes($_GET['login']);
     }

     if ($this->obj->login =="") {
       // create a default 
       $this->obj->login = strtolower(substr($this->obj->f_name,0,min(2,strlen($this->obj->f_name))) . substr($this->obj->l_name,0,min(6,strlen($this->obj->l_name))));
     }


     if ( isset($_GET['h']) ) {
       foreach ($_GET['h'] as $i => $f) {
         $this->obj->holiday[$i] = $f;
       }
     }
     if ( isset($_GET['wd']) ) {
       $this->obj->workday = array();
       foreach($_GET['wd'] as $i => $f) {
         $this->obj->workday[$i] = $f;
       }
     }
     if ( isset($_GET['nd']) ) {
       foreach($_GET['nd'] as $i => $f) {
         $this->obj->nameday[$i] = $f;
       }
     }
     if ( isset($_GET['ws']) ) {
       $this->obj->weekstart = $_GET['ws'];
     }

     // Create the menu items
     // var_dump ($this->obj->acl);
     if ( $this->user->feature_ok(useuser,PERM_NEW) ) {
       $x = array('url'  =>  "user_new.php",
                  'text' =>  $lang['NewEntry'],
                  'info' =>  $lang['UserCreate'],
		  'image' => 'new',
                  'category' => array("user","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->del_ok()) && ($this->obj->uid > 0) ) {
       $x = array('url'   => "user_del.php?id=". $this->obj->id,
                  'text'  => $lang['Delete'],
                  'info'  => sprintf($lang['UserDelInfo'],
				     $this->obj->getFullName()),
		  'image' => 'delete',
                  'confirm' => true,
                  'category' => array("user","admin","obj","del")
                 );
       $this->addMenu($x);
     }

     if ( $this->obj->uid > 0) {
       $x = array('url'   => "mytutos.php?adr=". $this->obj->id,
                  'text'  => sprintf($lang['PersonalPageFor'],
				     $this->obj->getFullName()),
                  'info'  => sprintf($lang['PersonalPageFor'],
				     $this->obj->getFullName()),
		  'image' => 'user',
                  'confirm' => false,
                  'category' => array("view","obj")
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this, $this->obj);
     web_StackStartLayout($this,"user_new.php","user_new.php?".$_SERVER['QUERY_STRING']);     
   }
 }


 $l = new user_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: user_new.php,v 1.76.2.4 2005/02/10 14:33:36 tapoueh Exp $
    $Author: tapoueh $
-->