<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 * cloning option added by Michal Salaban 2003
 *
 * create a new product or modify/clone an existing one
 *
 * @modulegroup product
 * @module product_new
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','new');

 /**
  * change/modify a project
  */
 class product_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     $this->assign('action', "product_ins.php");
     $this->assign('title', sprintf($lang['Showing'],
				    $lang[$this->obj->getType()]));

     if( $this->template )
       $this->assign("tplid", $this->obj->id);
     else {
       if( $this->obj->id > 0 )
	 $this->assign("id", $this->obj->id);
       else
	 $this->assign("id", "");

       $this->assign("tplid", "");
     }

     $this->assign('ProdCreation', sprintf($lang['ProdCreation'],
					   $this->obj->creator->getLink(),
					   $this->obj->creation->getDateTime()
					   ));
     $this->assign("name",
		   array('label' => $lang['ProdName'],
			 'name'  => 'name',
			 'size'  => min($table['product']['name'][size],40),
			 'maxl'  => $table['product']['name'][size],
			 'value' => myentities($this->obj->name)
			 ));

     $this->assign("version",
		   array('label' => $lang['ProdVersion'],
			 'name'  => 'version',
			 'size'  => min($table['product']['version'][size],20),
			 'maxl'  => $table['product']['version'][size],
			 'value' => myentities($this->obj->version)
			 ));



     $states = array();
     foreach ($lang['ProdStates'] as $f => $i) {
       if ( $f >= 0 )
	 $states[$f] = myentities($lang['ProdStates'][$f]);
       if( $f == $this->obj->state )
	 $state = $f;
     }

     $this->assign("state",
		   array('label' => $lang['ProdState'],
			 'name'  => 'state',
			 'options'  => $states,
			 'selected' => $state));

     $this->assign("prob",
		   array('label' => $lang['ProdProb'],
			 'name'  => "prob",
			 'value' => number_format($this->obj->probability, 0,
						  $lang['DecPoint'],
						  $lang['ThousandPoint'])));
     
     /**
      * Parent product
      */
     if( isset($this->obj->xl['parent']) ) {
       // User tried a product input, and now must choose one of the
       // pre-selected products as a parent.
       $parents = array();
       foreach( $this->obj->xl['parent'] as $i => $f )
	 $parents[$i] = myentities($f->getFullName());

       $this->assign("parent",
		     array('id'      => "parent",
			   'name'    => "parent_id",
			   'size'  => min($table['product']['name'][size],40),
			   'maxl'  => $table['product']['name'][size],

			   'label'  => $lang['ProdRole'][10],
			   'options' => $parents));
     }
     else {
       $parent = "";

       if( isset($this->obj->parent) && is_object($this->obj->parent) ) {
	 $parent = $this->obj->parent->getShortName();	 
       }
       $this->assign("parent",
		     array('id'     => 'parent',
			   'name'   => 'parent',
			   'size'  => min($table['product']['name'][size],40),
			   'maxl'  => $table['product']['name'][size],

			   'label'  => $lang['ProdRole'][10],
			   'value'  => $parent));
     }


     # Roles of peoples and teams etc.
     $this->assign("role",
		   array('label' => $lang['ProdRoles'],
			 'name'  => ''));
     
     $this->assign('ProdFunc',     $lang['ProdFunc']);
     $this->assign('AdrName',      $lang['AdrName']);
     $this->assign('ProdRoleDesc', $lang['ProdRoleDesc']);
     $this->assign('ProdRolesNew', $lang['ProdRolesNew']);

     # List all roles in this project
     $this->assign('Remove', $lang['Remove']);
     $roles = array();

     if ( $this->obj->id > 0 ) {
       $n = 0;
       foreach ($lang['ProdRole'] as $role => $x) {
         if ( isset($this->obj->role[$role]) ) {
           foreach ($this->obj->role[$role] as $i => $o) {
             if ( $o->id < 1 ) {
               continue;
             }
             if ( $o->getType() == "product" ) {
               continue;
             }
             $val = $o->id .",". $role;
             if ( ! isset($this->obj->rdel[$val]) ) {
               $this->obj->rdel[$val] = "";
             }
	     $roles[] = array('name'  => $lang['ProdRole'][$role],
			      'link'  => $o->getLink(),
			      'desc'  => $this->obj->roledesc[$role][$i],
			      'del_val' => $val,
			      'del_lab' => $this->obj->rdel[$val]);

             $n++;
           }
         }
       }
     }
     $this->assign("roles", $roles);

     /**
      * New role
      */
     $proles = array();
     foreach ($lang['ProdRole'] as $role => $x) {
       # No Product Roles
       if ( $tutos[rolecheck][$role] == "p") {
         continue;
       }
       $proles[$role] = myentities($lang['ProdRole'][$role]);
     }

     $r1desc_size = $table['product2']['description'][size];
     $this->assign("r1desc",
		   array('name'  => 'r1desc',
			 'value' => myentities($this->r1desc),
			 'size'  => min(30, $r1desc_size),
			 'maxl'  => $r1desc_size));


     if( count($roles) == 0 && $this->obj->rsel1 == $tutos[default_role] )
       $default_role = $tutos[default_first_role];
     else
       $default_role = $this->obj->rsel1;

     $this->assign("role1",
		   array('name'     => 'role1',
			 'label'    => $lang['ProdRolesNew'],
			 'options'  => $proles,
			 'selected' => $default_role));

     if( isset($this->obj->xl['r1']) ) {
       $r1fns = array();
       foreach( $this->obj->xl['r1'] as $i => $f )
	 $r1fns[$i] = myentities($f->getFullName());

       $this->assign("r1l",
		     array('id'      => "r1",
			   'name'    => "r1id",
			   'options' => $r1fns));
     }

     $r1fn = "";
     if( $this->obj->xfn['r1'] != "" )
       $r1fn = $this->obj->xfn['r1'];
     else
       if( isset($this->obj->r1) )
	 $r1fn = myentities($this->obj->r1->getFullName());

     $this->assign("r1fn",
		   array('id'      => "r1",
			 'name'    => "r1fn",
			 'value'   => $r1fn,
			 'select'  => isset($this->obj->xl['r1'])));

     
     /**
      * Relations to other Products
      */
     $this->assign('ProdProd', $lang['ProdProd']);

     // List all projectroles in this project
     $prodroles = array();
     if ( $this->obj->id > 0 ) {
       $n = 0;
       foreach ($lang['ProdRole'] as $role => $x) {
         if ( isset($this->obj->role[$role]) ) {
           foreach ($this->obj->role[$role] as $i => $o) {
             if ( $o->id < 1 ) {
               continue;
             }
             if ( $o->getType() != "product" ) {
               continue;
             }
             $val = $o->id .",". $role;
             if ( ! isset($this->obj->rdel[$val]) ) {
               $this->obj->rdel[$val] = "";
             }

	     $prodroles[] = array('name'  => $lang['ProdRole'][$role],
				  'link'  => $o->getLink(),
				  'desc'  => $this->obj->roledesc[$role][$i],
				  'del_val' => $val,
				  'del_lab' => $this->obj->rdel[$val]);
             $n++;
           }
         }
       }
     }
     $this->assign('prodroles', $prodroles);

     /**
      * New Product Relation
      */
     $this->assign('ProdProdNew', $lang['ProdProdNew']);

     $rels = array();
     foreach ($lang['ProdRole'] as $role => $x) {
       # No Product Roles
       if ( $tutos[rolecheck][$role] != "p") {
         continue;
       }
       $rels[$role] = myentities($lang['ProdRole'][$role]);
     }
     $this->assign("role2",
		   array('name'    => 'role2',
			 'label'   => $lang['ProdProdNew'],
			 'options' => $rels));

     $r2fn = "";

     if( isset($this->obj->xl['r2']) ) {
       $r2fns = array();
       foreach( $this->obj->xl['r2'] as $i => $f )
	 $r2fns[$i] = myentities($f->getFullName());

       $r2fn = $this->obj->xfn['r2'];

       $this->assign("r2l",
		     array('id'      => "r2",
			   'name'    => "r2id",
			   'options' => $r2fns));
     }

     if( $r2fn == "" && isset($this->obj->r2) )
       $r2fn = myentities($this->obj->r2->getFullName());

     $this->assign("r2fn",
		   array('id'      => "r2",
			 'name'    => "r2fn",
			 'value'   => $r2fn,
			 'select'  => isset($this->obj->xl['r2'])));



     $r2desc_size = $table['product2']['description'][size];
     $this->assign("r2desc",
		   array('name'  => 'r2desc',
			 'value' => myentities($this->r2desc),
			 'size'  => min(30, $r2desc_size),
			 'maxl'  => $r2desc_size));

     // Descriptions
     $this->assign("desc0",
		   array('name'  => 'description',
			 'label' => $lang['ProdDesc'],
			 'value' => myentities($this->obj->description)));

     $this->assign("desc1",
		   array('name'  => 'desc1',
			 'label' => $lang['ProdDesc1'],
			 'value' => myentities($this->obj->desc1)));

     $this->assign("desc2",
		   array('name'  => 'desc2',
			 'label' => $lang['ProdDesc2'],
			 'value' => myentities($this->obj->desc2)));

     // Classification
     $classes = array();
     for ( $cl = 1;$cl <= $this->obj->classes; $cl++) {
       $options = $this->obj->cl[$cl];
       if( isset($options) && count($options) > 0 )
	 $classes[] = array('name'    =>  "cl".$cl,
			    'label'   => $lang['ProdClass'.$cl],
			    'options' => $options,
			    'wanted'  => $tutos[classify_products] == 1);
     }
     $this->assign("classes", $classes);

     $this->assign("price",
		   array('name'  => 'price',
			 'label' => $lang['ProdPrice'],
			 'value' => number_format($this->obj->price, 2,
						  $lang['DecPoint'],
						  $lang['ThousandPoint'])));

     $this->assign("cost",
		   array('name'  => 'cost',
			 'label' => $lang['ProdCost'],
			 'value' => number_format($this->obj->cost, 2,
						  $lang['DecPoint'],
						  $lang['ThousandPoint'])));

     $this->assign('currency',
		   array('name'     => 'currency',
			 'label'    => $lang['Currency'],
			 'options'  => $tutos[currencies],
			 'selected' => $this->obj->currency));

     // Dates
     $this->assign();
     $this->assign_date($lang['ProdStart'], "p_start", $this->obj->p_start);
     $this->assign_date($lang['ProdEnd'], "p_end", $this->obj->p_end);

     // Product Path
     $this->assign('path',
		   array('name'  => 'path',
			 'label' => $lang['ProdPath'],
			 'value' => myentities($this->obj->path),
			 'size'  => min(60, $table['product']['path'][size]),
			 'maxl'  => $table['product']['path'][size]));

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "productadd.name");

     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('product_new');

     /*
     module_addforms($this->user,$this->obj,5);
     */
   }

   /**
    * navigate
    */
   Function navigate() {
     // menu
     $x = product::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = "projects";
     $this->addmenu($x);

     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array('url'   => "product_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'projects',
                  'info'  => $lang['ProdCreateInfo'],
                  'category' => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'   => $this->obj->getDelURL(),
                  'text'  => $lang['Delete'],
		  'image' => 'delete',
                  'info'  => sprintf($lang['ProdDelInfo'],
				   $this->obj->getFullname()),
                  'category' => array("product","del","obj"),
                  'confirm' => true
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->name = $lang['Product'];
     $this->obj = new product($this->dbconn);
     $this->r1desc = "";
     $this->r2desc = "";

     $this->template = false;
     
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = sprintf($lang['ProdModifyT'], myentities($this->obj->getFullName()));
       $this->obj->readroles();
     } else if ( isset($_GET['tplid']) ) {
       $this->obj->read($_GET['tplid']);
       $this->template = true;
       if ( $this->obj->tplid < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = sprintf($lang['ProdCloneT'],myentities($this->obj->getFullName()));
       $this->obj->readroles();
     } else {
       $this->name = $lang['ProdCreateT'];
       $this->obj->r1 = $this->user;
     }

     if ( isset($_GET['pid']) ) {
       $this->parent = new product($this->dbconn);
       $this->parent->read($_GET['pid']);

       
       $this->obj->parent = $this->parent;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['version']) ) {
       $this->obj->version = StripSlashes($_GET['version']);
     }
     if ( isset($_GET['desc1']) ) {
       $this->obj->desc1 = StripSlashes($_GET['desc1']);
     }
     if ( isset($_GET['desc2']) ) {
       $this->obj->desc2 = StripSlashes($_GET['desc2']);
     }
     if ( isset($_GET['description']) ) {
       $this->obj->description = StripSlashes($_GET['description']);
     }
     if ( isset($_GET['path']) ) {
       $this->obj->path = StripSlashes($_GET['path']);
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['price']) ) {
       $this->obj->price = $_GET['price'];
     }
     if ( isset($_GET['cost']) ) {
       $this->obj->cost = $_GET['cost'];
     }
     if ( isset($_GET['currency']) ) {
       $this->obj->currency = $_GET['currency'];
     }
     if ( isset($_GET['prob']) ) {
       $this->obj->probability = $_GET['prob'];
     }
     if ( isset($_GET['p_start']) ) {
       $this->obj->p_start->setDateTime($_GET['p_start']);
     }
     if ( isset($_GET['p_end']) ) {
       $this->obj->p_end->setDateTime($_GET['p_end']);
     }
     # People Team Relations
     if ( isset($_GET['r1id']) ) {
       $this->obj->role[1]->id = $_GET['r1id'];
     }
     if ( isset($_GET['r1fn']) ) {
       $this->obj->xfn['r1'] = StripSlashes($_GET['r1fn']);
       unset($this->obj->r1);
     }

     if ( isset($_GET['r1l']) ) {
       foreach($_GET['r1l'] as $x => $f) {
         $a = getObject($this->dbconn,$f);
         $this->obj->xl['r1'][$f] = $a;
       }
     }

     if( isset($_GET['parents']) ) {
       foreach($_GET['parents'] as $x => $f) {
         $a = getObject($this->dbconn,$f);
         $this->obj->xl['parent'][$f] = $a;
       }
     }

     if ( isset($_GET['role1']) ) {
       $this->obj->rsel1 = $_GET['role1'];
     } else {
       $this->obj->rsel1 = $tutos[default_role];
     }
     # Product Relations
     if ( isset($_GET['r2id']) ) {
       $this->obj->role[1]->id = $_GET['r2id'];
     }
     if ( isset($_GET['r2fn']) ) {
       $this->obj->xfn['r2'] = StripSlashes($_GET['r2fn']);
       unset($this->obj->r2);
     }
     if ( isset($_GET['r2l']) ) {
       foreach($_GET['r2l'] as $x => $f) {
         $a = getObject($this->dbconn,$f);
         $this->obj->xl['r2'][$f] = $a;
       }
     }
     if ( isset($_GET['role2']) ) {
       $this->obj->rsel2 = $_GET['role2'];
     } else {
       $this->obj->rsel2 = 1;
     }

     if ( isset($_GET['r1desc']) ) {
       $this->r1desc = StripSlashes($_GET['r1desc']);
     }
     if ( isset($_GET['r2desc']) ) {
       $this->r2desc = StripSlashes($_GET['r2desc']);
     }

     if ( isset($_GET['del']) ) {
       foreach($_GET['del'] as $i => $f) {
         $this->obj->rdel[$f] = "CHECKED";
       }
     }
     if ( (($this->obj->id < 0) || ($this->template)) && !$this->user->feature_ok(useprojects,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }


     $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
		 'text'  => $lang['AclDetail'],
		 'image' => 'acls',
		 'info'  => sprintf($lang['AclDetailI'],
				    $this->obj->getFullname()),
		 'category' => array("acl","obj")
                 );
     $this->addMenu($x);


     /*
     web_StackStartLayout($this,"product_new.php","product_new.php?".$_SERVER['QUERY_STRING']);     
     */
   }
 }

 $l = new product_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_new.php,v 1.76.2.13 2005/03/02 10:29:43 tapoueh Exp $
    $Author: tapoueh $
-->