<?php
/* Build the directory sources select widget. */
$source_options = '';
$criteria_options = '';
$js_criteria = "var criteriaOptions = new Array();\n";
$source_count = 0;
foreach (Turba::getAddressBooks() as $key => $entry) {
    $js_criteria .= "criteriaOptions[$source_count] = new Array()\n" .
        "criteriaOptions[$source_count][0] = '$key';\n";

    /* Build the criteria select widget. */
    $field_count = 1;
    foreach ($entry['search'] as $field) {
        $js_criteria .= "criteriaOptions[$source_count][$field_count] = new Array('$field', '" . $attributes[$field]['label'] . "');\n";
        if ($key == $source) {
            $selected = ($criteria == $field) ? ' selected="selected"' : '';
            $criteria_options .= "<option value=\"$field\"$selected>" .
                htmlspecialchars($attributes[$field]['label']) . "</option>\n";
        }
        $field_count++;
    }

    $selected = ($key == $source) ? ' selected="selected"' : '';
    $source_options .= "<option value=\"$key\"$selected>" .
        htmlspecialchars($entry['title']) . "</option>\n";

    $unique_source = $key;
    $source_count++;
}

/* Build search mode tabs. */
require_once 'Horde/UI/Tabs.php';
require_once 'Horde/Variables.php';
$sUrl = Horde::applicationUrl('search.php');
$vars = &Variables::getDefaultVariables();
$tabs = &new Horde_UI_Tabs('search_mode', $vars);
$tabs->addTab(_("Basic Search"), $sUrl, 'basic');
$tabs->addTab(_("Advanced Search"), $sUrl, 'advanced');
echo $tabs->render($_SESSION['turba_search_mode']);

if ($_SESSION['turba_search_mode'] == 'basic'): ?>
<script type="text/javascript">
<!--
<?php echo $js_criteria ?>
function updateCriterias()
{
    var f = document.directory_search;
    while (f.criteria.length > 0) {
        f.criteria.options[f.criteria.length-1] = null;
    }

    for (var i = 0; i < criteriaOptions.length; i++) {
        if (criteriaOptions[i][0] == f.source.options[f.source.selectedIndex].value) {
            for (var j = 1; j < criteriaOptions[i].length; j++) {
                f.criteria.options[f.criteria.length] = new Option(criteriaOptions[i][j][1], criteriaOptions[i][j][0]);
            }
            f.criteria.selectedIndex = 0;
            return;
        }
    }
}
//-->
</script>

<form name="directory_search" action="search.php" method="get">
<?php echo Util::formInput() ?>
<input type="hidden" name="actionID" value="1" />

<table cellspacing="5">
  <tr>
    <td class="light rightAlign"><strong><?php echo _("Find") ?></strong></td>
    <td class="item">
        <select name="criteria">
         <?php echo $criteria_options ?>
        </select>
    </td>

    <td class="light rightAlign"><strong><?php echo _("Matching") ?></strong></td>
    <td class="item">
        <input type="text" size="30" name="val" value="<?php echo htmlspecialchars($val) ?>" />
    </td>

<?php if (count($cfgSources) > 1): ?>
    <td class="light rightAlign"><strong><?php echo _("From") ?></strong></td>
    <td class="item">
        <select name="source" onchange="updateCriterias()">
         <?php echo $source_options ?>
        </select>
    </td>
<?php else: ?>
    <td>
        <input type="hidden" name="source" value="<?php reset($cfgSources); echo key($cfgSources) ?>" />
    </td>
<?php endif; ?>

    <td>
        <input class="button" type="submit" name="search" value="<?php echo _("Search") ?>" />
    </td>
  </tr>
</table>
</form>
<br />

<?php else: ?>

<form name="directory_search" action="search.php" method="get">
<?php echo Util::formInput() ?>

<table cellspacing="5" width="100%">
  <tr>
    <td>&nbsp;</td>
    <td>
      <input type="submit" class="button" name="search" value="<?php echo _("Search") ?>" />
      <input type="reset" class="button" name="reset" value="<?php echo _("Reset to Defaults") ?>" />
    </td>
  </tr>
 <?php if ($source_count > 1) : ?>
  <tr>
    <td class="light rightAlign"><strong><?php echo _("Directory") ?></strong></td>
    <td class="leftAlign">
      <select name="source" onchange="directory_search.submit()">
       <?php echo $source_options ?>
      </select>
    </td>
  </tr>
 <?php else: ?>
  <input type="hidden" name="source" value="<?php echo $unique_source ?>">
 <?php endif; ?>

<?php endif; ?>
