<?php
/**
 * $Horde: turba/data.php,v 1.70.4.2.2.1 2005/12/10 22:08:34 chuck Exp $
 *
 * Copyright 2001-2005 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file LICENSE for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

function _cleanup()
{
    global $import_step;
    $import_step = 1;
    return IMPORT_FILE;
}

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once 'Horde/Data.php';

if (!$conf['menu']['import_export']) {
    require TURBA_BASE . '/index.php';
    exit;
}

/* Importable file types. */
$file_types = array('csv'      => _("CSV"),
                    'tsv'      => _("TSV"),
                    'vcard'    => _("vCard"),
                    'mulberry' => _("Mulberry Address Book"),
                    'pine'     => _("Pine Address Book"));

/* Templates for the different import steps. */
$templates = array(
    IMPORT_FILE => array(TURBA_TEMPLATES . '/data/export.inc'),
    IMPORT_CSV => array($registry->get('templates', 'horde') . '/data/csvinfo.inc'),
    IMPORT_TSV => array($registry->get('templates', 'horde') . '/data/tsvinfo.inc'),
    IMPORT_MAPPED => array($registry->get('templates', 'horde') . '/data/csvmap.inc'),
    IMPORT_DATETIME => array($registry->get('templates', 'horde') . '/data/datemap.inc')
);

/* Initial values. */
$import_step = Util::getFormData('import_step', 0) + 1;
$actionID = Util::getFormData('actionID');
$next_step = IMPORT_FILE;
$app_fields = array();
$time_fields = array();
$error = false;
$outlook_mapping = array(
    'firstname' => 'first_name',
    'middlename' => 'middle_name',
    'lastname' => 'last_name',
    'e-mail' => 'email',
    'homeaddress' => 'homeAddress',
    'businessaddress' => 'workAddress',
    'homephone' => 'homePhone',
    'businessphone' => 'workPhone',
    'mobilephone' => 'cellPhone',
    'businessfax' => 'fax',
    'jobtitle' => 'title',
    'company' => 'company',
    'notes' => 'notes',
    'name' => 'name',
    'internetfreebusy' => 'freebusyUrl',
    'nickname' => 'alias',
    'pgpPublicKey' => 'pgpPublicKey',
    'smimePublicKey' => 'smimePublicKey',
    );
$param = array('time_fields' => $time_fields,
               'file_types'  => $file_types,
               'import_mapping' => $outlook_mapping);
$import_format = Util::getFormData('import_format', '');
$driver = $import_format;
if ($driver == 'mulberry' || $driver == 'pine') {
    $driver = 'tsv';
}
if ($actionID != 'select') {
    array_unshift($templates[IMPORT_FILE], TURBA_TEMPLATES . '/data/import.inc');
}

/* Loop through the action handlers. */
switch ($actionID) {
case 'export':
    $contacts = array();
    if (Util::getFormData('selected')) {
        foreach (Util::getFormData('objectkeys') as $objectkey) {
            list($source, $key) = explode(':', $objectkey, 2);
            if (!isset($contacts[$source])) {
                $contacts[$source] = array();
            }
            $contacts[$source][] = $key;
        }
    } else {
        $source = Util::getFormData('source');
        if (!isset($source) && isset($cfgSources) &&
            is_array($cfgSources) && count($cfgSources) > 0) {
            reset($cfgSources);
            $source = key($cfgSources);
        }
        $contacts[$source] = array();
    }

    $data = array();
    $all_fields = array();
    foreach ($contacts as $source => $fields) {
        /* Create a Turba storage instance. */
        $storage = &Turba_Driver::singleton($source, $cfgSources[$source]);
        if (is_a($storage, 'PEAR_Error')) {
            $notification->push(sprintf(_("Failed to access the address book: %s"), $storage->getMessage()), 'horde.error');
            $error = true;
            break;
        }
        /* Get the full, sorted address list. */
        if (count($fields)) {
            $addresses = &$storage->getObjects($fields);
        } else {
            $addresses = $storage->search(array());
            if (is_a($addresses, 'Turba_List')) {
                $addresses = $addresses->objects;
            }
        }
        if (is_a($addresses, 'PEAR_Error')) {
            $notification->push(sprintf(_("Failed to search the directory: %s"), $addresses->getMessage()), 'horde.error');
            $error = true;
            break;
        }
        $fields = $storage->getFields();
        $all_fields = array_merge($all_fields, $fields);
        $params = $storage->getParams();
        foreach ($addresses as $ob) {
            $row = array();
            foreach ($fields as $field) {
                if (substr($field, 0, 2) != '__') {
                    $attribute = $ob->getValue($field);
                    if ($attributes[$field]['type'] == 'date') {
                        $row[$field] = strftime('%Y-%m-%d', $attribute);
                    } elseif ($attributes[$field]['type'] == 'time') {
                        $row[$field] = strftime('%R', $attribute);
                    } elseif ($attributes[$field]['type'] == 'datetime') {
                        $row[$field] = strftime('%Y-%m-%d %R', $attribute);
                    } else {
                        $row[$field] = String::convertCharset($attribute, NLS::getCharset(), $params['charset']);
                    }
                }
            }
            $data[] = $row;
        }
    }
    if (count($data) == 0) {
        $notification->push(_("There were no addresses to export."), 'horde.message');
        $error = true;
        break;
    }

    /* Make sure that all rows have the same columns if exporting from
     * different sources. */
    if (count($contacts) > 1) {
        for ($i = 0; $i < count($data); $i++) {
            foreach ($all_fields as $field) {
                if (!isset($data[$i][$field])) {
                    $data[$i][$field] = '';
                }
            }
        }
    }

    $exportID = Util::getFormData('exportID');
    switch ($exportID) {
    case EXPORT_CSV:
        $csv = &Horde_Data::singleton('csv');
        $csv->exportFile(_("contacts.csv"), $data, true);
        exit;

    case EXPORT_OUTLOOKCSV:
        $csv = &Horde_Data::singleton('outlookcsv');
        $csv->exportFile(_("contacts.csv"), $data, true, array_flip($outlook_mapping));
        exit;

    case EXPORT_TSV:
        $tsv = &Horde_Data::singleton('tsv');
        $tsv->exportFile(_("contacts.tsv"), $data, true);
        exit;
    }
    break;

case IMPORT_FILE:
    $_SESSION['import_data']['target'] = Util::getFormData('dest');
    $_SESSION['import_data']['purge'] = Util::getFormData('purge');
    break;

case IMPORT_MAPPED:
case IMPORT_DATETIME:
    foreach ($cfgSources[$_SESSION['import_data']['target']]['map'] as $field => $null) {
        if (substr($field, 0, 2) != '__' && !is_array($null)) {
            if ($attributes[$field]['type'] == 'monthyear' ||
                $attributes[$field]['type'] == 'monthdayyear') {
                $time_fields[$field] = 'date';
            } elseif ($attributes[$field]['type'] == 'time') {
                $time_fields[$field] = 'time';
            }
        }
    }
    $param['time_fields'] = $time_fields;
    break;
}

if (!$error && !empty($driver)) {
    $data = &Horde_Data::singleton($driver);
    if (is_a($data, 'PEAR_Error')) {
        $notification->push(_("This file format is not supported."), 'horde.error');
        $next_step = IMPORT_FILE;
    } else {
        $next_step = $data->nextStep($actionID, $param);
        if (is_a($next_step, 'PEAR_Error')) {
            $notification->push($next_step->getMessage(), 'horde.error');
            $next_step = $data->cleanup();
        }
    }
}

/* We have a final result set. */
if (is_array($next_step)) {
    /* Create a Turba storage instance. */
    $dest = $_SESSION['import_data']['target'];
    $storage = &Turba_Driver::singleton($dest, $cfgSources[$dest]);
    if (is_a($storage, 'PEAR_Error')) {
        $notification->push(sprintf(_("Failed to access the address book: %s"), $storage->getMessage()), 'horde.error');
    } else {
        // Purge old address book if requested.
        if ($_SESSION['import_data']['purge']) {
            $result = $storage->deleteAll();
            if (is_a($result, 'PEAR_Error')) {
                $notification->push(sprintf(_("The address book could not be purged: %s"), $result->getMessage()), 'horde.error');
            } else {
                $notification->push(_("Address book successfully purged."), 'horde.success');
            }
        }

        $error = false;
        foreach ($next_step as $row) {
            if (is_a($row, 'Horde_iCalendar_vcard')) {
                $row = $storage->toHash($row);
            }
            $row['__owner'] = Auth::getAuth();
            $success = $storage->add($row);

            if (is_a($success, 'PEAR_Error')) {
                $notification->push(sprintf(_("There was an error importing the data: %s"),
                                            $success->getMessage()), 'horde.error');
                $error = true;
                break;
            }
        }
        if (!$error) {
            $notification->push(sprintf(_("%s file successfully imported"),
                                        $file_types[$_SESSION['import_data']['format']]), 'horde.success');
        }
    }
    $next_step = $data->cleanup();
}

switch ($next_step) {
case IMPORT_MAPPED:
case IMPORT_DATETIME:
    foreach ($cfgSources[$_SESSION['import_data']['target']]['map'] as $field => $null) {
        if (substr($field, 0, 2) != '__' && !is_array($null)) {
            $app_fields[$field] = $attributes[$field]['label'];
        }
    }
    break;
}

$title = _("Import/Export Address Books");
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_TEMPLATES . '/menu.inc';

$default_source = $prefs->getValue('default_dir');
if ($next_step == IMPORT_FILE) {
    /* Build the directory sources select widget. */
    $unique_source = '';
    $source_options = array();
    foreach ($cfgSources as $key => $entry) {
        $selected = ($key == $default_source) ? ' selected="selected"' : '';
        if (!empty($entry['export'])) {
            $source_options[] = '<option value="' . htmlspecialchars($key) . '"' . $selected . '>' .
                htmlspecialchars($entry['title']) . "</option>\n";
            $unique_source = $key;
        }
    }

    /* Build the directory destination select widget. */
    $unique_dest = '';
    $dest_options = array();
    $hasWriteable = false;
    foreach ($cfgSources as $key => $entry) {
        $selected = ($key == $default_source) ? ' selected="selected"' : '';
        if (empty($entry['readonly']) || (isset($entry['admin']) && in_array(Auth::getAuth(), $entry['admin']))) {
            $dest_options[] = '<option value="' . htmlspecialchars($key) . '"' . $selected . '>' .
                htmlspecialchars($entry['title']) . "</option>\n";
            $unique_dest = $key;
            $hasWriteable = true;
        }
    }

    if (!$hasWriteable) {
        array_shift($templates[$next_step]);
    }
}

foreach ($templates[$next_step] as $template) {
    require $template;
}
require $registry->get('templates', 'horde') . '/common-footer.inc';
