<?php
/*
 * $Horde: turba/addobjectaction.php,v 1.5.2.12 2005/01/03 11:26:03 jan Exp $
 *
 * Turba: Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

global $prefs;

$source = Horde::getFormData('source');
$driver = &Turba_Source::singleton($source, $cfgSources[$source]);
$object = Horde::getFormData('object');
foreach ($object as $key => $value) {
    if (isset($attributes[$key]) && $attributes[$key]['type'] == 'date') {
        if ($value['month'] == '' || $value['day'] == '' || $value['year'] == '') {
            $object[$key] = null;
        } else {
            $object[$key] = mktime(0, 0, 0, $value['month'], $value['day'], $value['year']);
        }
    }
}

/* Create Object */
$key = $driver->addObject($object);

if (!PEAR::isError($key)) {
    $url = Turba::addParameter('displayobject.php', 'source=' . urlencode($source));
    $url = Turba::addParameter($url, 'key=' . urlencode($key));
    header('Location: ' . Horde::applicationUrl($url, true));
} else {
    Horde::logMessage($key, __FILE__, __LINE__, LOG_ERR);
    Horde::raiseMessage(_("There was an error adding this object. Contact your system administrator for further help."), HORDE_ERROR);

    $title = _("Add failed");
    $js_onLoad = null;
    include TURBA_TEMPLATES . '/common-header.inc';
    include TURBA_BASE . '/menu.php';
    include TURBA_BASE . '/status.php';
    include TURBA_TEMPLATES . '/common-footer.inc';
}
